/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.vertiflex.p2relative;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.elk.alg.vertiflex.EdgeRoutingStrategy;
import org.eclipse.elk.alg.vertiflex.InternalProperties;
import org.eclipse.elk.alg.vertiflex.VertiFlexLayoutPhases;
import org.eclipse.elk.alg.vertiflex.options.VertiFlexOptions;
import org.eclipse.elk.alg.vertiflex.p2relative.NodeComparator;
import org.eclipse.elk.alg.vertiflex.p2relative.OutlineNode;
import org.eclipse.elk.core.alg.ILayoutPhase;
import org.eclipse.elk.core.alg.LayoutProcessorConfiguration;
import org.eclipse.elk.core.math.ElkMargin;
import org.eclipse.elk.core.options.CoreOptions;
import org.eclipse.elk.core.util.IElkProgressMonitor;
import org.eclipse.elk.core.util.Pair;
import org.eclipse.elk.graph.ElkEdge;
import org.eclipse.elk.graph.ElkNode;
import org.eclipse.elk.graph.properties.IProperty;

public class RelativeXPlacer
implements ILayoutPhase<VertiFlexLayoutPhases, ElkNode> {
    private double spacingNodeNode;
    private boolean considerNodeModelOrder;
    private static final double MINIMAL_Y = -100.0;

    public void process(ElkNode graph, IElkProgressMonitor progressMonitor) {
        progressMonitor.begin("XPlacer", 1.0f);
        this.spacingNodeNode = (Double)graph.getProperty(CoreOptions.SPACING_NODE_NODE);
        this.considerNodeModelOrder = (Boolean)graph.getProperty(VertiFlexOptions.CONSIDER_NODE_MODEL_ORDER);
        if (!graph.getChildren().isEmpty()) {
            ElkNode parent = (ElkNode)graph.getProperty(InternalProperties.ROOT_NODE);
            switch ((EdgeRoutingStrategy)((Object)graph.getProperty(VertiFlexOptions.LAYOUT_STRATEGY))) {
                case STRAIGHT: {
                    this.recursiveStraightlinePlacement(parent);
                    break;
                }
                case BEND: {
                    this.recursiveBentlinePlacement(parent);
                    break;
                }
            }
        }
        progressMonitor.done();
    }

    private double outlineDistance(OutlineNode outline1, OutlineNode outline2) {
        double newdist;
        double deltaY;
        double deltaX;
        OutlineNode changedOutline1 = new OutlineNode(outline1.getRelativeX(), -100.0, new OutlineNode(0.0, outline1.getAbsoluteY(), outline1.getNext()));
        OutlineNode changedOutline2 = new OutlineNode(outline2.getRelativeX(), -100.0, new OutlineNode(0.0, outline2.getAbsoluteY(), outline2.getNext()));
        double dist = changedOutline1.getRelativeX() - changedOutline2.getRelativeX();
        OutlineNode o1 = changedOutline1;
        OutlineNode o2 = changedOutline2;
        double x1 = o1.getRelativeX();
        double x2 = o2.getRelativeX();
        while (o1 != null && !o2.isLast()) {
            if (o2.getNext().getAbsoluteY() > o1.getAbsoluteY()) {
                deltaX = o2.getNext().getRelativeX();
                deltaY = o2.getNext().getAbsoluteY() - o2.getAbsoluteY();
                newdist = x1 - x2 - (o1.getAbsoluteY() - o2.getAbsoluteY()) * deltaX / deltaY;
                dist = Math.max(dist, newdist);
                if ((o1 = o1.getNext()) == null) continue;
                x1 += o1.getRelativeX();
                continue;
            }
            o2 = o2.getNext();
            x2 += o2.getRelativeX();
        }
        o1 = changedOutline1;
        o2 = changedOutline2;
        x1 = o1.getRelativeX();
        x2 = o2.getRelativeX();
        while (o2 != null && !o1.isLast()) {
            if (o1.getNext().getAbsoluteY() > o2.getAbsoluteY()) {
                deltaX = o1.getNext().getRelativeX();
                deltaY = o1.getNext().getAbsoluteY() - o1.getAbsoluteY();
                newdist = x1 - x2 + (o2.getAbsoluteY() - o1.getAbsoluteY()) * deltaX / deltaY;
                dist = Math.max(dist, newdist);
                if ((o2 = o2.getNext()) == null) continue;
                x2 += o2.getRelativeX();
                continue;
            }
            o1 = o1.getNext();
            x1 += o1.getRelativeX();
        }
        return dist;
    }

    private void recursiveStraightlinePlacement(ElkNode graph) {
        this.makeSimpleOutlines(graph);
        if (!graph.getOutgoingEdges().isEmpty()) {
            ArrayList<ElkNode> children = new ArrayList<ElkNode>();
            int i = 0;
            while (i < graph.getOutgoingEdges().size()) {
                ElkNode child = (ElkNode)((ElkEdge)graph.getOutgoingEdges().get(i)).getTargets().get(0);
                this.recursiveStraightlinePlacement(child);
                children.add(child);
                ++i;
            }
            this.sortSubTrees(children);
            i = 0;
            while (i < children.size() - 1) {
                this.bundleChildren((ElkNode)children.get(0), (ElkNode)children.get(i), (ElkNode)children.get(i + 1));
                ++i;
            }
            int pos = 0;
            double maxDepth = 0.0;
            int maxDepthStartPos = 0;
            while (pos < children.size() && ((ElkNode)children.get(pos)).getY() >= maxDepth) {
                if (((ElkNode)children.get(pos)).getY() > maxDepth) {
                    maxDepthStartPos = pos;
                    maxDepth = ((ElkNode)children.get(pos)).getY();
                }
                ++pos;
            }
            double moveRoot = 0.0;
            if (pos > 0) {
                moveRoot = (((ElkNode)children.get(maxDepthStartPos)).getX() + ((ElkNode)children.get(pos - 1)).getX() + ((ElkNode)children.get(pos - 1)).getWidth()) / 2.0 - graph.getX() - graph.getWidth() / 2.0;
            }
            if (!((Boolean)graph.getProperty(VertiFlexOptions.CONSIDER_NODE_MODEL_ORDER)).booleanValue()) {
                double newMoveRoot;
                double posX;
                int j;
                int i2;
                double betterMoveRoot = (((ElkNode)children.get(0)).getX() + ((ElkNode)children.get(children.size() - 1)).getX() + ((ElkNode)children.get(children.size() - 1)).getWidth() - graph.getWidth()) / 2.0 - graph.getX();
                if (betterMoveRoot < moveRoot) {
                    i2 = 0;
                    while (i2 < maxDepthStartPos) {
                        j = i2 + 1;
                        while (j < maxDepthStartPos + 1) {
                            OutlineNode rightOutline = (OutlineNode)((ElkNode)children.get(i2)).getProperty(InternalProperties.RIGHT_OUTLINE);
                            double rightOutlineX = ((ElkNode)children.get(i2)).getX() + rightOutline.getRelativeX();
                            posX = ((ElkNode)children.get(j)).getX() + ((ElkNode)children.get(j)).getWidth() / 2.0;
                            while (rightOutline != null && rightOutline.getAbsoluteY() < maxDepth) {
                                newMoveRoot = posX - graph.getWidth() / 2.0 + (posX - rightOutlineX) * (graph.getY() + graph.getHeight() - maxDepth) / (maxDepth - rightOutline.getAbsoluteY());
                                betterMoveRoot = Math.max(betterMoveRoot, newMoveRoot);
                                if ((rightOutline = rightOutline.getNext()) == null) continue;
                                rightOutlineX += rightOutline.getRelativeX();
                            }
                            ++j;
                        }
                        ++i2;
                    }
                    moveRoot = betterMoveRoot;
                }
                if (betterMoveRoot > moveRoot) {
                    i2 = pos;
                    while (i2 < children.size()) {
                        j = pos - 1;
                        while (j < i2) {
                            OutlineNode leftOutline = (OutlineNode)((ElkNode)children.get(i2)).getProperty(InternalProperties.LEFT_OUTLINE);
                            double leftOutlineX = ((ElkNode)children.get(i2)).getX() + leftOutline.getRelativeX();
                            posX = ((ElkNode)children.get(j)).getX() + ((ElkNode)children.get(j)).getWidth() / 2.0;
                            while (leftOutline != null && leftOutline.getAbsoluteY() < maxDepth) {
                                newMoveRoot = posX - graph.getWidth() / 2.0 + (posX - leftOutlineX) * (graph.getY() + graph.getHeight() - maxDepth) / (maxDepth - leftOutline.getAbsoluteY());
                                betterMoveRoot = Math.min(betterMoveRoot, newMoveRoot);
                                if ((leftOutline = leftOutline.getNext()) == null) continue;
                                leftOutlineX += leftOutline.getRelativeX();
                            }
                            ++j;
                        }
                        ++i2;
                    }
                    moveRoot = betterMoveRoot;
                }
            }
            for (ElkNode child : children) {
                child.setX(child.getX() - moveRoot);
            }
            OutlineNode graphLeftOutline = (OutlineNode)graph.getProperty(InternalProperties.LEFT_OUTLINE);
            OutlineNode leftChildOutline = (OutlineNode)((ElkNode)children.get(0)).getProperty(InternalProperties.LEFT_OUTLINE);
            double newX = ((ElkNode)children.get(0)).getX() + leftChildOutline.getRelativeX() - graphLeftOutline.getRelativeX();
            graphLeftOutline.getNext().getNext().getNext().setNext(new OutlineNode(newX, leftChildOutline.getAbsoluteY(), leftChildOutline.getNext()));
            OutlineNode graphRightOutline = (OutlineNode)graph.getProperty(InternalProperties.RIGHT_OUTLINE);
            OutlineNode rightChildOutline = (OutlineNode)((ElkNode)children.get(children.size() - 1)).getProperty(InternalProperties.RIGHT_OUTLINE);
            newX = ((ElkNode)children.get(children.size() - 1)).getX() + rightChildOutline.getRelativeX() - graphRightOutline.getRelativeX();
            graphRightOutline.getNext().getNext().getNext().setNext(new OutlineNode(newX, rightChildOutline.getAbsoluteY(), rightChildOutline.getNext()));
            for (ElkNode child : children) {
                graph.setProperty(InternalProperties.OUTLINE_MAX_DEPTH, (Object)Math.max((Double)graph.getProperty(InternalProperties.OUTLINE_MAX_DEPTH), (Double)child.getProperty(InternalProperties.OUTLINE_MAX_DEPTH)));
                graph.setProperty(InternalProperties.MIN_X, (Object)Math.min((Double)graph.getProperty(InternalProperties.MIN_X), child.getX() + (Double)child.getProperty(InternalProperties.MIN_X)));
                graph.setProperty(InternalProperties.MAX_X, (Object)Math.max((Double)graph.getProperty(InternalProperties.MAX_X), child.getX() + (Double)child.getProperty(InternalProperties.MAX_X)));
            }
            graph.setProperty(InternalProperties.MAX_Y, (Object)((Double)graph.getProperty(InternalProperties.OUTLINE_MAX_DEPTH)));
        }
    }

    private void recursiveBentlinePlacement(ElkNode graph) {
        this.makeSimpleOutlines(graph);
        if (!graph.getOutgoingEdges().isEmpty()) {
            ArrayList<ElkNode> children = new ArrayList<ElkNode>();
            int i = 0;
            while (i < graph.getOutgoingEdges().size()) {
                ElkNode child = (ElkNode)((ElkEdge)graph.getOutgoingEdges().get(i)).getTargets().get(0);
                this.recursiveBentlinePlacement(child);
                children.add(child);
                ++i;
            }
            int childrenSize = children.size();
            int i2 = 0;
            while (i2 < children.size() - 1) {
                this.bundleChildren((ElkNode)children.get(0), (ElkNode)children.get(i2), (ElkNode)children.get(i2 + 1));
                ++i2;
            }
            double moveRoot = (((ElkNode)children.get(0)).getX() + ((ElkNode)children.get(0)).getWidth() / 2.0 + ((ElkNode)children.get(children.size() - 1)).getX() + ((ElkNode)children.get(children.size() - 1)).getWidth() / 2.0 - graph.getWidth()) / 2.0 - graph.getX();
            for (ElkNode child : children) {
                child.setX(child.getX() - moveRoot);
                child.setProperty(InternalProperties.EDGE_BEND_HEIGHT, (Object)((OutlineNode)child.getProperty(InternalProperties.LEFT_OUTLINE)).getAbsoluteY());
            }
            int i3 = 0;
            while (i3 < childrenSize - 1 && ((ElkNode)children.get(i3)).getX() + ((ElkNode)children.get(i3)).getWidth() + ((ElkMargin)((ElkNode)children.get((int)i3)).getProperty((IProperty)CoreOptions.MARGINS)).right - graph.getWidth() / 2.0 <= 0.0) {
                ++i3;
            }
            double globalBendHeight = (Double)((ElkNode)children.get(i3)).getProperty(InternalProperties.EDGE_BEND_HEIGHT);
            int a = 0;
            while (a < childrenSize) {
                if (globalBendHeight < (Double)((ElkNode)children.get(a)).getProperty(InternalProperties.EDGE_BEND_HEIGHT)) {
                    ((ElkNode)children.get(a)).setProperty(InternalProperties.EDGE_BEND_HEIGHT, (Object)globalBendHeight);
                } else {
                    globalBendHeight = (Double)((ElkNode)children.get(a)).getProperty(InternalProperties.EDGE_BEND_HEIGHT);
                }
                ++a;
            }
            i3 = childrenSize - 1;
            while (i3 > 0 && ((ElkNode)children.get(i3)).getX() - ((ElkMargin)((ElkNode)children.get((int)i3)).getProperty((IProperty)CoreOptions.MARGINS)).left - graph.getWidth() / 2.0 >= 0.0) {
                --i3;
            }
            if (i3 < childrenSize) {
                a = i3;
                while (a >= 0) {
                    if (globalBendHeight < (Double)((ElkNode)children.get(a)).getProperty(InternalProperties.EDGE_BEND_HEIGHT)) {
                        ((ElkNode)children.get(a)).setProperty(InternalProperties.EDGE_BEND_HEIGHT, (Object)globalBendHeight);
                    } else {
                        globalBendHeight = (Double)((ElkNode)children.get(a)).getProperty(InternalProperties.EDGE_BEND_HEIGHT);
                    }
                    --a;
                }
            }
            OutlineNode leftChildOutline = (OutlineNode)((ElkNode)children.get(0)).getProperty(InternalProperties.LEFT_OUTLINE);
            OutlineNode graphLeftOutline = (OutlineNode)graph.getProperty(InternalProperties.LEFT_OUTLINE);
            double newX = ((ElkNode)children.get(0)).getX() + leftChildOutline.getRelativeX() - graphLeftOutline.getRelativeX();
            OutlineNode newOutlinepart = new OutlineNode(0.0, leftChildOutline.getAbsoluteY(), leftChildOutline.getNext());
            graphLeftOutline.getNext().getNext().getNext().setNext(new OutlineNode(newX, (Double)((ElkNode)children.get(0)).getProperty(InternalProperties.EDGE_BEND_HEIGHT), newOutlinepart));
            OutlineNode graphRightOutline = (OutlineNode)graph.getProperty(InternalProperties.RIGHT_OUTLINE);
            OutlineNode rightChildOutline = (OutlineNode)((ElkNode)children.get(childrenSize - 1)).getProperty(InternalProperties.RIGHT_OUTLINE);
            newX = ((ElkNode)children.get(childrenSize - 1)).getX() + rightChildOutline.getRelativeX() - graphRightOutline.getRelativeX();
            newOutlinepart = new OutlineNode(0.0, rightChildOutline.getAbsoluteY(), rightChildOutline.getNext());
            graphRightOutline.getNext().getNext().getNext().setNext(new OutlineNode(newX, (Double)((ElkNode)children.get(childrenSize - 1)).getProperty(InternalProperties.EDGE_BEND_HEIGHT), newOutlinepart));
            for (ElkNode child : children) {
                graph.setProperty(InternalProperties.OUTLINE_MAX_DEPTH, (Object)Math.max((Double)graph.getProperty(InternalProperties.OUTLINE_MAX_DEPTH), (Double)child.getProperty(InternalProperties.OUTLINE_MAX_DEPTH)));
                graph.setProperty(InternalProperties.MIN_X, (Object)Math.min((Double)graph.getProperty(InternalProperties.MIN_X), child.getX() + (Double)child.getProperty(InternalProperties.MIN_X)));
                graph.setProperty(InternalProperties.MAX_X, (Object)Math.max((Double)graph.getProperty(InternalProperties.MAX_X), child.getX() + (Double)child.getProperty(InternalProperties.MAX_X)));
            }
            graph.setProperty(InternalProperties.MAX_Y, (Object)((Double)graph.getProperty(InternalProperties.OUTLINE_MAX_DEPTH)));
        }
    }

    private void sortSubTrees(List<ElkNode> children) {
        Collections.sort(children, new NodeComparator(false));
        ArrayList<ElkNode> a = new ArrayList<ElkNode>();
        ArrayList<ElkNode> b = new ArrayList<ElkNode>();
        if (this.considerNodeModelOrder) {
            this.splitNodesWithModelOrder(children, a, b);
        } else {
            a.add(children.get(children.size() - 1));
            double widthA = 0.0;
            double widthB = 0.0;
            int i = 1;
            while (i < children.size()) {
                if (widthA <= widthB) {
                    a.add(children.get(children.size() - 1 - i));
                    widthA += children.get(children.size() - 1 - i).getWidth();
                } else {
                    b.add(children.get(children.size() - 1 - i));
                    widthB += children.get(children.size() - 1 - i).getWidth();
                }
                ++i;
            }
            Collections.reverse(a);
        }
        Collections.sort(b, new NodeComparator(true));
        a.addAll(b);
        int i = 0;
        while (i < children.size()) {
            children.set(i, (ElkNode)a.get(i));
            ++i;
        }
    }

    private void splitNodesWithModelOrder(List<ElkNode> original, List<ElkNode> left, List<ElkNode> right) {
        if (original.size() == 0) {
            return;
        }
        if (original.size() == 1) {
            left.add(original.get(0));
        }
        if (original.size() == 2) {
            ElkNode first = original.get(0);
            ElkNode second = original.get(1);
            if ((Integer)first.getProperty(InternalProperties.NODE_MODEL_ORDER) > (Integer)second.getProperty(InternalProperties.NODE_MODEL_ORDER)) {
                left.add(second);
                right.add(first);
            } else {
                left.add(first);
                right.add(second);
            }
        }
        ArrayList<Object> currentGroup = new ArrayList<ElkNode>();
        Pair widthLeftRight = new Pair();
        widthLeftRight.setFirst((Object)0.0);
        widthLeftRight.setSecond((Object)0.0);
        ElkNode current = original.get(0);
        currentGroup.add(current);
        int i = 1;
        while (i < original.size()) {
            int finalIndexOfLeft;
            ElkNode next = original.get(i);
            if (Double.compare(current.getY(), next.getY()) == 0) {
                currentGroup.add(next);
            } else {
                finalIndexOfLeft = this.splitGroup(currentGroup, (Pair<Double, Double>)widthLeftRight);
                left.addAll(currentGroup.subList(0, finalIndexOfLeft + 1));
                right.addAll(currentGroup.subList(finalIndexOfLeft + 1, currentGroup.size()));
                currentGroup = new ArrayList();
                currentGroup.add(next);
            }
            current = next;
            if (i == original.size() - 1) {
                finalIndexOfLeft = this.splitGroup(currentGroup, (Pair<Double, Double>)widthLeftRight);
                left.addAll(currentGroup.subList(0, finalIndexOfLeft + 1));
                right.addAll(currentGroup.subList(finalIndexOfLeft + 1, currentGroup.size()));
            }
            ++i;
        }
    }

    private int splitGroup(List<ElkNode> group, Pair<Double, Double> widthLeftRight) {
        if (group.size() == 1) {
            return 0;
        }
        double widthLeft = (Double)widthLeftRight.getFirst();
        double widthRight = (Double)widthLeftRight.getSecond();
        double totalNewWidth = 0.0;
        for (ElkNode node : group) {
            totalNewWidth += node.getWidth();
        }
        double desiredLeft = (totalNewWidth - widthLeft + widthRight) / 2.0;
        int i = 0;
        double newLeftWidth = 0.0;
        while (desiredLeft < newLeftWidth && i < group.size()) {
            newLeftWidth += group.get(i).getWidth();
        }
        double exceed = newLeftWidth - desiredLeft;
        double under = desiredLeft - (newLeftWidth - group.get(i).getWidth());
        int resultIndex = exceed > under ? i : i - 1;
        widthLeftRight.setFirst((Object)(widthLeft + exceed));
        double newRightWidth = 0.0;
        int j = resultIndex + 1;
        while (j < group.size()) {
            newRightWidth += group.get(j).getWidth();
            ++j;
        }
        widthLeftRight.setSecond((Object)(widthRight + newRightWidth));
        return resultIndex;
    }

    private void makeSimpleOutlines(ElkNode graph) {
        ElkMargin margins = (ElkMargin)graph.getProperty(CoreOptions.MARGINS);
        OutlineNode endpart = new OutlineNode(0.0, graph.getY() + graph.getHeight() + margins.bottom + this.spacingNodeNode / 2.0, new OutlineNode(graph.getWidth() / 2.0, graph.getY() + graph.getHeight() + margins.bottom + this.spacingNodeNode / 2.0, null));
        graph.setProperty(InternalProperties.LEFT_OUTLINE, (Object)new OutlineNode(-margins.left - this.spacingNodeNode / 2.0 + graph.getWidth() / 2.0, graph.getY() - margins.top - this.spacingNodeNode / 2.0, new OutlineNode(-graph.getWidth() / 2.0, graph.getY() - margins.top, endpart)));
        endpart = new OutlineNode(0.0, graph.getY() + graph.getHeight() + margins.bottom, new OutlineNode(-graph.getWidth() / 2.0, graph.getY() + graph.getHeight() + margins.bottom + this.spacingNodeNode / 2.0, null));
        graph.setProperty(InternalProperties.RIGHT_OUTLINE, (Object)new OutlineNode(graph.getWidth() / 2.0 + margins.right + this.spacingNodeNode / 2.0, graph.getY() - margins.top, new OutlineNode(graph.getWidth() / 2.0, graph.getY() - margins.top - this.spacingNodeNode / 2.0, endpart)));
        graph.setProperty(InternalProperties.MIN_X, (Object)(graph.getX() - margins.left));
        graph.setProperty(InternalProperties.MAX_X, (Object)(graph.getX() + margins.right + graph.getWidth()));
        graph.setProperty(InternalProperties.MIN_Y, (Object)(graph.getY() - margins.top));
        graph.setProperty(InternalProperties.MAX_Y, (Object)(graph.getY() + margins.bottom + graph.getHeight()));
        graph.setProperty(InternalProperties.OUTLINE_MAX_DEPTH, (Object)((OutlineNode)graph.getProperty(InternalProperties.LEFT_OUTLINE)).getNext().getNext().getAbsoluteY());
    }

    private void bundleChildren(ElkNode leftSubtree, ElkNode a, ElkNode b) {
        OutlineNode newNext;
        double newX;
        double change;
        double deltaY;
        double deltaX;
        double dist = this.outlineDistance((OutlineNode)a.getProperty(InternalProperties.RIGHT_OUTLINE), (OutlineNode)b.getProperty(InternalProperties.LEFT_OUTLINE));
        b.setX(a.getX() + dist);
        if ((Double)leftSubtree.getProperty(InternalProperties.OUTLINE_MAX_DEPTH) < (Double)b.getProperty(InternalProperties.OUTLINE_MAX_DEPTH)) {
            OutlineNode lastL = (OutlineNode)leftSubtree.getProperty(InternalProperties.LEFT_OUTLINE);
            double lAbsX = lastL.getRelativeX() + leftSubtree.getX();
            while (!lastL.isLast()) {
                lastL = lastL.getNext();
                lAbsX += lastL.getRelativeX();
            }
            OutlineNode bItterator = new OutlineNode(((OutlineNode)b.getProperty(InternalProperties.LEFT_OUTLINE)).getRelativeX(), -100.0, ((OutlineNode)b.getProperty(InternalProperties.LEFT_OUTLINE)).getNext());
            double rAbsX = bItterator.getRelativeX() + b.getX();
            while (bItterator.getNext().getAbsoluteY() <= lastL.getAbsoluteY()) {
                bItterator = bItterator.getNext();
                rAbsX += bItterator.getRelativeX();
            }
            deltaX = bItterator.getNext().getRelativeX();
            deltaY = bItterator.getNext().getAbsoluteY() - bItterator.getAbsoluteY();
            change = (lastL.getAbsoluteY() - bItterator.getAbsoluteY()) * deltaX / deltaY;
            newX = -lAbsX + rAbsX + change;
            newNext = new OutlineNode(bItterator.getNext().getRelativeX() - change, bItterator.getNext().getAbsoluteY(), bItterator.getNext().getNext());
            lastL.setNext(new OutlineNode(newX, lastL.getAbsoluteY(), newNext));
            leftSubtree.setProperty(InternalProperties.OUTLINE_MAX_DEPTH, (Object)((Double)b.getProperty(InternalProperties.OUTLINE_MAX_DEPTH)));
        }
        if ((Double)b.getProperty(InternalProperties.OUTLINE_MAX_DEPTH) < (Double)a.getProperty(InternalProperties.OUTLINE_MAX_DEPTH)) {
            OutlineNode lastB = (OutlineNode)b.getProperty(InternalProperties.RIGHT_OUTLINE);
            double rAbsX = lastB.getRelativeX() + b.getX();
            while (!lastB.isLast()) {
                lastB = lastB.getNext();
                rAbsX += lastB.getRelativeX();
            }
            OutlineNode aItterator = new OutlineNode(((OutlineNode)a.getProperty(InternalProperties.RIGHT_OUTLINE)).getRelativeX(), -100.0, ((OutlineNode)a.getProperty(InternalProperties.RIGHT_OUTLINE)).getNext());
            double aAbsX = aItterator.getRelativeX() + a.getX();
            while (aItterator.getNext().getAbsoluteY() <= lastB.getAbsoluteY()) {
                aItterator = aItterator.getNext();
                aAbsX += aItterator.getRelativeX();
            }
            deltaX = aItterator.getNext().getRelativeX();
            deltaY = aItterator.getNext().getAbsoluteY() - aItterator.getAbsoluteY();
            change = (lastB.getAbsoluteY() - aItterator.getAbsoluteY()) * deltaX / deltaY;
            newX = aAbsX - rAbsX + change;
            newNext = new OutlineNode(aItterator.getNext().getRelativeX() - change, aItterator.getNext().getAbsoluteY(), aItterator.getNext().getNext());
            lastB.setNext(new OutlineNode(newX, lastB.getAbsoluteY(), newNext));
            b.setProperty(InternalProperties.OUTLINE_MAX_DEPTH, (Object)((Double)a.getProperty(InternalProperties.OUTLINE_MAX_DEPTH)));
        }
    }

    public LayoutProcessorConfiguration<VertiFlexLayoutPhases, ElkNode> getLayoutProcessorConfiguration(ElkNode graph) {
        return null;
    }
}

