/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.synchronize;

import java.net.URISyntaxException;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.egit.core.internal.credentials.EGitCredentialsProvider;
import org.eclipse.egit.core.synchronize.dto.GitSynchronizeData;
import org.eclipse.egit.core.synchronize.dto.GitSynchronizeDataSet;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.fetch.FetchOperationUI;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

class SynchronizeFetchJob
extends WorkspaceJob {
    private final GitSynchronizeDataSet gsdSet;

    SynchronizeFetchJob(GitSynchronizeDataSet gsdSet) {
        super(UIText.SynchronizeFetchJob_JobName);
        this.gsdSet = gsdSet;
    }

    public IStatus runInWorkspace(IProgressMonitor monitor) {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)this.gsdSet.size());
        progress.setTaskName(UIText.SynchronizeFetchJob_TaskName);
        for (GitSynchronizeData gsd : this.gsdSet) {
            RemoteConfig config;
            Repository repo = gsd.getRepository();
            StoredConfig repoConfig = repo.getConfig();
            String remoteName = gsd.getDstRemoteName();
            if (remoteName == null) {
                progress.worked(1);
                continue;
            }
            progress.subTask(NLS.bind((String)UIText.SynchronizeFetchJob_SubTaskName, (Object)remoteName));
            try {
                config = new RemoteConfig((Config)repoConfig, remoteName);
            }
            catch (URISyntaxException e) {
                Activator.logError(e.getMessage(), e);
                progress.worked(1);
                continue;
            }
            FetchOperationUI fetchOperationUI = new FetchOperationUI(repo, config, false);
            fetchOperationUI.setCredentialsProvider((CredentialsProvider)new EGitCredentialsProvider());
            try {
                fetchOperationUI.execute((IProgressMonitor)progress.newChild(1));
                gsd.updateRevs();
            }
            catch (Exception e) {
                this.showInformationDialog(remoteName);
                Activator.logError(e.getMessage(), e);
            }
        }
        return Status.OK_STATUS;
    }

    private void showInformationDialog(final String remoteName) {
        final Display display = PlatformUI.getWorkbench().getDisplay();
        display.syncExec(new Runnable(){

            @Override
            public void run() {
                MessageDialog.openInformation((Shell)display.getActiveShell(), (String)NLS.bind((String)UIText.SynchronizeFetchJob_FetchFailedTitle, (Object)remoteName), (String)NLS.bind((String)UIText.SynchronizeFetchJob_FetchFailedMessage, (Object)UIText.GitPreferenceRoot_fetchBeforeSynchronization));
            }
        });
    }
}

