/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.model.pattern.util;

import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.egf.model.EGFModelsPlugin;
import org.eclipse.egf.model.pattern.AbstractPatternCall;
import org.eclipse.egf.model.pattern.BasicQuery;
import org.eclipse.egf.model.pattern.Call;
import org.eclipse.egf.model.pattern.CustomQuery;
import org.eclipse.egf.model.pattern.MethodCall;
import org.eclipse.egf.model.pattern.Pattern;
import org.eclipse.egf.model.pattern.PatternCall;
import org.eclipse.egf.model.pattern.PatternContext;
import org.eclipse.egf.model.pattern.PatternElement;
import org.eclipse.egf.model.pattern.PatternException;
import org.eclipse.egf.model.pattern.PatternExecutionReporter;
import org.eclipse.egf.model.pattern.PatternInjectedCall;
import org.eclipse.egf.model.pattern.PatternLibrary;
import org.eclipse.egf.model.pattern.PatternMethod;
import org.eclipse.egf.model.pattern.PatternNature;
import org.eclipse.egf.model.pattern.PatternPackage;
import org.eclipse.egf.model.pattern.PatternParameter;
import org.eclipse.egf.model.pattern.PatternVariable;
import org.eclipse.egf.model.pattern.PatternViewpoint;
import org.eclipse.egf.model.pattern.Query;
import org.eclipse.egf.model.pattern.StringQuery;
import org.eclipse.egf.model.pattern.SuperPatternCall;
import org.eclipse.egf.model.pattern.TypePatternExecutionReporter;
import org.eclipse.egf.model.types.util.TypesValidator;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.util.EObjectValidator;
import org.eclipse.emf.validation.model.EvaluationMode;
import org.eclipse.emf.validation.model.IConstraintStatus;
import org.eclipse.emf.validation.service.IBatchValidator;
import org.eclipse.emf.validation.service.ITraversalStrategy;
import org.eclipse.emf.validation.service.ModelValidationService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PatternValidator
extends EObjectValidator {
    public static final PatternValidator INSTANCE = new PatternValidator();
    public static final String DIAGNOSTIC_SOURCE = "org.eclipse.egf.model.pattern";
    private static final int GENERATED_DIAGNOSTIC_CODE_COUNT = 0;
    protected static final int DIAGNOSTIC_CODE_COUNT = 0;
    private final IBatchValidator batchValidator;
    protected TypesValidator typesValidator = TypesValidator.INSTANCE;

    public PatternValidator() {
        this.batchValidator = (IBatchValidator)ModelValidationService.getInstance().newValidator(EvaluationMode.BATCH);
        this.batchValidator.setTraversalStrategy((ITraversalStrategy)new ITraversalStrategy.Recursive());
        this.batchValidator.setIncludeLiveConstraints(true);
        this.batchValidator.setReportSuccesses(false);
    }

    protected EPackage getEPackage() {
        return PatternPackage.eINSTANCE;
    }

    public boolean validate(EClass eClass, EObject eObject, DiagnosticChain diagnostics, Map<Object, Object> context) {
        IStatus status = Status.OK_STATUS;
        super.validate(eClass, eObject, diagnostics, context);
        if (diagnostics != null && !this.hasProcessed(eObject, context)) {
            status = this.batchValidator.validate(eObject, (IProgressMonitor)new NullProgressMonitor());
            this.processed(eObject, context, status);
            this.appendDiagnostics(status, diagnostics);
        }
        return status.isOK();
    }

    protected boolean validate(int classifierID, Object value, DiagnosticChain diagnostics, Map<Object, Object> context) {
        switch (classifierID) {
            case 0: {
                return this.validatePattern((Pattern)value, diagnostics, context);
            }
            case 1: {
                return this.validatePatternMethod((PatternMethod)value, diagnostics, context);
            }
            case 2: {
                return this.validatePatternParameter((PatternParameter)value, diagnostics, context);
            }
            case 3: {
                return this.validatePatternLibrary((PatternLibrary)value, diagnostics, context);
            }
            case 4: {
                return this.validatePatternElement((PatternElement)value, diagnostics, context);
            }
            case 5: {
                return this.validatePatternViewpoint((PatternViewpoint)value, diagnostics, context);
            }
            case 6: {
                return this.validatePatternNature((PatternNature)value, diagnostics, context);
            }
            case 7: {
                return this.validatePatternCall((PatternCall)value, diagnostics, context);
            }
            case 8: {
                return this.validateSuperPatternCall((SuperPatternCall)value, diagnostics, context);
            }
            case 9: {
                return this.validateParamerter2ParameterMap((Map.Entry)value, diagnostics, context);
            }
            case 10: {
                return this.validateCall((Call)value, diagnostics, context);
            }
            case 11: {
                return this.validateMethodCall((MethodCall)value, diagnostics, context);
            }
            case 12: {
                return this.validatePatternVariable((PatternVariable)value, diagnostics, context);
            }
            case 13: {
                return this.validateAbstractPatternCall((AbstractPatternCall)value, diagnostics, context);
            }
            case 14: {
                return this.validatePatternInjectedCall((PatternInjectedCall)value, diagnostics, context);
            }
            case 15: {
                return this.validateQuery((Query)value, diagnostics, context);
            }
            case 16: {
                return this.validateBasicQuery((BasicQuery)value, diagnostics, context);
            }
            case 17: {
                return this.validateStringQuery((StringQuery)value, diagnostics, context);
            }
            case 18: {
                return this.validateCustomQuery((CustomQuery)value, diagnostics, context);
            }
            case 19: {
                return this.validateString2PatternList((Map.Entry)value, diagnostics, context);
            }
            case 20: {
                return this.validateTypePatternExecutionReporter((TypePatternExecutionReporter)value, diagnostics, context);
            }
            case 21: {
                return this.validatePatternContext((PatternContext)value, diagnostics, context);
            }
            case 22: {
                return this.validatePatternException((PatternException)value, diagnostics, context);
            }
            case 23: {
                return this.validateEPatternExecutionReporter((PatternExecutionReporter)value, diagnostics, context);
            }
        }
        return true;
    }

    public boolean validatePattern(Pattern pattern, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = this.validate_EveryMultiplicityConforms(pattern, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(pattern, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(pattern, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(pattern, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(pattern, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(pattern, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(pattern, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validatePattern_headerMethod(pattern, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validatePattern_footerMethod(pattern, diagnostics, context);
        }
        return result;
    }

    public boolean validatePattern_headerMethod(Pattern pattern, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (pattern.getHeaderMethod() != null && !pattern.getMethods().contains((Object)pattern.getHeaderMethod())) {
            if (diagnostics != null) {
                diagnostics.add((Diagnostic)this.createDiagnostic(4, DIAGNOSTIC_SOURCE, 0, "_UI_GenericConstraint_diagnostic", new Object[]{"Header Method should be a Pattern Method.", PatternValidator.getObjectLabel((EObject)pattern, context)}, new Object[]{pattern}, context));
            }
            return false;
        }
        return true;
    }

    public boolean validatePattern_footerMethod(Pattern pattern, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (pattern.getFooterMethod() != null && !pattern.getMethods().contains((Object)pattern.getFooterMethod())) {
            if (diagnostics != null) {
                diagnostics.add((Diagnostic)this.createDiagnostic(4, DIAGNOSTIC_SOURCE, 0, "_UI_GenericConstraint_diagnostic", new Object[]{"Footer Method should be a Pattern Method.", PatternValidator.getObjectLabel((EObject)pattern, context)}, new Object[]{pattern}, context));
            }
            return false;
        }
        return true;
    }

    public boolean validatePatternMethod(PatternMethod patternMethod, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(patternMethod, diagnostics, context);
    }

    public boolean validatePatternParameter(PatternParameter patternParameter, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(patternParameter, diagnostics, context);
    }

    public boolean validatePatternLibrary(PatternLibrary patternLibrary, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(patternLibrary, diagnostics, context);
    }

    public boolean validatePatternElement(PatternElement patternElement, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(patternElement, diagnostics, context);
    }

    public boolean validatePatternViewpoint(PatternViewpoint patternViewpoint, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(patternViewpoint, diagnostics, context);
    }

    public boolean validatePatternNature(PatternNature patternNature, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(patternNature, diagnostics, context);
    }

    public boolean validatePatternCall(PatternCall patternCall, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(patternCall, diagnostics, context);
    }

    public boolean validateSuperPatternCall(SuperPatternCall superPatternCall, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(superPatternCall, diagnostics, context);
    }

    public boolean validateParamerter2ParameterMap(Map.Entry<?, ?> paramerter2ParameterMap, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint((EObject)paramerter2ParameterMap, diagnostics, context);
    }

    public boolean validateCall(Call call, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(call, diagnostics, context);
    }

    public boolean validateMethodCall(MethodCall methodCall, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(methodCall, diagnostics, context);
    }

    public boolean validatePatternVariable(PatternVariable patternVariable, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(patternVariable, diagnostics, context);
    }

    public boolean validateAbstractPatternCall(AbstractPatternCall abstractPatternCall, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(abstractPatternCall, diagnostics, context);
    }

    public boolean validatePatternInjectedCall(PatternInjectedCall patternInjectedCall, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(patternInjectedCall, diagnostics, context);
    }

    public boolean validateQuery(Query query, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(query, diagnostics, context);
    }

    public boolean validateBasicQuery(BasicQuery basicQuery, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(basicQuery, diagnostics, context);
    }

    public boolean validateStringQuery(StringQuery stringQuery, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(stringQuery, diagnostics, context);
    }

    public boolean validateCustomQuery(CustomQuery customQuery, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(customQuery, diagnostics, context);
    }

    public boolean validateString2PatternList(Map.Entry<?, ?> string2PatternList, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint((EObject)string2PatternList, diagnostics, context);
    }

    public boolean validateTypePatternExecutionReporter(TypePatternExecutionReporter typePatternExecutionReporter, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = this.validate_EveryMultiplicityConforms(typePatternExecutionReporter, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(typePatternExecutionReporter, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(typePatternExecutionReporter, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(typePatternExecutionReporter, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(typePatternExecutionReporter, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(typePatternExecutionReporter, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(typePatternExecutionReporter, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.typesValidator.validateTypeAbstractClass_LoadableValue(typePatternExecutionReporter, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.typesValidator.validateTypeAbstractClass_ValidValue(typePatternExecutionReporter, diagnostics, context);
        }
        return result;
    }

    public boolean validatePatternContext(PatternContext patternContext, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public boolean validatePatternException(PatternException patternException, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public boolean validateEPatternExecutionReporter(PatternExecutionReporter ePatternExecutionReporter, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public ResourceLocator getResourceLocator() {
        return EGFModelsPlugin.INSTANCE;
    }

    private void processed(EObject eObject, Map<Object, Object> context, IStatus status) {
        if (context != null) {
            context.put(eObject, status);
        }
    }

    private boolean hasProcessed(EObject eObject, Map<Object, Object> context) {
        boolean result = false;
        if (context != null) {
            while (eObject != null) {
                if (context.containsKey(eObject)) {
                    result = true;
                    eObject = null;
                    continue;
                }
                eObject = eObject.eContainer();
            }
        }
        return result;
    }

    private void appendDiagnostics(IStatus status, DiagnosticChain diagnostics) {
        if (status.isMultiStatus()) {
            IStatus[] children = status.getChildren();
            int i = 0;
            while (i < children.length) {
                this.appendDiagnostics(children[i], diagnostics);
                ++i;
            }
        } else if (status instanceof IConstraintStatus) {
            diagnostics.add((Diagnostic)new BasicDiagnostic(status.getSeverity(), status.getPlugin(), status.getCode(), status.getMessage(), ((IConstraintStatus)status).getResultLocus().toArray()));
        }
    }
}

