/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.model.helper;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.egf.model.fcore.Activity;
import org.eclipse.egf.model.fcore.FactoryComponent;
import org.eclipse.egf.model.fcore.Invocation;
import org.eclipse.egf.model.fcore.ModelElement;
import org.eclipse.egf.model.fcore.Orchestration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActivityCycleFinder {
    private List<Activity> _activities = new ArrayList<Activity>();
    private Activity _activity;

    public ActivityCycleFinder(Activity activity) {
        Assert.isNotNull((Object)activity);
        this._activity = activity;
    }

    public ModelElement getFirstRepetition() {
        this._activities.clear();
        return this.getFirstRepetition(this._activity);
    }

    protected ModelElement getFirstRepetition(Activity activity) {
        if (activity instanceof FactoryComponent) {
            this._activities.add(activity);
            return this.getFirstRepetition(((FactoryComponent)activity).getOrchestration());
        }
        return null;
    }

    protected ModelElement getFirstRepetition(Orchestration orchestration) {
        for (Invocation invocation : orchestration.getInvocations()) {
            ModelElement element = this.getFirstRepetition(invocation);
            if (element == null) continue;
            return element;
        }
        return null;
    }

    protected ModelElement getFirstRepetition(Invocation<?> invocation) {
        if (invocation.getActivity() == null) {
            return null;
        }
        if (this.activityLookup((Activity)invocation.getActivity())) {
            return invocation;
        }
        return this.getFirstRepetition((Activity)invocation.getActivity());
    }

    private boolean activityLookup(Activity activity) {
        if (activity == null) {
            return false;
        }
        for (Activity innerActivity : this._activities) {
            if (!innerActivity.equals(activity)) continue;
            return true;
        }
        return false;
    }
}

