/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.common.emf;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;

public class DerivedAttributeAdapter
extends AdapterImpl {
    private final InternalEObject _source;
    private final EStructuralFeature _derivedFeature;
    private List<EStructuralFeature> _localFeatures = new ArrayList<EStructuralFeature>();
    private EStructuralFeature _dependantFeature = null;
    private EStructuralFeature _navigationFeature = null;
    private AdapterImpl dependantAdapter = new AdapterImpl(){

        public void notifyChanged(Notification msg) {
            if (msg.getEventType() == 1 && msg.getFeature().equals(DerivedAttributeAdapter.this._dependantFeature)) {
                DerivedAttributeAdapter.this.notifyDerivedAttributeChange();
            }
        }
    };

    public DerivedAttributeAdapter(EObject source, EStructuralFeature derivedFeature, EStructuralFeature navigationFeature, EStructuralFeature dependantFeature, EStructuralFeature localFeature) {
        this(source, derivedFeature);
        this.addNavigatedDependency(navigationFeature, dependantFeature);
        this.addLocalDependency(localFeature);
    }

    public DerivedAttributeAdapter(EObject source, EStructuralFeature derivedFeature, EStructuralFeature navigationFeature, EStructuralFeature dependantFeature) {
        this(source, derivedFeature);
        this.addNavigatedDependency(navigationFeature, dependantFeature);
    }

    public DerivedAttributeAdapter(EObject source, EStructuralFeature derivedFeature, EStructuralFeature localFeature) {
        this(source, derivedFeature);
        this.addLocalDependency(localFeature);
    }

    public DerivedAttributeAdapter(EObject source, EStructuralFeature derivedFeature) {
        this._source = (InternalEObject)source;
        this._derivedFeature = derivedFeature;
        source.eAdapters().add((Object)this);
    }

    public void addNavigatedDependency(EStructuralFeature navigationFeature, EStructuralFeature dependantFeature) {
        this._dependantFeature = dependantFeature;
        this._navigationFeature = navigationFeature;
    }

    public void addLocalDependency(EStructuralFeature localFeature) {
        this._localFeatures.add(localFeature);
    }

    public void notifyChanged(Notification notification) {
        if (notification.getFeature().equals(this._navigationFeature)) {
            switch (notification.getEventType()) {
                case 3: {
                    EObject added = (EObject)notification.getNewValue();
                    added.eAdapters().add((Object)this.dependantAdapter);
                    break;
                }
                case 1: {
                    EObject newValue = (EObject)notification.getNewValue();
                    EObject oldValue = (EObject)notification.getOldValue();
                    if (oldValue != null) {
                        oldValue.eAdapters().remove((Object)this.dependantAdapter);
                    }
                    if (newValue == null) break;
                    newValue.eAdapters().add((Object)this.dependantAdapter);
                    break;
                }
                case 4: {
                    EObject removed = (EObject)notification.getOldValue();
                    removed.eAdapters().remove((Object)this.dependantAdapter);
                    break;
                }
                default: {
                    return;
                }
            }
            this.notifyDerivedAttributeChange();
        } else if (this._localFeatures.contains(notification.getFeature())) {
            this.notifyDerivedAttributeChange();
        }
    }

    private void notifyDerivedAttributeChange() {
        if (this._source.eNotificationRequired()) {
            this._source.eNotify((Notification)new ENotificationImpl(this._source, 1, this._derivedFeature, null, this._source.eGet(this._derivedFeature, true, true)));
        }
    }
}

