/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.core.helper;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.core.resources.IResource;
import org.eclipse.egf.common.helper.URIHelper;
import org.eclipse.egf.core.EGFCorePlugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceHelper {
    private ResourceHelper() {
    }

    public static Resource createResource(ResourceSet resourceSet, IResource resource) {
        return ResourceHelper.createResource(resourceSet, URIHelper.getPlatformURI((IResource)resource));
    }

    public static Resource createResource(ResourceSet resourceSet, URI uri) {
        if (resourceSet == null || uri == null) {
            return null;
        }
        resourceSet.getURIConverter().getURIMap().clear();
        resourceSet.getURIConverter().getURIMap().putAll(EGFCorePlugin.computePlatformURIMap());
        return resourceSet.createResource(uri);
    }

    public static Resource loadResource(ResourceSet resourceSet, IResource resource) {
        return ResourceHelper.loadResource(resourceSet, URIHelper.getPlatformURI((IResource)resource));
    }

    public static Resource loadResource(ResourceSet resourceSet, URI uri) {
        if (resourceSet == null || uri == null) {
            return null;
        }
        resourceSet.getURIConverter().getURIMap().clear();
        resourceSet.getURIConverter().getURIMap().putAll(EGFCorePlugin.computePlatformURIMap());
        return resourceSet.getResource(uri, true);
    }

    public static void loadResource(Resource resource) throws IOException {
        if (resource == null) {
            return;
        }
        if (resource.getResourceSet() != null) {
            resource.getResourceSet().getURIConverter().getURIMap().clear();
            resource.getResourceSet().getURIConverter().getURIMap().putAll(EGFCorePlugin.computePlatformURIMap());
        }
        resource.load(Collections.EMPTY_MAP);
    }

    public static void reloadResources(ResourceSet resourceSet, Collection<Resource> resources) {
        if (resourceSet == null || resources == null || resources.size() == 0) {
            return;
        }
        UniqueEList uris = new UniqueEList(resources.size());
        for (Resource resource : resources) {
            URI uri = resource.getURI();
            uris.add(uri);
            resource.unload();
            resourceSet.getResources().remove((Object)resource);
        }
        resourceSet.getURIConverter().getURIMap().clear();
        resourceSet.getURIConverter().getURIMap().putAll(EGFCorePlugin.computePlatformURIMap());
        for (URI uri : uris) {
            resourceSet.getResource(uri, true);
        }
    }
}

