/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.core;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.egf.common.activator.EGFAbstractPlugin;
import org.eclipse.egf.common.helper.BundleHelper;
import org.eclipse.egf.core.context.ContextFactory;
import org.eclipse.egf.core.context.IContextFactory;
import org.eclipse.egf.core.fcore.IPlatformFcore;
import org.eclipse.egf.core.platform.EGFPlatformPlugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EGFCorePlugin
extends EGFAbstractPlugin {
    private static EGFCorePlugin __plugin;
    private static final IContextFactory __contextFactory;
    public static final Object FAMILY_MANUAL_BUILD;

    static {
        __contextFactory = new ContextFactory();
        FAMILY_MANUAL_BUILD = new Object();
    }

    public static EGFCorePlugin getDefault() {
        return __plugin;
    }

    public static IContextFactory getContextFactory() {
        return __contextFactory;
    }

    public static Map<URI, URI> computePlatformURIMap() {
        HashMap<URI, URI> result = new HashMap<URI, URI>();
        result.putAll(EcorePlugin.computePlatformURIMap());
        result.putAll(EGFCorePlugin.computePlatformPluginToPlatformResourceMap());
        result.putAll(EGFCorePlugin.computePlatformResourceToTargetPluginMap(EGFCorePlugin.getTargetPlatformFcores()));
        return result;
    }

    public static Map<URI, URI> computePlatformPluginToPlatformResourceMap() {
        HashMap<URI, URI> result = new HashMap<URI, URI>();
        IPlatformFcore[] iPlatformFcoreArray = EGFCorePlugin.getWorkspacePlatformFcores();
        int n = iPlatformFcoreArray.length;
        int n2 = 0;
        while (n2 < n) {
            IPlatformFcore fcore = iPlatformFcoreArray[n2];
            URI platformPluginURI = URI.createPlatformPluginURI((String)(String.valueOf(fcore.getPlatformBundle().getBundleId()) + "/"), (boolean)false);
            URI platformResourceURI = URI.createPlatformResourceURI((String)(String.valueOf(fcore.getPlatformBundle().getProject().getName()) + "/"), (boolean)true);
            result.put(platformPluginURI, platformResourceURI);
            ++n2;
        }
        return result;
    }

    public static Map<URI, URI> computePlatformResourceToTargetPluginMap(IPlatformFcore[] fcores) {
        HashMap<URI, URI> result = new HashMap<URI, URI>();
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        if (root != null) {
            IPlatformFcore[] iPlatformFcoreArray = fcores;
            int n = fcores.length;
            int n2 = 0;
            while (n2 < n) {
                IPlatformFcore fcore = iPlatformFcoreArray[n2];
                String pluginID = fcore.getURI().segment(1);
                IProject[] iProjectArray = root.getProjects();
                int n3 = iProjectArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IProject project = iProjectArray[n4];
                    IPluginModelBase base = BundleHelper.getPluginModelBase((IProject)project);
                    if (base != null && BundleHelper.getBundleId((IPluginModelBase)base).equals(pluginID) && !project.isOpen()) {
                        result.put(URI.createPlatformResourceURI((String)(String.valueOf(pluginID) + "/"), (boolean)false), URI.createPlatformPluginURI((String)(String.valueOf(pluginID) + "/"), (boolean)false));
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        return result;
    }

    public static IPlatformFcore getPlatformFcore(Resource resource) {
        if (resource == null || resource.getURI() == null || resource.getURI().isRelative()) {
            return null;
        }
        String firstSegment = resource.getURI().segment(1);
        if (firstSegment == null || firstSegment.trim().length() == 0) {
            return null;
        }
        firstSegment = firstSegment.trim();
        IPlatformFcore[] iPlatformFcoreArray = (IPlatformFcore[])EGFPlatformPlugin.getPlatformManager().getPlatformExtensionPoints(firstSegment, IPlatformFcore.class);
        int n = iPlatformFcoreArray.length;
        int n2 = 0;
        while (n2 < n) {
            IPlatformFcore fcore = iPlatformFcoreArray[n2];
            if (fcore.getURI().equals((Object)resource.getURI())) {
                return fcore;
            }
            ++n2;
        }
        return null;
    }

    public static IPlatformFcore[] getPlatformFcores(IProject project) {
        return (IPlatformFcore[])EGFPlatformPlugin.getPlatformManager().getPlatformExtensionPoints(project, IPlatformFcore.class);
    }

    public static IPlatformFcore[] getWorkspacePlatformFcores() {
        return (IPlatformFcore[])EGFPlatformPlugin.getPlatformManager().getWorkspacePlatformExtensionPoints(IPlatformFcore.class);
    }

    public static IPlatformFcore[] getTargetPlatformFcores() {
        return (IPlatformFcore[])EGFPlatformPlugin.getPlatformManager().getTargetPlatformExtensionPoints(IPlatformFcore.class);
    }

    public static IPlatformFcore[] getPlatformFcores() {
        return (IPlatformFcore[])EGFPlatformPlugin.getPlatformManager().getPlatformExtensionPoints(IPlatformFcore.class);
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        __plugin = this;
    }

    public void stop(BundleContext context) throws Exception {
        __plugin = null;
        super.stop(context);
    }
}

