/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.producer.internal.manager;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.egf.common.helper.BundleHelper;
import org.eclipse.egf.core.l10n.EGFCoreMessages;
import org.eclipse.egf.core.producer.InvocationException;
import org.eclipse.egf.model.fcore.ContractMode;
import org.eclipse.egf.model.fcore.Invocation;
import org.eclipse.egf.model.fcore.InvocationContext;
import org.eclipse.egf.model.fcore.ModelElement;
import org.eclipse.egf.model.types.TypeAbstractClass;
import org.eclipse.egf.producer.EGFProducerPlugin;
import org.eclipse.egf.producer.context.IInvocationProductionContext;
import org.eclipse.egf.producer.internal.context.InvocationProductionContext;
import org.eclipse.egf.producer.internal.manager.ModelElementManager;
import org.eclipse.egf.producer.manager.IInvocationManager;
import org.eclipse.egf.producer.manager.IOrchestrationManager;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class InvocationManager
extends ModelElementManager
implements IInvocationManager {
    public InvocationManager(IOrchestrationManager parent, Invocation<?> invocation) throws InvocationException {
        super(parent, (ModelElement)invocation);
    }

    @Override
    public Invocation<?> getElement() {
        return (Invocation)super.getElement();
    }

    @Override
    public IInvocationProductionContext getProductionContext() throws InvocationException {
        return this.getInternalProductionContext();
    }

    @Override
    public IOrchestrationManager getParent() {
        return (IOrchestrationManager)super.getParent();
    }

    protected abstract InvocationProductionContext getInternalProductionContext() throws InvocationException;

    @Override
    public void initializeContext() throws InvocationException {
        InvocationProductionContext context = this.getInternalProductionContext();
        context.clear();
        for (InvocationContext invocationContext : this.getElement().getInvocationContexts()) {
            if (invocationContext.getType() == null || invocationContext.getActivityContract() == null) continue;
            if (invocationContext.getType() instanceof TypeAbstractClass) {
                try {
                    Object object = null;
                    String fqcn = ((TypeAbstractClass)invocationContext.getType()).getValue();
                    if (fqcn != null && fqcn.trim().length() != 0 && (object = BundleHelper.instantiate((String)fqcn.trim(), (Bundle)this.getBundle())) == null) {
                        throw new InvocationException((Throwable)new CoreException(EGFProducerPlugin.getDefault().newStatus(4, NLS.bind((String)EGFCoreMessages.ProjectBundleSession_BundleClassInstantiationFailure, (Object)invocationContext.getType().getValue(), (Object)this.getBundle().getSymbolicName()), null)));
                    }
                    if (invocationContext.getMode() == ContractMode.IN) {
                        context.addInputData(invocationContext, invocationContext.getType().getType(), object);
                        continue;
                    }
                    if (invocationContext.getMode() == ContractMode.OUT) {
                        context.addOutputData(invocationContext, invocationContext.getType().getType(), null);
                        continue;
                    }
                    if (invocationContext.getMode() != ContractMode.IN_OUT) continue;
                    context.addInputData(invocationContext, invocationContext.getType().getType(), object);
                    context.addOutputData(invocationContext, invocationContext.getType().getType(), object);
                    continue;
                }
                catch (Throwable t) {
                    throw new InvocationException((Throwable)new CoreException(EGFProducerPlugin.getDefault().newStatus(4, NLS.bind((String)EGFCoreMessages.ProjectBundleSession_BundleClassInstantiationFailure, (Object)invocationContext.getType().getValue()), t)));
                }
            }
            if (invocationContext.getMode() == ContractMode.IN) {
                context.addInputData(invocationContext, invocationContext.getType().getType(), invocationContext.getType().getValue());
                continue;
            }
            if (invocationContext.getMode() == ContractMode.OUT) {
                context.addOutputData(invocationContext, invocationContext.getType().getType(), null);
                continue;
            }
            if (invocationContext.getMode() != ContractMode.IN_OUT) continue;
            context.addInputData(invocationContext, invocationContext.getType().getType(), invocationContext.getType().getValue());
            context.addOutputData(invocationContext, invocationContext.getType().getType(), invocationContext.getType().getValue());
        }
    }
}

