/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.pattern.java.engine;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.egf.common.constant.EGFCommonConstants;
import org.eclipse.egf.core.fcore.IPlatformFcore;
import org.eclipse.egf.model.pattern.Pattern;
import org.eclipse.egf.model.pattern.PatternContext;
import org.eclipse.egf.model.pattern.PatternElement;
import org.eclipse.egf.model.pattern.PatternException;
import org.eclipse.egf.model.pattern.PatternParameter;
import org.eclipse.egf.pattern.PatternPreferences;
import org.eclipse.egf.pattern.engine.PatternEngine;
import org.eclipse.egf.pattern.engine.PatternHelper;
import org.eclipse.egf.pattern.java.Messages;
import org.eclipse.egf.pattern.java.engine.JavaAssemblyHelper;
import org.eclipse.egf.pattern.java.engine.JavaNatureHelper;
import org.eclipse.egf.pattern.utils.FileHelper;

public class JavaEngine
extends PatternEngine {
    public JavaEngine(Pattern pattern) throws PatternException {
        super(pattern);
    }

    public void execute(PatternContext context) throws PatternException {
        if (this.getPattern() == null) {
            throw new IllegalStateException();
        }
        String templateClassName = JavaNatureHelper.getClassName(this.getPattern());
        if (templateClassName == null) {
            throw new IllegalStateException(Messages.assembly_error3);
        }
        try {
            Class templateClass = context.getBundle(this.getBundleId()).loadClass(templateClassName);
            Method method = templateClass.getMethod("generate", Object.class);
            Object template = templateClass.newInstance();
            method.invoke(template, context);
        }
        catch (InvocationTargetException e) {
            throw new PatternException(e.getCause());
        }
        catch (PatternException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PatternException((Throwable)e);
        }
    }

    public void translate() throws PatternException {
        Pattern pattern = this.getPattern();
        if (pattern == null) {
            throw new IllegalStateException();
        }
        JavaAssemblyHelper helper = new JavaAssemblyHelper(pattern);
        String templatecontent = helper.visit();
        try {
            IPlatformFcore platformFactoryComponent = PatternHelper.getPlatformFcore((PatternElement)pattern);
            if (platformFactoryComponent == null) {
                throw new PatternException(Messages.bind((String)Messages.assembly_error4, (Object)pattern.getName(), (Object)pattern.getID()));
            }
            IProject project = platformFactoryComponent.getPlatformBundle().getProject();
            if (project == null) {
                throw new PatternException(Messages.bind((String)Messages.assembly_error5, (Object)pattern.getName(), (Object)pattern.getID()));
            }
            String classname = JavaNatureHelper.getClassName(pattern);
            IPath outputPath = this.computeFilePath(classname);
            FileHelper.setContent((IFile)project.getFile(outputPath), (String)this.getContent(templatecontent));
        }
        catch (PatternException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PatternException((Throwable)e);
        }
    }

    private String getContent(String content) {
        String local;
        StringBuilder builder = new StringBuilder(content.length() + 500);
        int startIndex = content.indexOf("//Start of work");
        int endIndex = content.indexOf("//End of work");
        int insertionIndex = content.lastIndexOf(125);
        if (startIndex == -1 || endIndex == -1 || insertionIndex == -1) {
            return content;
        }
        builder.append(content.substring(0, startIndex));
        Pattern pattern = this.getPattern();
        builder.append("generate(tmpCollector, (PatternContext)argument");
        if (!this.getPattern().getAllParameters().isEmpty()) {
            for (PatternParameter parameter : pattern.getAllParameters()) {
                local = PatternHelper.localizeName((PatternParameter)parameter);
                builder.append(", ").append(local);
            }
        }
        builder.append(");");
        builder.append(content.substring(endIndex + "//End of work".length(), insertionIndex));
        builder.append("public void generate(StringBuilder out, PatternContext ctx");
        if (!this.getPattern().getParameters().isEmpty()) {
            for (PatternParameter parameter : pattern.getParameters()) {
                local = PatternHelper.localizeName((PatternParameter)parameter);
                builder.append(", Object ").append(local);
            }
        }
        builder.append(") {").append(EGFCommonConstants.LINE_SEPARATOR);
        builder.append(content.substring(startIndex + "//Start of work".length(), endIndex));
        builder.append("} ").append(EGFCommonConstants.LINE_SEPARATOR);
        builder.append(content.substring(insertionIndex));
        return builder.toString();
    }

    private IPath computeFilePath(String classname) {
        String[] names;
        if (classname == null || "".equals(classname)) {
            throw new IllegalArgumentException();
        }
        Path result = new Path(PatternPreferences.getGenerationFolderName());
        String[] stringArray = names = classname.split("\\.");
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            result = result.append(name);
            ++n2;
        }
        result = result.addFileExtension("java");
        return result;
    }
}

