/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.pattern.java.engine;

import java.util.Iterator;
import java.util.Map;
import org.eclipse.egf.common.constant.EGFCommonConstants;
import org.eclipse.egf.model.fcore.ModelElement;
import org.eclipse.egf.model.pattern.Pattern;
import org.eclipse.egf.model.pattern.PatternCall;
import org.eclipse.egf.model.pattern.PatternException;
import org.eclipse.egf.model.pattern.PatternInjectedCall;
import org.eclipse.egf.model.pattern.PatternParameter;
import org.eclipse.egf.model.pattern.PatternVariable;
import org.eclipse.egf.model.pattern.Query;
import org.eclipse.egf.pattern.engine.AssemblyHelper;
import org.eclipse.egf.pattern.engine.ParameterMatcher;
import org.eclipse.egf.pattern.engine.PatternHelper;
import org.eclipse.egf.pattern.java.Messages;
import org.eclipse.egf.pattern.java.engine.JavaNatureHelper;
import org.eclipse.egf.pattern.utils.ParameterTypeHelper;

public class JavaAssemblyHelper
extends AssemblyHelper {
    public static final String GENERATE_METHOD = "generate";
    public static final String START_MARKER = "//Start of work";
    public static final String END_MARKER = "//End of work";

    public JavaAssemblyHelper(Pattern pattern) {
        super(pattern);
    }

    protected void call(PatternInjectedCall call) throws PatternException {
        Pattern pattern = call.getCalled();
        String templateClassName = JavaNatureHelper.getClassName(pattern);
        if (templateClassName == null) {
            throw new PatternException(Messages.assembly_error1);
        }
        String ctxName = "ctx_" + PatternHelper.uniqueName((ModelElement)pattern);
        this.content.append("PatternContext ").append(ctxName).append(" = new PatternContext(ctx);").append(EGFCommonConstants.LINE_SEPARATOR);
        this.content.append(ctxName).append(".setValue(").append("PatternContext.INJECTED_CONTEXT, ").append(call.getContext().getName()).append(");").append(EGFCommonConstants.LINE_SEPARATOR);
        this.content.append(" new ").append(templateClassName).append("().").append(GENERATE_METHOD).append("(").append(ctxName).append(");");
    }

    protected void call(PatternCall call) throws PatternException {
        Pattern pattern = call.getCalled();
        String templateClassName = JavaNatureHelper.getClassName(pattern);
        if (templateClassName == null) {
            throw new PatternException(Messages.assembly_error1);
        }
        if (call.getParameterMatching().isEmpty()) {
            ParameterMatcher matcher = ParameterMatcher.create((Pattern)call.getPattern(), (Pattern)pattern);
            if (!matcher.matches()) {
                throw new PatternException(Messages.bind((String)Messages.assembly_error7, (Object)call.getPattern().getName()));
            }
            for (Iterator key : matcher.getMatching().keySet()) {
                String called = PatternHelper.uniqueName((ModelElement)key);
                this.content.append(ParameterTypeHelper.INSTANCE.getTypeLiteral(key.getType())).append(" ").append(called).append(" = ").append(((PatternParameter)matcher.getMatching().get(key)).getName()).append(";").append(EGFCommonConstants.LINE_SEPARATOR);
            }
        } else {
            for (Map.Entry binding : call.getParameterMatching()) {
                String called = PatternHelper.uniqueName((ModelElement)((ModelElement)binding.getKey()));
                this.content.append(ParameterTypeHelper.INSTANCE.getTypeLiteral(((PatternParameter)binding.getKey()).getType())).append(" ").append(called).append(" = ").append(((PatternParameter)binding.getValue()).getName()).append(";").append(EGFCommonConstants.LINE_SEPARATOR);
            }
        }
        String ctxName = "ctx_" + PatternHelper.uniqueName((ModelElement)pattern);
        this.content.append("PatternContext ").append(ctxName).append(" = new PatternContext(ctx);").append(EGFCommonConstants.LINE_SEPARATOR);
        this.content.append(ctxName).append(".setValue(\"key\", \"value\");").append(EGFCommonConstants.LINE_SEPARATOR);
        this.content.append(" new ").append(templateClassName).append("().").append(GENERATE_METHOD).append(" (").append(ctxName);
        for (PatternParameter parameter : pattern.getAllParameters()) {
            this.content.append(", ").append(PatternHelper.uniqueName((ModelElement)parameter));
        }
        this.content.append(");");
    }

    protected void addVariable(Pattern pattern) throws PatternException {
        for (PatternVariable var : pattern.getAllVariables()) {
            this.content.append(ParameterTypeHelper.INSTANCE.getTypeLiteral(var.getType())).append(" ").append(var.getName()).append(" = null;").append(EGFCommonConstants.LINE_SEPARATOR);
        }
        super.addVariable(pattern);
    }

    protected void beginOrchestration() throws PatternException {
        this.content.append("PatternContext ctx = (PatternContext)argument;").append(EGFCommonConstants.LINE_SEPARATOR);
        this.content.append("Map<String, Object> parameterValues = new HashMap<String, Object>();").append(EGFCommonConstants.LINE_SEPARATOR);
        this.content.append("StringBuilder collector = new StringBuilder(2000);").append(EGFCommonConstants.LINE_SEPARATOR);
        this.content.append("StringBuilder tmpCollector = new StringBuilder(2000);").append(EGFCommonConstants.LINE_SEPARATOR);
        this.content.append("IQuery.ParameterDescription paramDesc = null;").append(EGFCommonConstants.LINE_SEPARATOR);
        this.content.append("Map<String, String> queryCtx = null;").append(EGFCommonConstants.LINE_SEPARATOR);
        this.content.append("PatternExecutionReporter reporter = (PatternExecutionReporter)ctx.getValue(PatternContext.PATTERN_REPORTER);").append(EGFCommonConstants.LINE_SEPARATOR);
        this.content.append("if (reporter == null) reporter = new ConsoleReporter();").append(EGFCommonConstants.LINE_SEPARATOR);
        super.beginOrchestration();
        this.content.append(START_MARKER).append(EGFCommonConstants.LINE_SEPARATOR);
    }

    protected void endOrchestration() throws PatternException {
        this.content.append(END_MARKER).append(EGFCommonConstants.LINE_SEPARATOR);
        if (this.pattern.getAllParameters().isEmpty()) {
            this.content.append("reporter.executionFinished(tmpCollector.toString(), ctx);").append(EGFCommonConstants.LINE_SEPARATOR);
            return;
        }
        StringBuilder localContent = new StringBuilder(300);
        localContent.append("").append(EGFCommonConstants.LINE_SEPARATOR).append(EGFCommonConstants.LINE_SEPARATOR);
        for (PatternParameter parameter : this.pattern.getAllParameters()) {
            this.appendQueryCode(localContent, parameter);
        }
        localContent.append(EGFCommonConstants.LINE_SEPARATOR).append(EGFCommonConstants.LINE_SEPARATOR);
        for (PatternParameter parameter : this.pattern.getAllParameters()) {
            String local = PatternHelper.localizeName((PatternParameter)parameter);
            localContent.append("for (Object ").append(local).append(" : ").append(this.getParameterListName(parameter)).append(" ) {").append(EGFCommonConstants.LINE_SEPARATOR);
            localContent.append("parameterValues.put(\"").append(parameter.getName()).append("\", ").append(local).append(");").append(EGFCommonConstants.LINE_SEPARATOR);
        }
        localContent.append(EGFCommonConstants.LINE_SEPARATOR);
        this.content.insert(this.orchestrationIndex, localContent);
        this.content.append(EGFCommonConstants.LINE_SEPARATOR);
        this.content.append("String loop = tmpCollector.toString();").append(EGFCommonConstants.LINE_SEPARATOR);
        this.content.append("reporter.loopFinished(loop, ctx, null );").append(EGFCommonConstants.LINE_SEPARATOR);
        this.content.append("collector.append(loop);").append(EGFCommonConstants.LINE_SEPARATOR);
        this.content.append("tmpCollector.setLength(0);").append(EGFCommonConstants.LINE_SEPARATOR);
        int i = 0;
        while (i < this.pattern.getAllParameters().size()) {
            this.content.append("}").append(EGFCommonConstants.LINE_SEPARATOR);
            ++i;
        }
        this.content.append("reporter.executionFinished(collector.toString(), ctx);").append(EGFCommonConstants.LINE_SEPARATOR);
        this.content.append(EGFCommonConstants.LINE_SEPARATOR);
        int startIndex = this.content.indexOf(START_MARKER);
        if (startIndex == -1) {
            throw new PatternException(Messages.assembly_error2);
        }
        localContent.setLength(0);
        localContent.append(EGFCommonConstants.LINE_SEPARATOR);
        for (PatternParameter parameter : this.pattern.getAllParameters()) {
            String local = PatternHelper.localizeName((PatternParameter)parameter);
            String type = ParameterTypeHelper.INSTANCE.getTypeLiteral(parameter.getType());
            localContent.append(type).append(" ").append(parameter.getName()).append(" = (").append(type).append(")").append(local).append(";").append(EGFCommonConstants.LINE_SEPARATOR);
        }
        this.content.insert(startIndex + START_MARKER.length(), localContent);
    }

    private String getParameterListName(PatternParameter parameter) {
        return String.valueOf(parameter.getName()) + "List";
    }

    private void appendQueryCode(StringBuilder localContent, PatternParameter parameter) throws PatternException {
        Query query = parameter.getQuery();
        if (query == null) {
            localContent.append("List<Object> ").append(this.getParameterListName(parameter)).append(" = null;").append(EGFCommonConstants.LINE_SEPARATOR);
            localContent.append("//this pattern can only be called by another (i.e. it's not an entry point in execution)").append(EGFCommonConstants.LINE_SEPARATOR);
            return;
        }
        localContent.append("paramDesc = new IQuery.ParameterDescription(\"").append(parameter.getName()).append("\", \"").append(parameter.getType()).append("\");").append(EGFCommonConstants.LINE_SEPARATOR);
        localContent.append("queryCtx = new HashMap<String, String>();").append(EGFCommonConstants.LINE_SEPARATOR);
        if (query != null && query.getQueryContext() != null) {
            for (String key : query.getQueryContext().keySet()) {
                localContent.append("queryCtx.put(\"").append(key).append("\", \"").append((String)query.getQueryContext().get(key)).append("\");").append(EGFCommonConstants.LINE_SEPARATOR);
            }
        }
        localContent.append("List<Object> ").append(this.getParameterListName(parameter)).append(" = ");
        localContent.append("QueryHelper.load(ctx, \"").append(query.getExtensionId()).append("\").execute(paramDesc, queryCtx, ctx);").append(EGFCommonConstants.LINE_SEPARATOR);
    }
}

