/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.core.pde.internal.manifest;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.egf.common.constant.EGFCommonConstants;
import org.eclipse.egf.core.pde.plugin.AbstractManifestChangesCommand;
import org.eclipse.pde.internal.core.bundle.BundlePluginBase;
import org.eclipse.pde.internal.core.ibundle.IBundle;
import org.eclipse.pde.internal.core.text.bundle.ExportPackageHeader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractExportedPackagesCommand
extends AbstractManifestChangesCommand {
    private String[] _exportedPackages;

    public AbstractExportedPackagesCommand(String[] exportedPackages_p) {
        this._exportedPackages = exportedPackages_p;
    }

    protected String[] getExportedPackages() {
        return this._exportedPackages;
    }

    protected List<String> getExistingPackages(IBundle bundle_p) {
        ArrayList<String> result = new ArrayList<String>(0);
        ExportPackageHeader exportPackageHeader = (ExportPackageHeader)bundle_p.getManifestHeader(this.getExportedPackageHeader(bundle_p));
        if (exportPackageHeader != null) {
            result.addAll(exportPackageHeader.getPackageNames());
        }
        return result;
    }

    protected String getValue(String[] exportedPackages_p) {
        StringBuilder builder = null;
        String[] stringArray = exportedPackages_p;
        int n = exportedPackages_p.length;
        int n2 = 0;
        while (n2 < n) {
            String exportedPackage = stringArray[n2];
            if (builder == null) {
                builder = new StringBuilder();
            } else {
                builder.append(',').append(EGFCommonConstants.LINE_SEPARATOR).append(' ');
            }
            builder.append(exportedPackage);
            ++n2;
        }
        return builder == null ? "" : builder.toString();
    }

    protected String getExportedPackageHeader(IBundle bundle_p) {
        int manifestVersion = BundlePluginBase.getBundleManifestVersion((IBundle)bundle_p);
        return manifestVersion < 2 ? "Provide-Package" : "Export-Package";
    }
}

