/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ide.fxml.editors;

import java.util.Locale;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.fx.ide.fxml.editors.FXMLValidationMessage;
import org.eclipse.fx.ide.fxml.editors.Util;
import org.eclipse.fx.ide.model.FXPlugin;
import org.eclipse.fx.ide.model.IFXClass;
import org.eclipse.fx.ide.model.IFXCtrlClass;
import org.eclipse.fx.ide.model.IFXCtrlEventMethod;
import org.eclipse.fx.ide.model.IFXCtrlField;
import org.eclipse.fx.ide.model.IFXEventHandlerProperty;
import org.eclipse.fx.ide.model.IFXProperty;
import org.eclipse.fx.ide.ui.util.IconKeys;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.quickassist.IQuickAssistInvocationContext;
import org.eclipse.jface.text.quickassist.IQuickAssistProcessor;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionList;
import org.eclipse.wst.sse.ui.internal.reconcile.validator.ISourceValidator;
import org.eclipse.wst.sse.ui.internal.reconcile.validator.IncrementalReporter;
import org.eclipse.wst.validation.AbstractValidator;
import org.eclipse.wst.validation.internal.core.ValidationException;
import org.eclipse.wst.validation.internal.operations.IWorkbenchContext;
import org.eclipse.wst.validation.internal.operations.LocalizedMessage;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;
import org.eclipse.wst.validation.internal.provisional.core.IValidationContext;
import org.eclipse.wst.validation.internal.provisional.core.IValidator;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMAttr;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wst.xml.ui.internal.Logger;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class FXMLValidator
extends AbstractValidator
implements IValidator,
ISourceValidator {
    private IDocument document;
    private IContentType fRootContentType = null;

    private void setDocument(IDocument document) {
        this.document = document;
    }

    private IDocument getDocument() {
        return this.document;
    }

    public void connect(IDocument document) {
        this.setDocument(document);
    }

    public void disconnect(IDocument document) {
        this.setDocument(null);
    }

    public void validate(IRegion dirtyRegion, IValidationContext helper, IReporter reporter) {
        if (this.getDocument() == null) {
            return;
        }
        if (!(reporter instanceof IncrementalReporter)) {
            return;
        }
        if (!(this.getDocument() instanceof IStructuredDocument)) {
            return;
        }
        reporter.removeAllMessages((IValidator)this);
        IStructuredDocumentRegion[] regions = ((IStructuredDocument)this.document).getStructuredDocumentRegions(dirtyRegion.getOffset(), dirtyRegion.getLength());
        int i = 0;
        while (i < regions.length) {
            this.validate(regions[i], reporter);
            ++i;
        }
    }

    private void validate(IStructuredDocumentRegion structuredDocumentRegion, IReporter reporter) {
        if (structuredDocumentRegion == null) {
            return;
        }
        if (FXMLValidator.isStartTag(structuredDocumentRegion)) {
            this.checkControllerAttributes(structuredDocumentRegion, reporter);
        }
    }

    private void checkControllerAttributes(IStructuredDocumentRegion structuredDocumentRegion, IReporter reporter) {
        if (structuredDocumentRegion.isDeleted()) {
            return;
        }
        ITextRegionList textRegions = structuredDocumentRegion.getRegions();
        IFXCtrlClass fxCtrl = null;
        int i = 0;
        while (i < textRegions.size()) {
            ITextRegion textRegion = textRegions.get(i);
            if (textRegion.getType() == "XML_TAG_OPEN") {
                IFXClass e;
                IndexedRegion treeNode = FXMLValidator.getNode(this.document, structuredDocumentRegion.getStartOffset(textRegion));
                if (treeNode == null) {
                    return;
                }
                IDOMNode node = (IDOMNode)treeNode;
                if (fxCtrl == null) {
                    fxCtrl = FXMLValidator.getController(node);
                }
                if (fxCtrl != null && (e = FXMLValidator.computeTagNameHelp(node)) != null) {
                    NamedNodeMap nnm = node.getAttributes();
                    Map props = e.getAllProperties();
                    int j = 0;
                    while (j < nnm.getLength()) {
                        Node attribute = nnm.item(j);
                        if (attribute.getNodeName().equals("fx:id")) {
                            IFXCtrlField f = (IFXCtrlField)fxCtrl.getAllFields().get(attribute.getNodeValue());
                            IType type = e.getType();
                            if (f != null) {
                                IType toType = f.getType();
                                IType fromType = Util.findType(node.getLocalName(), node.getOwnerDocument());
                                if (fromType != null && toType != null && !org.eclipse.fx.ide.model.Util.assignable((IType)fromType, (IType)toType)) {
                                    FXMLValidationMessage message = new FXMLValidationMessage(3, "FXMLValidator.incompatibleFieldTypes", fromType.getElementName(), toType.getElementName());
                                    IDOMAttr domAttr = (IDOMAttr)attribute;
                                    message.setLength(FXMLValidator.getAttributeLength(structuredDocumentRegion, domAttr));
                                    message.setOffset(domAttr.getStartOffset());
                                    reporter.addMessage((IValidator)this, (IMessage)message);
                                }
                            } else {
                                String fielname = attribute.getNodeValue();
                                message = new FXMLValidationMessage(3, "FXMLValidator.unknownControllerField", fxCtrl.getSimpleName(), fielname);
                                domAttr = (IDOMAttr)attribute;
                                message.setLength(FXMLValidator.getAttributeLength(structuredDocumentRegion, domAttr));
                                message.setOffset(domAttr.getStartOffset());
                                processor = new UnknownControllerFieldQuickAssist(fielname, type, fxCtrl);
                                message.setAttribute(IQuickAssistProcessor.class.getName(), processor);
                                reporter.addMessage((IValidator)this, (IMessage)message);
                            }
                        } else {
                            IFXCtrlEventMethod evtMethod;
                            IFXProperty p = (IFXProperty)props.get(attribute.getNodeName());
                            if (p instanceof IFXEventHandlerProperty && attribute.getNodeValue() != null && !attribute.getNodeValue().isEmpty() && (evtMethod = (IFXCtrlEventMethod)fxCtrl.getAllEventMethods().get(attribute.getNodeValue().substring(1))) == null && nnm.item(j).getNodeValue() != null && !nnm.item(j).getNodeValue().isEmpty()) {
                                String methodName = nnm.item(j).getNodeValue().substring(1);
                                message = new FXMLValidationMessage(1, "FXMLValidator.unknownControllerMethod", fxCtrl.getSimpleName(), methodName);
                                domAttr = (IDOMAttr)attribute;
                                message.setLength(FXMLValidator.getAttributeLength(structuredDocumentRegion, domAttr));
                                message.setOffset(domAttr.getStartOffset());
                                processor = new UnknownControllerEventMethodQuickFixAssist(methodName, fxCtrl, (IFXEventHandlerProperty)p);
                                message.setAttribute(IQuickAssistProcessor.class.getName(), processor);
                                reporter.addMessage((IValidator)this, (IMessage)message);
                            }
                        }
                        ++j;
                    }
                }
            }
            ++i;
        }
    }

    private static int getAttributeLength(IStructuredDocumentRegion structuredDocumentRegion, IDOMAttr domAttr) {
        int l = domAttr.getValueRegionStartOffset() - domAttr.getStartOffset();
        if (domAttr.getValueRegion() != null) {
            l += structuredDocumentRegion.getText(domAttr.getValueRegion()).length();
        }
        return l;
    }

    private static IFXCtrlClass getController(IDOMNode node) {
        IType type;
        Document d = node.getOwnerDocument();
        Element docEl = d.getDocumentElement();
        Attr a = Util.getFXMLAttribute(docEl, "controller");
        if (a != null && a.getValue() != null && !a.getValue().trim().isEmpty() && (type = Util.findType(a.getValue(), d)) != null) {
            return FXPlugin.getClassmodel().findCtrlClass(type.getJavaProject(), type);
        }
        return null;
    }

    private static IFXClass computeTagNameHelp(IDOMNode xmlnode) {
        if (!Character.isLowerCase(xmlnode.getNodeName().charAt(0))) {
            if (xmlnode.getNodeName().contains(".")) {
                String[] parts = xmlnode.getNodeName().split("\\.");
                IType ownerType = Util.findType(parts[0], xmlnode.getOwnerDocument());
                if (ownerType != null) {
                    return FXPlugin.getClassmodel().findClass(ownerType.getJavaProject(), ownerType);
                }
            } else {
                IType ownerType = Util.findType(xmlnode.getNodeName(), xmlnode.getOwnerDocument());
                if (ownerType != null) {
                    return FXPlugin.getClassmodel().findClass(ownerType.getJavaProject(), ownerType);
                }
            }
        }
        return null;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static IndexedRegion getNode(IDocument document, int documentOffset) {
        IndexedRegion node = null;
        IModelManager mm = StructuredModelManager.getModelManager();
        IStructuredModel model = null;
        if (mm != null) {
            model = mm.getExistingModelForRead(document);
        }
        try {
            block8: {
                int lastOffset;
                block7: {
                    if (model == null) return node;
                    lastOffset = documentOffset;
                    node = model.getIndexedRegion(documentOffset);
                    if (!true) break block7;
                    if (node != null) return node;
                    if (lastOffset < 0) break block8;
                }
                do {
                    node = model.getIndexedRegion(--lastOffset);
                    if (node != null) return node;
                } while (lastOffset >= 0);
            }
            return node;
        }
        finally {
            if (model != null) {
                model.releaseFromRead();
            }
        }
    }

    private static boolean isStartTag(IStructuredDocumentRegion structuredDocumentRegion) {
        if (structuredDocumentRegion == null || structuredDocumentRegion.isDeleted()) {
            return false;
        }
        return structuredDocumentRegion.getFirstRegion().getType() == "XML_TAG_OPEN";
    }

    public void cleanup(IReporter reporter) {
        this.document = null;
    }

    private boolean shouldValidate(IResource file, boolean checkExtension) {
        String extension;
        if (file == null || !file.exists() || file.getType() != 1) {
            return false;
        }
        if (checkExtension && (extension = file.getFileExtension()) != null && "xml".endsWith(extension.toLowerCase(Locale.US))) {
            return true;
        }
        IContentDescription contentDescription = null;
        try {
            contentDescription = ((IFile)file).getContentDescription();
            if (contentDescription != null) {
                IContentType contentType = contentDescription.getContentType();
                return contentType.isKindOf(this.getXMLContentType());
            }
        }
        catch (CoreException e) {
            Logger.logException((Throwable)e);
        }
        return false;
    }

    private IContentType getXMLContentType() {
        if (this.fRootContentType == null) {
            this.fRootContentType = Platform.getContentTypeManager().getContentType("org.eclipse.core.runtime.xml");
        }
        return this.fRootContentType;
    }

    public void validate(IValidationContext helper, IReporter reporter) throws ValidationException {
        String[] uris = helper.getURIs();
        IWorkspaceRoot wsRoot = ResourcesPlugin.getWorkspace().getRoot();
        if (uris.length > 0) {
            IFile currentFile = null;
            int i = 0;
            while (i < uris.length && !reporter.isCancelled()) {
                Path path = new Path(uris[i]);
                if (path.segmentCount() > 1) {
                    currentFile = wsRoot.getFile((IPath)path);
                    if (this.shouldValidate((IResource)currentFile, true)) {
                        this.validateV1File(currentFile, reporter);
                    }
                } else if (uris.length == 1) {
                    this.validateV1Project(helper, reporter);
                }
                ++i;
            }
        } else {
            this.validateV1Project(helper, reporter);
        }
    }

    boolean shouldValidate(IResourceProxy proxy) {
        String name;
        if (proxy.getType() == 1 && (name = proxy.getName()).toLowerCase(Locale.US).endsWith(".fxml")) {
            return true;
        }
        return this.shouldValidate(proxy.requestResource(), false);
    }

    private void validateV1Project(IValidationContext helper, final IReporter reporter) {
        if (helper instanceof IWorkbenchContext) {
            IProject project = ((IWorkbenchContext)helper).getProject();
            IResourceProxyVisitor visitor = new IResourceProxyVisitor(){

                public boolean visit(IResourceProxy proxy) throws CoreException {
                    if (FXMLValidator.this.shouldValidate(proxy)) {
                        FXMLValidator.this.validateV1File((IFile)proxy.requestResource(), reporter);
                    }
                    return true;
                }
            };
            try {
                project.accept(visitor, 2);
            }
            catch (CoreException e) {
                Logger.logException((Throwable)e);
            }
        }
    }

    void validateV1File(IFile currentFile, IReporter reporter) {
        LocalizedMessage message = new LocalizedMessage(4, currentFile.getFullPath().toString().substring(1));
        reporter.displaySubtask((IValidator)this, (IMessage)message);
        IStructuredModel model = null;
        try {
            try {
                model = StructuredModelManager.getModelManager().getModelForRead(currentFile);
                IStructuredDocument document = null;
                if (model != null) {
                    document = model.getStructuredDocument();
                    this.connect((IDocument)document);
                    IStructuredDocumentRegion validationRegion = document.getFirstStructuredDocumentRegion();
                    while (validationRegion != null) {
                        this.validate(validationRegion, reporter);
                        validationRegion = validationRegion.getNext();
                    }
                    this.disconnect((IDocument)document);
                }
            }
            catch (Exception e) {
                Logger.logException((Throwable)e);
                if (model != null) {
                    model.releaseFromRead();
                }
            }
        }
        finally {
            if (model != null) {
                model.releaseFromRead();
            }
        }
    }

    static abstract class BaseCompletionProposalImpl
    implements ICompletionProposal {
        private final int replacementOffset;
        private final int cursorPosition;
        private final String label;
        private final Image image;

        public BaseCompletionProposalImpl(String label, Image image, int replacementOffset, int cursorPosition) {
            this.label = label;
            this.image = image;
            this.replacementOffset = replacementOffset;
            this.cursorPosition = cursorPosition;
        }

        public Point getSelection(IDocument document) {
            return new Point(this.replacementOffset + this.cursorPosition, 0);
        }

        public String getAdditionalProposalInfo() {
            return null;
        }

        public String getDisplayString() {
            return this.label;
        }

        public Image getImage() {
            return this.image;
        }

        public IContextInformation getContextInformation() {
            return null;
        }
    }

    static class UnknownControllerEventMethodQuickFixAssist
    implements IQuickAssistProcessor {
        final String methodName;
        final IFXCtrlClass controller;
        final IFXEventHandlerProperty property;

        public UnknownControllerEventMethodQuickFixAssist(String methodName, IFXCtrlClass controller, IFXEventHandlerProperty property) {
            this.methodName = methodName;
            this.controller = controller;
            this.property = property;
        }

        public String getErrorMessage() {
            return "THIS IS THE ERROR MESSAGE";
        }

        public boolean canFix(Annotation annotation) {
            return true;
        }

        public boolean canAssist(IQuickAssistInvocationContext invocationContext) {
            return true;
        }

        public ICompletionProposal[] computeQuickAssistProposals(IQuickAssistInvocationContext invocationContext) {
            return new ICompletionProposal[]{new BaseCompletionProposalImpl("Add '" + this.methodName + "()' to controller '" + this.controller.getSimpleName() + "'", IconKeys.getIcon((String)IconKeys.EVENT_KEY), invocationContext.getOffset(), 0){

                public void apply(IDocument document) {
                    try {
                        IType type = controller.getType();
                        String[][] resolvedType = type.resolveType("FXML");
                        if (resolvedType == null) {
                            type.getCompilationUnit().createImport("javafx.fxml.FXML", null, (IProgressMonitor)new NullProgressMonitor());
                        }
                        type.createMethod("@FXML public void " + methodName + "() {}", null, true, (IProgressMonitor)new NullProgressMonitor());
                    }
                    catch (JavaModelException e) {
                        e.printStackTrace();
                    }
                    try {
                        document.replace(0, 0, "");
                    }
                    catch (BadLocationException e1) {
                        e1.printStackTrace();
                    }
                }
            }, new BaseCompletionProposalImpl("Add '" + this.methodName + "(" + this.property.getEventTypeAsString(false) + ")' to controller '" + this.controller.getSimpleName() + "'", IconKeys.getIcon((String)IconKeys.EVENT_KEY), invocationContext.getOffset(), invocationContext.getLength()){

                public void apply(IDocument document) {
                    try {
                        IType type = controller.getType();
                        String[][] resolvedType = type.resolveType("FXML");
                        if (resolvedType == null) {
                            type.getCompilationUnit().createImport("javafx.fxml.FXML", null, (IProgressMonitor)new NullProgressMonitor());
                        }
                        if ((resolvedType = type.resolveType(property.getEventTypeAsString(false))) == null) {
                            type.getCompilationUnit().createImport(property.getEventTypeAsString(true), null, (IProgressMonitor)new NullProgressMonitor());
                        }
                        type.createMethod("@FXML public void " + methodName + "(" + property.getEventTypeAsString(false) + " event) {}", null, true, (IProgressMonitor)new NullProgressMonitor());
                    }
                    catch (JavaModelException e) {
                        e.printStackTrace();
                    }
                    try {
                        document.replace(0, 0, "");
                    }
                    catch (BadLocationException e1) {
                        e1.printStackTrace();
                    }
                }
            }};
        }
    }

    static class UnknownControllerFieldQuickAssist
    implements IQuickAssistProcessor {
        final String fieldName;
        final IType fieldType;
        final IFXCtrlClass controller;

        public UnknownControllerFieldQuickAssist(String fieldName, IType fieldType, IFXCtrlClass controller) {
            this.fieldName = fieldName;
            this.fieldType = fieldType;
            this.controller = controller;
        }

        public String getErrorMessage() {
            return null;
        }

        public boolean canFix(Annotation annotation) {
            return false;
        }

        public boolean canAssist(IQuickAssistInvocationContext invocationContext) {
            return false;
        }

        public ICompletionProposal[] computeQuickAssistProposals(IQuickAssistInvocationContext invocationContext) {
            return new ICompletionProposal[]{new BaseCompletionProposalImpl("Add field '" + this.fieldName + "' to controller '" + this.controller.getSimpleName() + "'", null, invocationContext.getOffset(), 0){

                public void apply(IDocument document) {
                    try {
                        IType type = controller.getType();
                        String[][] resolvedType = type.resolveType("FXML");
                        if (resolvedType == null) {
                            type.getCompilationUnit().createImport("javafx.fxml.FXML", null, (IProgressMonitor)new NullProgressMonitor());
                        }
                        if ((resolvedType = type.resolveType(Signature.getSimpleName((String)fieldType.getElementName()))) == null) {
                            type.getCompilationUnit().createImport(fieldType.getFullyQualifiedName(), null, (IProgressMonitor)new NullProgressMonitor());
                        }
                        type.createField("@FXML " + Signature.getSimpleName((String)fieldType.getElementName()) + " " + fieldName + ";", null, true, (IProgressMonitor)new NullProgressMonitor());
                    }
                    catch (JavaModelException e) {
                        e.printStackTrace();
                    }
                }
            }};
        }
    }
}

