/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ide.fxml.refactoring;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.fx.ide.fxml.editors.Util;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.RenameParticipant;
import org.eclipse.search.core.text.TextSearchEngine;
import org.eclipse.search.core.text.TextSearchMatchAccess;
import org.eclipse.search.core.text.TextSearchRequestor;
import org.eclipse.search.core.text.TextSearchScope;
import org.eclipse.search.ui.text.FileTextSearchScope;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.edits.TextEditGroup;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class RenameJFXControllerParticipant
extends RenameParticipant {
    private ICompilationUnit renamedElement;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean initialize(Object element) {
        if (!(element instanceof ICompilationUnit)) return false;
        this.renamedElement = (ICompilationUnit)element;
        try {
            IJavaElement[] iJavaElementArray = this.renamedElement.getChildren();
            int n = iJavaElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                IJavaElement e = iJavaElementArray[n2];
                if (e instanceof IType) {
                    IAnnotation a;
                    int n3;
                    int n4;
                    IAnnotation[] iAnnotationArray;
                    IField m;
                    IField[] iFieldArray = ((IType)e).getFields();
                    int n5 = iFieldArray.length;
                    int n6 = 0;
                    while (n6 < n5) {
                        m = iFieldArray[n6];
                        iAnnotationArray = m.getAnnotations();
                        n4 = iAnnotationArray.length;
                        n3 = 0;
                        while (n3 < n4) {
                            a = iAnnotationArray[n3];
                            if (RenameJFXControllerParticipant.isFxmlAnnotation(a)) {
                                return true;
                            }
                            ++n3;
                        }
                        ++n6;
                    }
                    iFieldArray = ((IType)e).getMethods();
                    n5 = iFieldArray.length;
                    n6 = 0;
                    while (n6 < n5) {
                        m = iFieldArray[n6];
                        iAnnotationArray = m.getAnnotations();
                        n4 = iAnnotationArray.length;
                        n3 = 0;
                        while (n3 < n4) {
                            a = iAnnotationArray[n3];
                            if (RenameJFXControllerParticipant.isFxmlAnnotation(a)) {
                                return true;
                            }
                            ++n3;
                        }
                        ++n6;
                    }
                }
                ++n2;
            }
            return false;
        }
        catch (JavaModelException e) {
            e.printStackTrace();
        }
        return false;
    }

    private static boolean isFxmlAnnotation(IAnnotation a) {
        return "FXML".equals(a.getElementName());
    }

    public String getName() {
        return "e(fx)clipse RenameJFXControllerParticipant";
    }

    public RefactoringStatus checkConditions(IProgressMonitor pm, CheckConditionsContext context) throws OperationCanceledException {
        return new RefactoringStatus();
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        HashMap<Object, Change> changes = new HashMap<Object, Change>();
        if (this.renamedElement != null) {
            String fullname = this.renamedElement.getElementName();
            String extension = "." + this.renamedElement.getCorrespondingResource().getFileExtension();
            String controllerClassName = fullname.substring(0, fullname.length() - extension.length());
            IProject[] roots = this.renamedElement.getCorrespondingResource().getWorkspace().getRoot().getProjects();
            Object pack = "";
            if (this.renamedElement.getPackageDeclarations().length > 0) {
                pack = this.renamedElement.getPackageDeclarations()[0].getElementName() + ".";
            }
            String oldFullyQualifiedName = (String)pack + controllerClassName;
            String newFullyQualifiedName = (String)pack + this.getArguments().getNewName().replace(".java", "");
            this.createChangesForFullyQualifiedOccurrences(pm, changes, (IResource[])roots, oldFullyQualifiedName, newFullyQualifiedName);
            this.createChangesForNotFullyQualifiedOccurrences(pm, changes, (IResource[])roots, (String)pack, controllerClassName, this.getArguments().getNewName().replace(".java", ""));
        }
        if (changes.isEmpty()) {
            return null;
        }
        CompositeChange result = new CompositeChange("FXML updates");
        for (Change change : changes.values()) {
            result.add(change);
        }
        return result;
    }

    private void createChangesForFullyQualifiedOccurrences(IProgressMonitor pm, final HashMap<Object, Change> changes, IResource[] roots, String oldFullyQualifiedName, final String newFullyQualifiedName) {
        String[] fileNamePatterns = new String[]{"*.fxml", "*.fxgraph"};
        FileTextSearchScope scope = FileTextSearchScope.newSearchScope((IResource[])roots, (String[])fileNamePatterns, (boolean)false);
        Pattern pattern = Pattern.compile(oldFullyQualifiedName);
        TextSearchRequestor collector = new TextSearchRequestor(){

            public boolean acceptPatternMatch(TextSearchMatchAccess matchAccess) throws CoreException {
                IFile file = matchAccess.getFile();
                TextFileChange change = (TextFileChange)changes.get(file);
                if (change == null) {
                    TextChange textChange = RenameJFXControllerParticipant.this.getTextChange(file);
                    if (textChange != null) {
                        return false;
                    }
                    change = new TextFileChange(file.getName(), file);
                    change.setEdit((TextEdit)new MultiTextEdit());
                    changes.put(file, change);
                }
                ReplaceEdit edit = new ReplaceEdit(matchAccess.getMatchOffset(), matchAccess.getMatchLength(), newFullyQualifiedName);
                change.addEdit((TextEdit)edit);
                change.addTextEditGroup(new TextEditGroup("Update type reference", (TextEdit)edit));
                return true;
            }
        };
        TextSearchEngine.create().search((TextSearchScope)scope, collector, pattern, pm);
    }

    private void createChangesForNotFullyQualifiedOccurrences(IProgressMonitor pm, final HashMap<Object, Change> changes, IResource[] roots, final String pack, final String oldName, final String newName) {
        String[] fileNamePatterns = new String[]{"*.fxml"};
        FileTextSearchScope scope = FileTextSearchScope.newSearchScope((IResource[])roots, (String[])fileNamePatterns, (boolean)false);
        Pattern pattern = Pattern.compile("\"" + oldName + "\"");
        TextSearchRequestor collector = new TextSearchRequestor(){

            public boolean acceptPatternMatch(TextSearchMatchAccess matchAccess) throws CoreException {
                IFile file = matchAccess.getFile();
                boolean found = false;
                try {
                    DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                    DocumentBuilder db = dbf.newDocumentBuilder();
                    Document doc = db.parse(file.getContents());
                    List<String> l = Util.getImportedTypes(doc);
                    for (String imp : l) {
                        if (!imp.startsWith(pack + "*") && !imp.startsWith(pack + oldName)) continue;
                        found = true;
                        break;
                    }
                }
                catch (ParserConfigurationException e) {
                    e.printStackTrace();
                }
                catch (SAXException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                if (found) {
                    int index;
                    String content = matchAccess.getFileContent(0, matchAccess.getFileContentLength());
                    TextFileChange change = (TextFileChange)changes.get(file);
                    if (change == null) {
                        TextChange textChange = RenameJFXControllerParticipant.this.getTextChange(file);
                        if (textChange != null) {
                            return false;
                        }
                        change = new TextFileChange(file.getName(), file);
                        change.setEdit((TextEdit)new MultiTextEdit());
                        changes.put(file, change);
                    }
                    if ((index = content.indexOf("\"" + oldName + "\"")) >= 0) {
                        ReplaceEdit edit = new ReplaceEdit(index + 1, oldName.length(), newName);
                        change.addEdit((TextEdit)edit);
                        change.addTextEditGroup(new TextEditGroup("Update type reference", (TextEdit)edit));
                    }
                }
                return true;
            }
        };
        TextSearchEngine.create().search((TextSearchScope)scope, collector, pattern, pm);
    }
}

