/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ide.css.conversion;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.xtext.conversion.ValueConverterException;
import org.eclipse.xtext.conversion.impl.AbstractLexerBasedConverter;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.util.Strings;

public class CSSSTRINGValueConverter
extends AbstractLexerBasedConverter<String> {
    final Pattern unicodePattern = Pattern.compile("\\\\([0-9a-fA-F]{1,6})");

    private String cssUnicodeToJavaUnicode(String input) {
        StringBuffer result = new StringBuffer();
        Matcher matcher = this.unicodePattern.matcher(input);
        int lastEnd = 0;
        while (matcher.find()) {
            int cssUnicodeStart = matcher.start();
            int cssUnicodeEnd = matcher.end();
            result.append(input.substring(lastEnd, cssUnicodeStart));
            String cssUnicodeString = matcher.group(1);
            result.append(this.convertToJava(cssUnicodeString));
            lastEnd = cssUnicodeEnd;
        }
        result.append(input.substring(lastEnd));
        return result.toString();
    }

    private String convertToJava(String cssUnicode) {
        int codePoint = Integer.parseInt(cssUnicode, 16);
        char[] chars = Character.toChars(codePoint);
        return String.valueOf(chars);
    }

    protected String toEscapedString(String value) {
        value = this.cssUnicodeToJavaUnicode(value);
        return "\"" + Strings.convertToJavaString((String)value, (boolean)false) + "\"";
    }

    public String toValue(String string, INode node) {
        if (string == null) {
            return null;
        }
        try {
            string = this.cssUnicodeToJavaUnicode(string);
            return Strings.convertFromJavaString((String)string.substring(1, string.length() - 1), (boolean)true);
        }
        catch (IllegalArgumentException e) {
            throw new ValueConverterException(e.getMessage(), node, (Exception)e);
        }
    }
}

