/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.resource.pool.datastructure;

import com.sun.appserv.connectors.internal.api.PoolingException;
import com.sun.enterprise.resource.ResourceHandle;
import com.sun.enterprise.resource.allocator.ResourceAllocator;
import com.sun.enterprise.resource.pool.ResourceHandler;
import com.sun.enterprise.resource.pool.datastructure.DataStructure;
import com.sun.logging.LogDomains;
import java.util.Arrays;
import java.util.BitSet;
import java.util.List;
import java.util.concurrent.Semaphore;
import java.util.concurrent.locks.StampedLock;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RWLockDataStructure
implements DataStructure {
    private static final Logger LOG = LogDomains.getLogger(RWLockDataStructure.class, (String)"jakarta.enterprise.resource.resourceadapter");
    private final StampedLock lock = new StampedLock();
    private final DataStructureSemaphore availableResources;
    private final ResourceHandler handler;
    private final BitSet useMask;
    private ResourceHandle[] resources;
    private int size;
    private volatile int maxSize;

    public RWLockDataStructure(String parameters, int maxSize, ResourceHandler handler) {
        this.availableResources = new DataStructureSemaphore(maxSize);
        this.useMask = new BitSet(maxSize);
        this.resources = new ResourceHandle[maxSize];
        this.handler = handler;
        this.maxSize = maxSize;
        LOG.log(Level.FINEST, "pool.datastructure.rwlockds.init");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int addResource(ResourceAllocator allocator, int count) throws PoolingException {
        int numResAdded = 0;
        for (int i = 0; i < count && this.availableResources.tryAcquire(); ++i) {
            ResourceHandle resource;
            try {
                resource = this.handler.createResource(allocator);
            }
            catch (Exception e) {
                this.availableResources.release();
                throw new PoolingException(e.getMessage(), e);
            }
            long stamp = this.lock.tryOptimisticRead();
            try {
                while (true) {
                    if (stamp != 0L) {
                        int currentLength = this.resources.length;
                        int currentMaxSize = this.maxSize;
                        ResourceHandle[] newResources = null;
                        if (currentLength < currentMaxSize) {
                            newResources = Arrays.copyOf(this.resources, currentMaxSize);
                        }
                        resource.setRwLockDataStructureResourceIndex(this.size);
                        stamp = this.lock.tryConvertToWriteLock(stamp);
                        if (stamp != 0L) {
                            if (newResources != null) {
                                this.resources = newResources;
                            }
                            this.resources[this.size++] = resource;
                            break;
                        }
                    }
                    stamp = this.lock.writeLock();
                }
            }
            finally {
                if (StampedLock.isWriteLockStamp(stamp)) {
                    this.lock.unlockWrite(stamp);
                }
            }
            ++numResAdded;
        }
        return numResAdded;
    }

    @Override
    public ResourceHandle getResource() {
        long stamp = this.lock.tryOptimisticRead();
        try {
            while (true) {
                if (stamp != 0L) {
                    int index = this.useMask.nextClearBit(0);
                    int currentSize = this.size;
                    if (this.lock.validate(stamp)) {
                        if (index >= currentSize) {
                            ResourceHandle resourceHandle = null;
                            return resourceHandle;
                        }
                        if ((stamp = this.lock.tryConvertToWriteLock(stamp)) != 0L) {
                            this.useMask.set(index);
                            ResourceHandle resourceHandle = this.resources[index];
                            return resourceHandle;
                        }
                    }
                }
                stamp = this.lock.writeLock();
            }
        }
        finally {
            if (StampedLock.isWriteLockStamp(stamp)) {
                this.lock.unlockWrite(stamp);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeResource(ResourceHandle resource) {
        boolean removed = false;
        long stamp = this.lock.tryOptimisticRead();
        try {
            while (true) {
                if (stamp != 0L) {
                    int currentSize = this.size;
                    int removeIndex = resource.getRwLockDataStructureResourceIndex();
                    if (this.lock.validate(stamp)) {
                        if (removeIndex >= currentSize) {
                            break;
                        }
                        ResourceHandle currentResource = this.resources[removeIndex];
                        if (this.lock.validate(stamp)) {
                            if (currentResource != resource) {
                                break;
                            }
                            if ((stamp = this.lock.tryConvertToWriteLock(stamp)) != 0L) {
                                this.availableResources.release();
                                int lastIndex = currentSize - 1;
                                if (removeIndex < lastIndex) {
                                    ResourceHandle lastResource = this.resources[lastIndex];
                                    lastResource.setRwLockDataStructureResourceIndex(removeIndex);
                                    this.resources[removeIndex] = lastResource;
                                    this.useMask.set(removeIndex, this.useMask.get(lastIndex));
                                }
                                this.resources[lastIndex] = null;
                                this.useMask.clear(lastIndex);
                                this.size = lastIndex;
                                removed = true;
                                break;
                            }
                        }
                    }
                }
                stamp = this.lock.writeLock();
            }
        }
        finally {
            if (StampedLock.isWriteLockStamp(stamp)) {
                this.lock.unlockWrite(stamp);
            }
        }
        if (removed) {
            this.handler.deleteResource(resource);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void returnResource(ResourceHandle resource) {
        long stamp = this.lock.tryOptimisticRead();
        try {
            while (true) {
                if (stamp != 0L) {
                    int currentSize = this.size;
                    int returnIndex = resource.getRwLockDataStructureResourceIndex();
                    if (this.lock.validate(stamp)) {
                        if (returnIndex >= currentSize) {
                            break;
                        }
                        ResourceHandle currentResource = this.resources[returnIndex];
                        if (this.lock.validate(stamp)) {
                            if (currentResource != resource) {
                                break;
                            }
                            if ((stamp = this.lock.tryConvertToWriteLock(stamp)) != 0L) {
                                this.useMask.clear(returnIndex);
                                break;
                            }
                        }
                    }
                }
                stamp = this.lock.writeLock();
            }
        }
        finally {
            if (StampedLock.isWriteLockStamp(stamp)) {
                this.lock.unlockWrite(stamp);
            }
        }
    }

    @Override
    public int getFreeListSize() {
        long stamp = this.lock.tryOptimisticRead();
        try {
            while (true) {
                if (stamp != 0L) {
                    int freeListSize = this.size - this.useMask.cardinality();
                    if (this.lock.validate(stamp)) {
                        int n = freeListSize;
                        return n;
                    }
                }
                stamp = this.lock.readLock();
            }
        }
        finally {
            if (StampedLock.isReadLockStamp(stamp)) {
                this.lock.unlockRead(stamp);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAll() {
        Object[] resourcesToRemove;
        int currentSize;
        long stamp = this.lock.writeLock();
        try {
            currentSize = this.size;
            this.availableResources.release(currentSize);
            resourcesToRemove = this.resources;
            this.resources = new ResourceHandle[this.maxSize];
            this.useMask.clear(0, currentSize);
            this.size = 0;
        }
        finally {
            this.lock.unlockWrite(stamp);
        }
        for (int i = 0; i < currentSize; ++i) {
            this.handler.deleteResource(resourcesToRemove[i]);
        }
        Arrays.fill(resourcesToRemove, 0, currentSize, null);
    }

    @Override
    public int getResourcesSize() {
        long stamp = this.lock.tryOptimisticRead();
        try {
            while (true) {
                if (stamp != 0L) {
                    int currentSize = this.size;
                    if (this.lock.validate(stamp)) {
                        int n = currentSize;
                        return n;
                    }
                }
                stamp = this.lock.readLock();
            }
        }
        finally {
            if (StampedLock.isReadLockStamp(stamp)) {
                this.lock.unlockRead(stamp);
            }
        }
    }

    @Override
    public synchronized void setMaxSize(int newMaxSize) {
        int permits = newMaxSize - this.maxSize;
        switch (Integer.signum(permits)) {
            case 1: {
                this.availableResources.release(permits);
                break;
            }
            case -1: {
                this.availableResources.reducePermits(Math.abs(permits));
                break;
            }
            default: {
                return;
            }
        }
        this.maxSize = newMaxSize;
    }

    @Override
    public List<ResourceHandle> getAllResources() {
        long stamp = this.lock.tryOptimisticRead();
        try {
            while (true) {
                if (stamp != 0L) {
                    ResourceHandle[] allResources = Arrays.copyOf(this.resources, this.size);
                    if (this.lock.validate(stamp)) {
                        List<ResourceHandle> list = Arrays.asList(allResources);
                        return list;
                    }
                }
                stamp = this.lock.readLock();
            }
        }
        finally {
            if (StampedLock.isReadLockStamp(stamp)) {
                this.lock.unlockRead(stamp);
            }
        }
    }

    private static final class DataStructureSemaphore
    extends Semaphore {
        public DataStructureSemaphore(int permits) {
            super(permits);
        }

        @Override
        protected void reducePermits(int reduction) {
            super.reducePermits(reduction);
        }
    }
}

