/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.portunif.finders;

import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.attributes.Attribute;
import org.glassfish.grizzly.filterchain.FilterChainContext;
import org.glassfish.grizzly.portunif.PUContext;
import org.glassfish.grizzly.portunif.ProtocolFinder;

public class HttpProtocolFinder
implements ProtocolFinder {
    private static final char[] METHOD_FIRST_LETTERS = new char[]{'G', 'P', 'O', 'H', 'D', 'T', 'C'};
    private final Attribute<ParsingState> parsingStateAttribute = Grizzly.DEFAULT_ATTRIBUTE_BUILDER.createAttribute(String.valueOf(HttpProtocolFinder.class) + "-" + this.hashCode() + ".parsingStateAttribute");
    private final int maxRequestLineSize;

    public HttpProtocolFinder() {
        this(2048);
    }

    public HttpProtocolFinder(int maxRequestLineSize) {
        this.maxRequestLineSize = maxRequestLineSize;
    }

    @Override
    public ProtocolFinder.Result find(PUContext puContext, FilterChainContext ctx) {
        int state;
        int position;
        Connection connection = ctx.getConnection();
        Buffer buffer = (Buffer)ctx.getMessage();
        ParsingState parsingState = this.parsingStateAttribute.get(connection);
        int limit = buffer.limit();
        if (parsingState == null) {
            position = buffer.position();
            state = 0;
        } else {
            position = parsingState.position;
            state = parsingState.state;
        }
        byte c = 0;
        block7: while (position < limit) {
            byte c2 = c;
            c = buffer.get(position++);
            switch (state) {
                case 0: {
                    for (int i = 0; i < METHOD_FIRST_LETTERS.length; ++i) {
                        if (c != METHOD_FIRST_LETTERS[i]) continue;
                        state = 1;
                        continue block7;
                    }
                    return ProtocolFinder.Result.NOT_FOUND;
                }
                case 1: {
                    if (c != 32) continue block7;
                    state = 2;
                    continue block7;
                }
                case 2: {
                    if (c != 32) continue block7;
                    state = 3;
                    continue block7;
                }
                case 3: {
                    if (c == 72) {
                        state = 4;
                        continue block7;
                    }
                    return ProtocolFinder.Result.NOT_FOUND;
                }
                case 4: {
                    if (c != 47 || c2 != 80) continue block7;
                    if (parsingState != null) {
                        this.parsingStateAttribute.remove(connection);
                    }
                    return ProtocolFinder.Result.FOUND;
                }
            }
            return ProtocolFinder.Result.NOT_FOUND;
        }
        if (position >= this.maxRequestLineSize) {
            return ProtocolFinder.Result.NOT_FOUND;
        }
        if (parsingState == null) {
            this.parsingStateAttribute.set(connection, new ParsingState(position, state));
        } else {
            parsingState.position = position;
            parsingState.state = state;
        }
        return ProtocolFinder.Result.NEED_MORE_DATA;
    }

    private static final class ParsingState {
        int position;
        int state;

        public ParsingState(int position, int state) {
            this.position = position;
            this.state = state;
        }
    }
}

