/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.codegen;

import java.io.IOException;
import java.util.Map;
import java.util.Set;
import org.eclipse.persistence.internal.codegen.CodeDefinition;
import org.eclipse.persistence.internal.codegen.CodeGenerator;

public abstract class AttributeDefinition
extends CodeDefinition {
    protected String initialValue;

    protected AttributeDefinition() {
    }

    private void adjustInitialValue(Map<String, Set<String>> typeNameMap) {
        if (this.getInitialValue() == null) {
            return;
        }
        StringBuilder initialValue = new StringBuilder(this.getInitialValue());
        Set<String> typeNames = AttributeDefinition.parseForTypeNames(initialValue.toString());
        for (String typeName : typeNames) {
            String adjustedTypeName;
            if (typeName.equals(adjustedTypeName = AttributeDefinition.adjustTypeName(typeName, typeNameMap))) continue;
            int typeNameStartIndex = initialValue.toString().indexOf(typeName);
            while (typeNameStartIndex != -1) {
                initialValue.replace(typeNameStartIndex, typeNameStartIndex + typeName.length(), adjustedTypeName);
                typeNameStartIndex = initialValue.toString().indexOf(typeName);
            }
        }
        this.setInitialValue(initialValue.toString());
    }

    protected void adjustTypeNames(Map<String, Set<String>> typeNameMap) {
        this.adjustInitialValue(typeNameMap);
    }

    public String getInitialValue() {
        return this.initialValue;
    }

    protected abstract String getTypeName();

    protected void putTypeNamesInMap(Map<String, Set<String>> typeNameMap) {
        AttributeDefinition.putTypeNameInMap(this.getTypeName(), typeNameMap);
        for (String s : AttributeDefinition.parseForTypeNames(this.getInitialValue())) {
            AttributeDefinition.putTypeNameInMap(s, typeNameMap);
        }
    }

    public void setInitialValue(String initialValue) {
        this.initialValue = initialValue;
    }

    @Override
    public void writeBody(CodeGenerator generator) throws IOException {
        generator.writeType(this.getTypeName());
        generator.writeType(" ");
        generator.write(this.getName());
        if (this.getInitialValue() != null) {
            generator.write(" = ");
            generator.write(this.getInitialValue());
        }
        generator.write(";");
    }
}

