/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.resources.mail.admin.cli;

import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Resources;
import com.sun.enterprise.util.LocalStringManagerImpl;
import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandLock;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.resourcebase.resources.util.BindableResourcesHelper;
import org.glassfish.resources.mail.config.MailResource;
import org.jvnet.hk2.annotations.Service;

@TargetType(value={CommandTarget.DAS, CommandTarget.DOMAIN, CommandTarget.CLUSTER, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTERED_INSTANCE})
@ExecuteOn(value={RuntimeType.DAS})
@Service(name="list-mail-resources")
@PerLookup
@CommandLock(value=CommandLock.LockType.NONE)
@I18n(value="list.mail.resources")
@RestEndpoints(value={@RestEndpoint(configBean=Resources.class, opType=RestEndpoint.OpType.GET, path="list-mail-resources", description="List Jakarta Mail Resources")})
public class ListMailResources
implements AdminCommand {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(ListMailResources.class);
    @Param(primary=true, optional=true, defaultValue="server")
    private String targetOperand;
    @Param(optional=true, obsolete=true)
    private String target = "server";
    @Inject
    private BindableResourcesHelper bindableResourcesHelper;
    @Inject
    private Domain domain;

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        try {
            ArrayList<String> list = new ArrayList<String>();
            Collection mailResources = this.domain.getResources().getResources(MailResource.class);
            for (MailResource mailResource : mailResources) {
                if (!this.bindableResourcesHelper.resourceExists(mailResource.getJndiName(), this.targetOperand)) continue;
                list.add(mailResource.getJndiName());
            }
            for (String jndiName : list) {
                ActionReport.MessagePart part = report.getTopMessagePart().addChild();
                part.setMessage(jndiName);
            }
            report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
        }
        catch (Exception e) {
            report.setMessage(localStrings.getLocalString("list.mail.resources.failed", "Unable to list mail resources") + " " + e.getLocalizedMessage());
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause((Throwable)e);
        }
    }
}

