/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tags.shaded.org.apache.xpath.axes;

import org.eclipse.tags.shaded.org.apache.xpath.Expression;
import org.eclipse.tags.shaded.org.apache.xpath.ExpressionOwner;
import org.eclipse.tags.shaded.org.apache.xpath.XPathVisitor;
import org.eclipse.tags.shaded.org.apache.xpath.axes.LocPathIterator;
import org.eclipse.tags.shaded.org.apache.xpath.functions.FuncLast;
import org.eclipse.tags.shaded.org.apache.xpath.functions.FuncPosition;
import org.eclipse.tags.shaded.org.apache.xpath.functions.Function;
import org.eclipse.tags.shaded.org.apache.xpath.objects.XNumber;
import org.eclipse.tags.shaded.org.apache.xpath.operations.Div;
import org.eclipse.tags.shaded.org.apache.xpath.operations.Minus;
import org.eclipse.tags.shaded.org.apache.xpath.operations.Mod;
import org.eclipse.tags.shaded.org.apache.xpath.operations.Mult;
import org.eclipse.tags.shaded.org.apache.xpath.operations.Number;
import org.eclipse.tags.shaded.org.apache.xpath.operations.Plus;
import org.eclipse.tags.shaded.org.apache.xpath.operations.Quo;
import org.eclipse.tags.shaded.org.apache.xpath.operations.Variable;

public class HasPositionalPredChecker
extends XPathVisitor {
    private boolean m_hasPositionalPred = false;
    private int m_predDepth = 0;

    public static boolean check(LocPathIterator path) {
        HasPositionalPredChecker hppc = new HasPositionalPredChecker();
        path.callVisitors(null, hppc);
        return hppc.m_hasPositionalPred;
    }

    @Override
    public boolean visitFunction(ExpressionOwner owner, Function func) {
        if (func instanceof FuncPosition || func instanceof FuncLast) {
            this.m_hasPositionalPred = true;
        }
        return true;
    }

    @Override
    public boolean visitPredicate(ExpressionOwner owner, Expression pred) {
        ++this.m_predDepth;
        if (this.m_predDepth == 1) {
            if (pred instanceof Variable || pred instanceof XNumber || pred instanceof Div || pred instanceof Plus || pred instanceof Minus || pred instanceof Mod || pred instanceof Quo || pred instanceof Mult || pred instanceof Number || pred instanceof Function) {
                this.m_hasPositionalPred = true;
            } else {
                pred.callVisitors(owner, this);
            }
        }
        --this.m_predDepth;
        return false;
    }
}

