/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.resource.allocator;

import com.sun.appserv.connectors.internal.api.PoolingException;
import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.resource.ClientSecurityInfo;
import com.sun.enterprise.resource.ConnectorXAResource;
import com.sun.enterprise.resource.ResourceHandle;
import com.sun.enterprise.resource.ResourceSpec;
import com.sun.enterprise.resource.allocator.AbstractConnectorAllocator;
import com.sun.enterprise.resource.listener.LocalTxConnectionEventListener;
import com.sun.enterprise.resource.pool.PoolManager;
import com.sun.enterprise.transaction.api.JavaEETransaction;
import jakarta.resource.ResourceException;
import jakarta.resource.spi.ConnectionEventListener;
import jakarta.resource.spi.ConnectionRequestInfo;
import jakarta.resource.spi.ManagedConnection;
import jakarta.resource.spi.ManagedConnectionFactory;
import jakarta.transaction.SystemException;
import java.util.logging.Level;
import javax.security.auth.Subject;
import javax.transaction.xa.XAResource;

public class LocalTxConnectorAllocator
extends AbstractConnectorAllocator {
    private static final String COMMIT = "COMMIT";
    private static final String ROLLBACK = "ROLLBACK";
    private static String transactionCompletionMode = System.getProperty("com.sun.enterprise.in-progress-local-transaction.completion-mode");
    private final boolean shareable;

    public LocalTxConnectorAllocator(PoolManager poolMgr, ManagedConnectionFactory mcf, ResourceSpec spec, Subject subject, ConnectionRequestInfo reqInfo, ClientSecurityInfo info, ConnectorDescriptor desc, boolean shareable) {
        super(poolMgr, mcf, spec, subject, reqInfo, info, desc);
        this.shareable = shareable;
    }

    @Override
    public ResourceHandle createResource() throws PoolingException {
        try {
            ManagedConnection mc = this.mcf.createManagedConnection(this.subject, this.reqInfo);
            ResourceHandle resource = this.createResourceHandle(mc, this.spec, this);
            LocalTxConnectionEventListener l = new LocalTxConnectionEventListener(resource);
            mc.addConnectionEventListener((ConnectionEventListener)l);
            resource.setListener(l);
            ConnectorXAResource xares = new ConnectorXAResource(resource, this.spec, this, this.info);
            resource.fillInResourceObjects(null, xares);
            return resource;
        }
        catch (ResourceException ex) {
            throw new PoolingException((Exception)((Object)ex));
        }
    }

    @Override
    public void fillInResourceObjects(ResourceHandle resource) throws PoolingException {
        try {
            ManagedConnection mc = resource.getResource();
            Object con = mc.getConnection(this.subject, this.reqInfo);
            ConnectorXAResource xares = (ConnectorXAResource)resource.getXAResource();
            xares.setUserHandle(con);
            resource.fillInResourceObjects(con, xares);
        }
        catch (ResourceException ex) {
            throw new PoolingException((Exception)((Object)ex));
        }
    }

    @Override
    public void destroyResource(ResourceHandle resource) throws PoolingException {
        try {
            ManagedConnection mc = resource.getResource();
            XAResource xares = resource.getXAResource();
            this.forceTransactionCompletion(xares);
            mc.destroy();
            LOG.finest("destroyResource for LocalTxConnectorAllocator done");
        }
        catch (Exception ex) {
            throw new PoolingException(ex);
        }
    }

    @Override
    public boolean shareableWithinComponent() {
        return this.shareable;
    }

    private void forceTransactionCompletion(XAResource xares) throws SystemException {
        ConnectorXAResource connectorXARes;
        JavaEETransaction j2eetran;
        if (transactionCompletionMode != null && xares instanceof ConnectorXAResource && (j2eetran = (connectorXARes = (ConnectorXAResource)xares).getAssociatedTransaction()) != null && j2eetran.isLocalTx() && j2eetran.getStatus() == 0) {
            try {
                if (transactionCompletionMode.equalsIgnoreCase(COMMIT)) {
                    if (LOG.isLoggable(Level.FINEST)) {
                        LOG.log(Level.FINEST, "Transaction Completion Mode for LocalTx resource is set as COMMIT, committing transaction");
                    }
                    j2eetran.commit();
                } else if (transactionCompletionMode.equalsIgnoreCase(ROLLBACK)) {
                    if (LOG.isLoggable(Level.FINEST)) {
                        LOG.log(Level.FINEST, "Transaction Completion Mode for LocalTx resource is set as ROLLBACK, rolling back transaction");
                    }
                    j2eetran.rollback();
                } else {
                    LOG.log(Level.WARNING, "Unknown transaction completion mode, no action made");
                }
            }
            catch (Exception e) {
                LOG.log(Level.WARNING, "Failure while forcibily completing an incomplete, local transaction ", e);
            }
        }
    }
}

