/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http.io;

import java.util.Arrays;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.memory.Buffers;
import org.glassfish.grizzly.memory.HeapBuffer;
import org.glassfish.grizzly.memory.MemoryManager;

final class TemporaryHeapBuffer
extends HeapBuffer {
    boolean isDisposed;
    boolean hasClonedArray;

    TemporaryHeapBuffer() {
    }

    void reset(byte[] heap, int offset, int len) {
        this.heap = heap;
        this.offset = offset;
        this.cap = len;
        this.lim = len;
        this.pos = 0;
        this.byteBuffer = null;
        this.isDisposed = false;
        this.hasClonedArray = false;
    }

    Buffer cloneContent(MemoryManager memoryManager) {
        Buffer buffer;
        int length = this.remaining();
        if (!this.hasClonedArray) {
            buffer = memoryManager.allocate(length);
            buffer.put(this.heap, this.offset + this.pos, length);
            buffer.flip();
        } else {
            buffer = Buffers.wrap((MemoryManager)memoryManager, (byte[])this.heap, (int)(this.offset + this.pos), (int)length);
        }
        buffer.allowBufferDispose(true);
        this.dispose();
        return buffer;
    }

    protected void onShareHeap() {
        if (!this.hasClonedArray) {
            this.heap = Arrays.copyOfRange(this.heap, this.offset, this.offset + this.cap);
            this.offset = 0;
            this.hasClonedArray = true;
        }
        super.onShareHeap();
    }

    public void dispose() {
        this.isDisposed = true;
        super.dispose();
    }

    boolean isDisposed() {
        return this.isDisposed;
    }

    public void recycle() {
        this.reset(null, 0, 0);
    }
}

