/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.web;

import com.sun.enterprise.config.serverbeans.AccessLog;
import com.sun.enterprise.config.serverbeans.ConfigBeansUtilities;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.HttpService;
import com.sun.enterprise.config.serverbeans.VirtualServer;
import com.sun.enterprise.util.io.FileUtils;
import com.sun.enterprise.web.accesslog.AccessLogFormatter;
import com.sun.enterprise.web.accesslog.CombinedAccessLogFormatterImpl;
import com.sun.enterprise.web.accesslog.CommonAccessLogFormatterImpl;
import com.sun.enterprise.web.accesslog.DefaultAccessLogFormatterImpl;
import com.sun.enterprise.web.pluggable.WebContainerFeatureFactory;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.text.MessageFormat;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.LinkedList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Request;
import org.apache.catalina.Response;
import org.apache.catalina.valves.ValveBase;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.web.LogFacade;

public final class PEAccessLogValve
extends ValveBase
implements Runnable {
    private static final Logger _logger = LogFacade.getLogger();
    private static final ResourceBundle _rb = _logger.getResourceBundle();
    private static final String COMMON_PATTERN = "common";
    private static final String COMBINED_PATTERN = "combined";
    private static final String LOGGING_MAX_HISTORY_FILES = "com.sun.enterprise.server.logging.max_history_files";
    private static final int MIN_BUFFER_SIZE = 5120;
    private String directory = "logs";
    private static final String info = "com.sun.enterprise.web.PEAccessLogValve/1.0";
    private String prefix = "";
    private boolean rotatable;
    private String suffix = "";
    private boolean removeLeadingDotFromSuffix;
    private String dotLessSuffix;
    private boolean resolveHosts;
    private long lastAccessLogCreationTime;
    private String condition;
    private DateTimeFormatter fileDateFormat;
    private FileChannel fileChannel;
    FileOutputStream fos;
    private int writeInterval;
    private int rotationInterval;
    private Thread writerThread;
    private boolean threadDone;
    private CharBuffer charBuffer;
    private int bufferSize = 5120;
    private boolean flushRealTime = true;
    private boolean addDateStampToFirstAccessLogFile;
    private File logFile;
    private int maxHistoryFiles;
    private boolean deleteAllHistoryFiles;
    private LinkedList<File> historyFiles;
    private AccessLogFormatter formatter;
    private final Object lock = new Object();

    public int getWriterInterval() {
        return this.writeInterval;
    }

    public void setWriterInterval(int t) {
        if (t > 0) {
            this.flushRealTime = false;
        }
        this.writeInterval = t;
    }

    public int geRotationInterval() {
        return this.rotationInterval;
    }

    public void setRotationInterval(int t) {
        this.rotationInterval = t;
    }

    public void setBufferSize(int size) {
        if (size > 0) {
            this.flushRealTime = false;
        }
        this.bufferSize = size < 5120 ? 5120 : size;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void setAddDateStampToFirstAccessLogFile(boolean add) {
        this.addDateStampToFirstAccessLogFile = add;
    }

    public String getDirectory() {
        return this.directory;
    }

    public void setDirectory(String directory) {
        this.directory = directory;
    }

    public String getInfo() {
        return info;
    }

    public void setPattern(String p) {
        this.formatter = COMMON_PATTERN.equalsIgnoreCase(p) ? new CommonAccessLogFormatterImpl() : (COMBINED_PATTERN.equalsIgnoreCase(p) ? new CombinedAccessLogFormatterImpl() : new DefaultAccessLogFormatterImpl(p, this.getContainer()));
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String p) {
        this.prefix = p;
        if (this.prefix != null && this.suffix != null && this.prefix.endsWith(".") && this.suffix.startsWith(".")) {
            this.removeLeadingDotFromSuffix = true;
            this.dotLessSuffix = this.suffix.substring(1);
        } else {
            this.removeLeadingDotFromSuffix = false;
        }
    }

    public boolean isRotatable() {
        return this.rotatable;
    }

    public void setRotatable(boolean rotatable) {
        this.rotatable = rotatable;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public void setSuffix(String s) {
        this.suffix = s;
        if (this.prefix != null && this.suffix != null && this.prefix.endsWith(".") && this.suffix.startsWith(".")) {
            this.removeLeadingDotFromSuffix = true;
            this.dotLessSuffix = this.suffix.substring(1);
        } else {
            this.removeLeadingDotFromSuffix = false;
        }
    }

    public void setResolveHosts(boolean resolveHosts) {
        this.resolveHosts = resolveHosts;
    }

    public boolean isResolveHosts() {
        return this.resolveHosts;
    }

    public String getCondition() {
        return this.condition;
    }

    public void setCondition(String condition) {
        this.condition = condition;
    }

    public String getFileDateFormat() {
        return this.fileDateFormat == null ? null : this.fileDateFormat.toString();
    }

    public void setFileDateFormat(String fileDateFormat) {
        try {
            this.fileDateFormat = DateTimeFormatter.ofPattern(fileDateFormat);
        }
        catch (Exception e) {
            this.fileDateFormat = null;
        }
    }

    public int invoke(Request request, Response response) {
        if (this.formatter != null && this.formatter.getPattern().isTimeTakenRequired()) {
            request.setNote("com.sun.enterprise.web.request.startTime", (Object)System.currentTimeMillis());
        }
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postInvoke(Request request, Response response) throws IOException {
        if (!this.started || this.condition != null && request.getRequest().getAttribute(this.condition) != null) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.charBuffer.position() == this.charBuffer.limit()) {
                this.charBuffer.limit(this.charBuffer.capacity());
            }
            int pos = this.charBuffer.position();
            for (int i = 0; i < 2; ++i) {
                try {
                    if (this.formatter == null) continue;
                    this.formatter.appendLogEntry(request, response, this.charBuffer);
                    this.charBuffer.put("\n");
                    if (!this.flushRealTime) break;
                    this.log();
                    break;
                }
                catch (BufferOverflowException ex) {
                    this.charBuffer.position(pos);
                    this.log();
                    if (i != 1) continue;
                    _logger.log(Level.SEVERE, "AS-WEB-GLUE-00098", new Object[]{ex});
                    return;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void log() throws IOException {
        long rotationIntervalLong;
        long systime;
        if (this.rotatable && (systime = System.currentTimeMillis()) - this.lastAccessLogCreationTime > (rotationIntervalLong = (long)this.rotationInterval * 1000L)) {
            PEAccessLogValve pEAccessLogValve = this;
            synchronized (pEAccessLogValve) {
                systime = System.currentTimeMillis();
                if (systime - this.lastAccessLogCreationTime > rotationIntervalLong) {
                    String lastDateStamp = this.fileDateFormat.format(this.toLocalDateTime(this.lastAccessLogCreationTime));
                    String newDateStamp = this.fileDateFormat.format(this.toLocalDateTime(systime));
                    this.lastAccessLogCreationTime = systime;
                    if (!lastDateStamp.equals(newDateStamp)) {
                        this.close();
                        this.open(newDateStamp, false);
                    }
                }
            }
        }
        Object object = this.lock;
        synchronized (object) {
            try {
                this.charBuffer.flip();
                ByteBuffer byteBuffer = ByteBuffer.wrap(this.charBuffer.toString().getBytes(Charset.defaultCharset()));
                while (byteBuffer.hasRemaining()) {
                    this.fileChannel.write(byteBuffer);
                }
            }
            catch (IOException iOException) {
            }
            finally {
                this.charBuffer.clear();
            }
        }
    }

    boolean configure(String vsId, VirtualServer vsBean, HttpService httpService, Domain domain, ServiceLocator habitat, WebContainerFeatureFactory fac, String globalAccessLogBufferSize, String globalAccessLogWriteInterval) {
        this.setPrefix(vsId + fac.getDefaultAccessLogPrefix());
        boolean start = this.updateVirtualServerProperties(vsId, vsBean, domain, habitat, globalAccessLogBufferSize, globalAccessLogWriteInterval);
        this.updateAccessLogAttributes(httpService, fac);
        return start;
    }

    boolean updateVirtualServerProperties(String vsId, VirtualServer vsBean, Domain domain, ServiceLocator services, String accessLogBufferSize, String accessLogWriteInterval) {
        String acBufferSize;
        String accessLog = vsBean.getAccessLog();
        if (accessLog == null && vsBean.getHttpAccessLog() != null) {
            accessLog = vsBean.getHttpAccessLog().getLogDirectory();
        }
        if (accessLog == null) {
            return false;
        }
        File dir = new File(accessLog);
        if (!dir.isAbsolute()) {
            String logRoot = domain.getLogRoot();
            if (logRoot != null) {
                dir = new File(logRoot, accessLog);
            } else {
                ServerEnvironment env = (ServerEnvironment)services.getService(ServerEnvironment.class, new Annotation[0]);
                dir = new File(env.getInstanceRoot(), accessLog);
            }
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "AS-WEB-GLUE-00099", new Object[]{vsId, dir.getAbsolutePath()});
        }
        this.setDirectory(dir.getAbsolutePath());
        String acWriteInterval = vsBean.getPropertyValue("accessLogWriteInterval", accessLogWriteInterval);
        if (acWriteInterval != null) {
            try {
                this.setWriterInterval(Integer.parseInt(acWriteInterval));
            }
            catch (NumberFormatException ex) {
                _logger.log(Level.WARNING, "AS-WEB-GLUE-00100", acWriteInterval);
            }
        }
        if ((acBufferSize = vsBean.getPropertyValue("accessLogBufferSize", accessLogBufferSize)) != null) {
            try {
                this.setBufferSize(Integer.parseInt(acBufferSize));
            }
            catch (NumberFormatException ex) {
                _logger.log(Level.WARNING, "AS-WEB-GLUE-00101", acBufferSize);
            }
        }
        return true;
    }

    void updateAccessLogAttributes(HttpService httpService, WebContainerFeatureFactory fac) {
        String s;
        this.setResolveHosts(false);
        AccessLog accessLogConfig = httpService.getAccessLog();
        String format = accessLogConfig == null ? ConfigBeansUtilities.getDefaultFormat() : accessLogConfig.getFormat();
        this.setPattern(format);
        int interval = 0;
        if (accessLogConfig != null) {
            s = accessLogConfig.getWriteIntervalSeconds();
            interval = Integer.parseInt(s);
            this.setWriterInterval(interval);
        }
        if (accessLogConfig == null) {
            this.setRotatable(Boolean.parseBoolean(ConfigBeansUtilities.getDefaultRotationEnabled()));
        } else {
            this.setRotatable(Boolean.parseBoolean(accessLogConfig.getRotationEnabled()));
        }
        interval = 0;
        if (accessLogConfig == null) {
            interval = Integer.parseInt(ConfigBeansUtilities.getDefaultRotationIntervalInMinutes()) * 60;
        } else {
            s = accessLogConfig.getRotationIntervalInMinutes();
            interval = Integer.parseInt(s) * 60;
        }
        this.setRotationInterval(interval);
        String rotationDateStamp = null;
        rotationDateStamp = accessLogConfig == null ? fac.getDefaultAccessLogDateStampPattern() : accessLogConfig.getRotationSuffix();
        if ("%YYYY;%MM;%DD;-%hh;h%mm;m%ss;s".equals(rotationDateStamp)) {
            rotationDateStamp = "yyyyMMdd-HH'h'mm'm'ss's'";
        }
        this.setFileDateFormat(rotationDateStamp);
        this.setSuffix(fac.getDefaultAccessLogSuffix());
        this.setAddDateStampToFirstAccessLogFile(fac.getAddDateStampToFirstAccessLogFile());
        this.deleteAllHistoryFiles = false;
        this.historyFiles = null;
        this.maxHistoryFiles = 10;
        String prop = System.getProperty(LOGGING_MAX_HISTORY_FILES);
        if (prop == null && accessLogConfig != null) {
            try {
                this.maxHistoryFiles = Integer.parseInt(accessLogConfig.getMaxHistoryFiles());
            }
            catch (NumberFormatException e) {
                String msg = MessageFormat.format(_rb.getString("AS-WEB-GLUE-00102"), accessLogConfig.getMaxHistoryFiles());
                _logger.log(Level.WARNING, msg, e);
            }
        } else if (prop != null && !prop.isEmpty()) {
            try {
                this.maxHistoryFiles = Integer.parseInt(prop);
            }
            catch (NumberFormatException e) {
                String msg = MessageFormat.format(_rb.getString("AS-WEB-GLUE-00102"), prop);
                _logger.log(Level.WARNING, msg, e);
            }
        }
        if (this.maxHistoryFiles == 0) {
            this.deleteAllHistoryFiles = true;
        } else if (this.maxHistoryFiles > 0) {
            this.historyFiles = new LinkedList();
        }
    }

    private synchronized void close() {
        try {
            this.log();
            this.fileChannel.close();
            this.fos.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private synchronized void open(String dateStamp, boolean firstAccessLogFile) throws IOException {
        _logger.log(Level.CONFIG, "open(dateStamp={0}, firstAccessLogFile={1}", new Object[]{dateStamp, firstAccessLogFile});
        File dir = new File(this.directory);
        if (!dir.isAbsolute()) {
            dir = new File(System.getProperty("catalina.base"), this.directory);
        }
        if (!FileUtils.mkdirsMaybe((File)dir)) {
            _logger.log(Level.WARNING, "AS-WEB-GLUE-00103", dir.getAbsolutePath());
        }
        try {
            String pathname = this.rotatable && this.addDateStampToFirstAccessLogFile ? dir.getAbsolutePath() + File.separator + this.prefix + dateStamp + this.suffix : (this.removeLeadingDotFromSuffix ? dir.getAbsolutePath() + File.separator + this.prefix + this.dotLessSuffix : dir.getAbsolutePath() + File.separator + this.prefix + this.suffix);
            if (this.rotatable && !this.addDateStampToFirstAccessLogFile && !firstAccessLogFile) {
                String dateStampedPathname = dir.getAbsolutePath() + File.separator + this.prefix + dateStamp + this.suffix;
                File renameToFile = new File(dateStampedPathname);
                if (!this.logFile.renameTo(renameToFile)) {
                    _logger.log(Level.WARNING, "AS-WEB-GLUE-00104", new Object[]{this.logFile.getAbsolutePath(), dateStampedPathname});
                }
                File removeFile = null;
                if (this.deleteAllHistoryFiles) {
                    removeFile = renameToFile;
                } else if (this.historyFiles != null) {
                    this.historyFiles.addLast(renameToFile);
                    if (this.historyFiles.size() > this.maxHistoryFiles) {
                        removeFile = this.historyFiles.removeFirst();
                    }
                }
                if (removeFile != null && !removeFile.delete()) {
                    _logger.log(Level.WARNING, "AS-WEB-GLUE-00105", removeFile.getAbsolutePath());
                }
            }
            this.logFile = new File(pathname);
            this.fos = new FileOutputStream(this.logFile, true);
            this.fileChannel = this.fos.getChannel();
        }
        catch (IOException ioe) {
            if (this.fileChannel != null) {
                this.fileChannel.close();
            }
            throw ioe;
        }
    }

    public void addLifecycleListener(LifecycleListener listener) {
        this.lifecycle.addLifecycleListener(listener);
    }

    public List<LifecycleListener> findLifecycleListeners() {
        return this.lifecycle.findLifecycleListeners();
    }

    public void removeLifecycleListener(LifecycleListener listener) {
        this.lifecycle.removeLifecycleListener(listener);
    }

    public void start() throws LifecycleException {
        if (this.started) {
            throw new LifecycleException(_rb.getString("AS-WEB-GLUE-00106"));
        }
        this.lifecycle.fireLifecycleEvent("start", null);
        if (this.bufferSize <= 5120) {
            this.bufferSize = 5120;
        }
        this.charBuffer = CharBuffer.allocate(this.bufferSize);
        if (this.fileDateFormat == null) {
            this.fileDateFormat = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        }
        _logger.log(Level.CONFIG, "Using fileDateFormat: {0}", this.fileDateFormat);
        long systime = System.currentTimeMillis();
        try {
            this.open(this.fileDateFormat.format(this.toLocalDateTime(systime)), true);
        }
        catch (IOException ioe) {
            throw new LifecycleException((Throwable)ioe);
        }
        this.lastAccessLogCreationTime = systime;
        if (!this.flushRealTime) {
            this.threadStart();
        }
        this.started = true;
    }

    public void stop() throws LifecycleException {
        if (!this.started) {
            throw new LifecycleException(_rb.getString("AS-WEB-GLUE-00107"));
        }
        this.lifecycle.fireLifecycleEvent("stop", null);
        this.started = false;
        if (!this.flushRealTime) {
            this.threadStop();
        }
        this.close();
    }

    @Override
    public void run() {
        while (!this.threadDone) {
            this.threadSleep();
            try {
                this.log();
            }
            catch (IOException ioe) {
                this.threadDone = true;
            }
        }
    }

    private void threadSleep() {
        if (this.writerThread == null || this.writeInterval == 0) {
            return;
        }
        try {
            Thread.sleep((long)this.writeInterval * 1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void threadStart() {
        if (this.writerThread != null || this.writeInterval == 0) {
            return;
        }
        this.threadDone = false;
        String threadName = "AccessLogWriter";
        this.writerThread = new Thread((Runnable)this, threadName);
        this.writerThread.setDaemon(true);
        this.writerThread.start();
    }

    private void threadStop() {
        if (this.writerThread == null || this.writeInterval == 0) {
            return;
        }
        this.threadDone = true;
        this.writerThread.interrupt();
        try {
            this.writerThread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.writerThread = null;
    }

    private LocalDateTime toLocalDateTime(long millis) {
        return Instant.ofEpochMilli(millis).atZone(ZoneId.systemDefault()).toLocalDateTime();
    }
}

