/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.cm.impl;

import java.io.IOException;
import org.apache.felix.cm.impl.Activator;
import org.apache.felix.cm.impl.ConfigurationAdapter;
import org.apache.felix.cm.impl.ConfigurationImpl;
import org.apache.felix.cm.impl.ConfigurationManager;
import org.apache.felix.cm.impl.Log;
import org.osgi.framework.Bundle;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.cm.ConfigurationPermission;

public class ConfigurationAdminImpl
implements ConfigurationAdmin {
    private volatile ConfigurationManager configurationManager;
    private volatile Bundle bundle;

    ConfigurationAdminImpl(ConfigurationManager configurationManager, Bundle bundle) {
        this.configurationManager = configurationManager;
        this.bundle = bundle;
    }

    void dispose() {
        this.bundle = null;
        this.configurationManager = null;
    }

    Bundle getBundle() {
        return this.bundle;
    }

    @Override
    public Configuration createFactoryConfiguration(String factoryPid) throws IOException {
        ConfigurationManager configurationManager = this.getConfigurationManager();
        Log.logger.log(4, "createFactoryConfiguration(factoryPid={0})", new Object[]{factoryPid});
        ConfigurationImpl config = configurationManager.createFactoryConfiguration(factoryPid, null);
        config.setDynamicBundleLocation(Activator.getLocation(this.getBundle()), false);
        return this.wrap(config);
    }

    @Override
    public Configuration createFactoryConfiguration(String factoryPid, String location) throws IOException {
        ConfigurationManager configurationManager = this.getConfigurationManager();
        Log.logger.log(4, "createFactoryConfiguration(factoryPid={0}, location={1})", new Object[]{factoryPid, location});
        this.checkPermission(configurationManager, location == null ? "*" : location, false);
        ConfigurationImpl config = configurationManager.createFactoryConfiguration(factoryPid, location);
        return this.wrap(config);
    }

    @Override
    public Configuration getConfiguration(String pid) throws IOException {
        ConfigurationManager configurationManager = this.getConfigurationManager();
        Log.logger.log(4, "getConfiguration(pid={0})", new Object[]{pid});
        ConfigurationImpl config = configurationManager.getConfiguration(pid);
        if (config == null) {
            config = configurationManager.createConfiguration(pid, null);
            config.setDynamicBundleLocation(Activator.getLocation(this.getBundle()), false);
        } else if (config.getBundleLocation() == null) {
            Log.logger.log(4, "Binding configuration {0} (isNew: {1}) to bundle {2}", new Object[]{config.getPid(), config.isNew() ? Boolean.TRUE : Boolean.FALSE, Activator.getLocation(this.getBundle())});
            config.setDynamicBundleLocation(Activator.getLocation(this.getBundle()), true);
        } else {
            this.checkPermission(configurationManager, config.getBundleLocation(), false);
        }
        return this.wrap(config);
    }

    @Override
    public Configuration getConfiguration(String pid, String location) throws IOException {
        ConfigurationManager configurationManager = this.getConfigurationManager();
        Log.logger.log(4, "getConfiguration(pid={0}, location={1})", new Object[]{pid, location});
        this.checkPermission(configurationManager, location == null ? "*" : location, false);
        ConfigurationImpl config = configurationManager.getConfiguration(pid);
        if (config == null) {
            config = configurationManager.createConfiguration(pid, location);
        } else {
            String configLocation = config.getBundleLocation();
            this.checkPermission(configurationManager, configLocation == null ? "*" : configLocation, false);
        }
        return this.wrap(config);
    }

    @Override
    public Configuration[] listConfigurations(String filter) throws IOException, InvalidSyntaxException {
        ConfigurationManager configurationManager = this.getConfigurationManager();
        Log.logger.log(4, "listConfigurations(filter={0})", new Object[]{filter});
        ConfigurationImpl[] ci = configurationManager.listConfigurations(this, filter);
        if (ci == null || ci.length == 0) {
            return null;
        }
        Configuration[] cfgs = new Configuration[ci.length];
        for (int i = 0; i < cfgs.length; ++i) {
            cfgs[i] = this.wrap(ci[i]);
        }
        return cfgs;
    }

    private Configuration wrap(ConfigurationImpl configuration) {
        return new ConfigurationAdapter(this, configuration);
    }

    boolean hasPermission(ConfigurationManager configurationManager, String name) {
        try {
            this.checkPermission(configurationManager, name, false);
            return true;
        }
        catch (SecurityException se) {
            return false;
        }
    }

    void checkPermission(ConfigurationManager configurationManager, String name, boolean checkOwn) {
        this.checkPermission(configurationManager, name, "configure", checkOwn);
    }

    void checkPermission(ConfigurationManager configurationManager, String name, String action, boolean checkOwn) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            if (name != null && (checkOwn || !name.equals(Activator.getLocation(this.getBundle())))) {
                try {
                    sm.checkPermission(new ConfigurationPermission(name, action));
                    Log.logger.log(4, "Explicit Permission; grant {0} permission on configuration bound to {1} to bundle {2}", new Object[]{action, name, Activator.getLocation(this.getBundle())});
                }
                catch (SecurityException se) {
                    Log.logger.log(4, "No Permission; denied {0} permission on configuration bound to {1} to bundle {2}; reason: {3}", new Object[]{action, name, Activator.getLocation(this.getBundle()), se.getMessage()});
                    throw se;
                }
            } else if (Log.logger.isLogEnabled(4)) {
                Log.logger.log(4, "Implicit Permission; grant {0} permission on configuration bound to {1} to bundle {2}", new Object[]{action, name, Activator.getLocation(this.getBundle())});
            }
        } else if (Log.logger.isLogEnabled(4)) {
            Log.logger.log(4, "No SecurityManager installed; grant {0} permission on configuration bound to {1} to bundle {2}", new Object[]{action, name, Activator.getLocation(this.getBundle())});
        }
    }

    private ConfigurationManager getConfigurationManager() {
        if (this.configurationManager == null) {
            throw new IllegalStateException("Configuration Admin service has been unregistered");
        }
        return this.configurationManager;
    }

    @Override
    public Configuration getFactoryConfiguration(String factoryPid, String name, String location) throws IOException {
        ConfigurationManager configurationManager = this.getConfigurationManager();
        Log.logger.log(4, "getFactoryConfiguration(factoryPid={0}, name={1}, location={2})", new Object[]{factoryPid, name, location});
        String pid = factoryPid + '~' + name;
        this.checkPermission(configurationManager, location == null ? "*" : location, false);
        ConfigurationImpl config = configurationManager.getConfiguration(pid);
        if (config == null) {
            config = configurationManager.createFactoryConfiguration(pid, factoryPid, location);
        } else {
            String configLocation = config.getBundleLocation();
            this.checkPermission(configurationManager, configLocation == null ? "*" : configLocation, false);
        }
        return this.wrap(config);
    }

    @Override
    public Configuration getFactoryConfiguration(String factoryPid, String name) throws IOException {
        ConfigurationManager configurationManager = this.getConfigurationManager();
        Log.logger.log(4, "getFactoryConfiguration(factoryPid={0}, name={1})", new Object[]{factoryPid, name});
        String pid = factoryPid + '~' + name;
        ConfigurationImpl config = configurationManager.getConfiguration(pid);
        if (config == null) {
            config = configurationManager.createFactoryConfiguration(pid, factoryPid, null);
            config.setDynamicBundleLocation(Activator.getLocation(this.getBundle()), false);
        } else if (config.getBundleLocation() == null) {
            Log.logger.log(4, "Binding configuration {0} (isNew: {1}) to bundle {2}", new Object[]{config.getPid(), config.isNew() ? Boolean.TRUE : Boolean.FALSE, Activator.getLocation(this.getBundle())});
            config.setDynamicBundleLocation(Activator.getLocation(this.getBundle()), true);
        } else {
            this.checkPermission(configurationManager, config.getBundleLocation(), false);
        }
        return this.wrap(config);
    }
}

