/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jdeparser;

import java.util.Locale;
import org.jboss.jdeparser.AbstractJComment;
import org.jboss.jdeparser.HtmlCommentContent;
import org.jboss.jdeparser.ImplJHtmlTag;
import org.jboss.jdeparser.JComment;
import org.jboss.jdeparser.JHtmlComment;
import org.jboss.jdeparser.JHtmlTag;
import org.jboss.jdeparser.JType;
import org.jboss.jdeparser.NestedHtmlCommentContent;

abstract class AbstractJHtmlComment
extends AbstractJComment
implements JHtmlComment {
    AbstractJHtmlComment() {
    }

    @Override
    protected <T extends HtmlCommentContent> T add(T item) {
        this.addItemDirectly(item);
        return item;
    }

    @Override
    public JHtmlComment block() {
        return this.add(new NestedHtmlCommentContent());
    }

    @Override
    public JHtmlComment sp() {
        super.sp();
        return this;
    }

    @Override
    public JHtmlComment nl() {
        super.nl();
        return this;
    }

    @Override
    public JHtmlComment typeName(JType type) {
        super.typeName(type);
        return this;
    }

    @Override
    public JHtmlComment text(String text) {
        super.text(text);
        return this;
    }

    @Override
    public JHtmlComment inlineDocTag(String tag, String body) {
        super.inlineDocTag(tag, body);
        return this;
    }

    @Override
    public JHtmlComment docRoot() {
        super.docRoot();
        return this;
    }

    @Override
    public JHtmlComment p() {
        this.nl();
        this.htmlTag("p", false);
        this.nl();
        return this;
    }

    @Override
    public JHtmlComment br() {
        this.htmlTag("br", false);
        this.nl();
        return this;
    }

    @Override
    public JHtmlComment value(JType type, String fieldName) {
        this.inlineDocTag("value").typeName(type).text("#").text(fieldName);
        return this;
    }

    @Override
    public JHtmlTag htmlLink(String url) {
        return this.htmlTag("a", false).attribute("href", url);
    }

    @Override
    public JHtmlTag htmlTag(String tag, boolean newLine) {
        boolean writeClose;
        switch (tag.toLowerCase(Locale.US)) {
            case "area": 
            case "base": 
            case "basefont": 
            case "br": 
            case "col": 
            case "frame": 
            case "hr": 
            case "img": 
            case "input": 
            case "isindex": 
            case "link": 
            case "meta": 
            case "param": 
            case "body": 
            case "colgroup": 
            case "dd": 
            case "dt": 
            case "head": 
            case "html": 
            case "li": 
            case "option": 
            case "p": 
            case "tbody": 
            case "td": 
            case "textarea": 
            case "tfoot": 
            case "th": 
            case "thead": 
            case "tr": {
                writeClose = false;
                break;
            }
            default: {
                writeClose = true;
            }
        }
        ImplJHtmlTag htmlTag = new ImplJHtmlTag(tag, newLine, writeClose);
        return this.add(htmlTag);
    }

    @Override
    public JComment preformattedCode() {
        JComment main = this.htmlTag("pre", false).code().nl();
        JComment block = main.block();
        main.nl();
        return block;
    }
}

