/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.beanvalidation.tck.tests.constraints.constraintcomposition.nestedconstraintcomposition;

import jakarta.validation.Validator;
import jakarta.validation.constraints.Pattern;
import jakarta.validation.constraints.Size;
import java.util.Set;
import org.hibernate.beanvalidation.tck.tests.AbstractTCKTest;
import org.hibernate.beanvalidation.tck.tests.constraints.constraintcomposition.nestedconstraintcomposition.CompositeConstraint1;
import org.hibernate.beanvalidation.tck.tests.constraints.constraintcomposition.nestedconstraintcomposition.CompositeConstraint2;
import org.hibernate.beanvalidation.tck.tests.constraints.constraintcomposition.nestedconstraintcomposition.CompositeConstraint3;
import org.hibernate.beanvalidation.tck.tests.constraints.constraintcomposition.nestedconstraintcomposition.CompositeConstraint4;
import org.hibernate.beanvalidation.tck.tests.constraints.constraintcomposition.nestedconstraintcomposition.NestedConstraintSingleViolation;
import org.hibernate.beanvalidation.tck.util.ConstraintViolationAssert;
import org.hibernate.beanvalidation.tck.util.TestUtil;
import org.hibernate.beanvalidation.tck.util.shrinkwrap.WebArchiveBuilder;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.annotations.Test;

@SpecVersion(spec="beanvalidation", version="4.0.0")
public class NestedConstraintCompositionTest
extends AbstractTCKTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)NestedConstraintCompositionTest.webArchiveBuilder().withTestClassPackage(NestedConstraintCompositionTest.class)).build();
    }

    @Test
    @SpecAssertion(section="constraintsdefinitionimplementation-constraintcomposition", id="l")
    public void testCompositeConstraint1WithNestedConstraintSingleViolation() {
        Validator validator = TestUtil.getValidatorUnderTest();
        DummyEntity1 dummy = new DummyEntity1("");
        Set constraintViolations = validator.validate((Object)dummy, new Class[0]);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyViolations(ConstraintViolationAssert.violationOf(Pattern.class).withMessage("Pattern must match abc"), ConstraintViolationAssert.violationOf(NestedConstraintSingleViolation.class).withMessage("NestedConstraintSingleViolation failed."));
    }

    @Test
    @SpecAssertion(section="constraintsdefinitionimplementation-constraintcomposition", id="l")
    public void testCompositeConstraint2WithNestedConstraintSingleViolation() {
        Validator validator = TestUtil.getValidatorUnderTest();
        DummyEntity2 dummy = new DummyEntity2("");
        Set constraintViolations = validator.validate((Object)dummy, new Class[0]);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyViolations(ConstraintViolationAssert.violationOf(CompositeConstraint2.class).withMessage("CompositeConstraint2 failed."));
    }

    @Test
    @SpecAssertion(section="constraintsdefinitionimplementation-constraintcomposition", id="l")
    public void testCompositeConstraint3WithNestedConstraint() {
        Validator validator = TestUtil.getValidatorUnderTest();
        DummyEntity3 dummy = new DummyEntity3("");
        Set constraintViolations = validator.validate((Object)dummy, new Class[0]);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyViolations(ConstraintViolationAssert.violationOf(Pattern.class).withMessage("Pattern must match abc"), ConstraintViolationAssert.violationOf(Pattern.class).withMessage("Pattern must match ..."), ConstraintViolationAssert.violationOf(Size.class).withMessage("Size must be 3"));
    }

    @Test
    @SpecAssertion(section="constraintsdefinitionimplementation-constraintcomposition", id="l")
    public void testCompositeConstraint4WithNestedConstraintSingleViolation() {
        Validator validator = TestUtil.getValidatorUnderTest();
        DummyEntity4 dummy = new DummyEntity4("");
        Set constraintViolations = validator.validate((Object)dummy, new Class[0]);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyViolations(ConstraintViolationAssert.violationOf(CompositeConstraint4.class).withMessage("CompositeConstraint4 failed."));
    }

    class DummyEntity1 {
        @CompositeConstraint1
        String string;

        DummyEntity1(String s) {
            this.string = s;
        }
    }

    class DummyEntity2 {
        @CompositeConstraint2
        String string;

        DummyEntity2(String s) {
            this.string = s;
        }
    }

    class DummyEntity3 {
        @CompositeConstraint3
        String string;

        DummyEntity3(String s) {
            this.string = s;
        }
    }

    class DummyEntity4 {
        @CompositeConstraint4
        String string;

        DummyEntity4(String s) {
            this.string = s;
        }
    }
}

