/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.jar.asmjdkbridge;

import java.lang.classfile.attribute.CharacterRangeInfo;
import java.lang.classfile.attribute.CharacterRangeTableAttribute;
import java.lang.classfile.attribute.CodeAttribute;
import java.lang.classfile.attribute.CompilationIDAttribute;
import java.lang.classfile.attribute.ModuleHashInfo;
import java.lang.classfile.attribute.ModuleHashesAttribute;
import java.lang.classfile.attribute.ModuleResolutionAttribute;
import java.lang.classfile.attribute.SourceIDAttribute;
import java.lang.classfile.attribute.UnknownAttribute;
import java.lang.classfile.instruction.CharacterRange;
import java.util.List;
import net.bytebuddy.jar.asm.Attribute;
import net.bytebuddy.jar.asm.ByteVector;
import net.bytebuddy.jar.asm.ClassReader;
import net.bytebuddy.jar.asm.ClassWriter;
import net.bytebuddy.jar.asm.Label;
import net.bytebuddy.jar.asmjdkbridge.AsmAttribute;

abstract class AsmWrappedAttribute<A extends java.lang.classfile.Attribute<?>>
extends Attribute {
    final A attribute;

    protected AsmWrappedAttribute(A attribute) {
        super(attribute.attributeName().stringValue());
        this.attribute = attribute;
    }

    static <T> T unwrap(Attribute attribute, Class<T> type) {
        T t;
        if (attribute instanceof AsmWrappedAttribute) {
            AsmWrappedAttribute wrappedAttribute = (AsmWrappedAttribute)attribute;
            t = type.cast(wrappedAttribute.attribute);
        } else {
            t = type.cast((Object)AsmAttribute.of(attribute));
        }
        return type.cast(t);
    }

    @Override
    protected final Attribute read(ClassReader classReader, int offset, int length, char[] charBuffer, int codeAttributeOffset, Label[] labels) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected abstract ByteVector write(ClassWriter var1, byte[] var2, int var3, int var4, int var5);

    @Override
    public final boolean isUnknown() {
        return false;
    }

    static class AsmUnknownAttribute
    extends AsmWrappedAttribute<UnknownAttribute> {
        private final boolean code;

        AsmUnknownAttribute(UnknownAttribute attribute, boolean code) {
            super(attribute);
            this.code = code;
        }

        @Override
        protected ByteVector write(ClassWriter classWriter, byte[] code, int codeLength, int maxStack, int maxLocals) {
            ByteVector vector = new ByteVector(((UnknownAttribute)this.attribute).contents().length);
            vector.putByteArray(((UnknownAttribute)this.attribute).contents(), 0, ((UnknownAttribute)this.attribute).contents().length);
            return vector;
        }

        @Override
        public boolean isCodeAttribute() {
            return this.code;
        }
    }

    static class AsmCharacterRangeTableAttribute
    extends AsmWrappedAttribute<CharacterRangeTableAttribute> {
        AsmCharacterRangeTableAttribute(CharacterRangeTableAttribute attribute) {
            super(attribute);
        }

        static AsmWrappedAttribute<CharacterRangeTableAttribute> of(List<CharacterRange> characterRanges, CodeAttribute codeAttribute) {
            return new AsmCharacterRangeTableAttribute(CharacterRangeTableAttribute.of(characterRanges.stream().map(characterRange -> CharacterRangeInfo.of((int)codeAttribute.labelToBci(characterRange.startScope()), (int)codeAttribute.labelToBci(characterRange.endScope()), (int)characterRange.characterRangeStart(), (int)characterRange.characterRangeEnd(), (int)characterRange.flags())).toList()));
        }

        @Override
        protected ByteVector write(ClassWriter classWriter, byte[] code, int codeLength, int maxStack, int maxLocals) {
            ByteVector byteVector = new ByteVector(2 + 14 * ((CharacterRangeTableAttribute)this.attribute).characterRangeTable().size());
            byteVector.putShort(((CharacterRangeTableAttribute)this.attribute).characterRangeTable().size());
            for (CharacterRangeInfo characterRangeInfo : ((CharacterRangeTableAttribute)this.attribute).characterRangeTable()) {
                byteVector.putShort(characterRangeInfo.startPc());
                byteVector.putShort(characterRangeInfo.endPc());
                byteVector.putInt(characterRangeInfo.characterRangeStart());
                byteVector.putInt(characterRangeInfo.characterRangeEnd());
                byteVector.putShort(characterRangeInfo.flags());
            }
            return byteVector;
        }

        @Override
        public boolean isCodeAttribute() {
            return true;
        }
    }

    static class AsmSourceIdAttribute
    extends AsmWrappedAttribute<SourceIDAttribute> {
        AsmSourceIdAttribute(SourceIDAttribute attribute) {
            super(attribute);
        }

        @Override
        protected ByteVector write(ClassWriter classWriter, byte[] code, int codeLength, int maxStack, int maxLocals) {
            int index = classWriter.newUTF8(((SourceIDAttribute)this.attribute).sourceId().stringValue());
            ByteVector byteVector = new ByteVector(2);
            byteVector.putShort(index);
            return byteVector;
        }
    }

    static class AsmModuleResolutionAttribute
    extends AsmWrappedAttribute<ModuleResolutionAttribute> {
        AsmModuleResolutionAttribute(ModuleResolutionAttribute attribute) {
            super(attribute);
        }

        @Override
        protected ByteVector write(ClassWriter classWriter, byte[] code, int codeLength, int maxStack, int maxLocals) {
            ByteVector byteVector = new ByteVector(2);
            byteVector.putShort(((ModuleResolutionAttribute)this.attribute).resolutionFlags());
            return byteVector;
        }
    }

    static class AsmModuleHashesAttribute
    extends AsmWrappedAttribute<ModuleHashesAttribute> {
        AsmModuleHashesAttribute(ModuleHashesAttribute attribute) {
            super(attribute);
        }

        @Override
        protected ByteVector write(ClassWriter classWriter, byte[] code, int codeLength, int maxStack, int maxLocals) {
            ByteVector bytes = new ByteVector();
            bytes.putShort(classWriter.newUTF8(((ModuleHashesAttribute)this.attribute).algorithm().stringValue()));
            bytes.putShort(((ModuleHashesAttribute)this.attribute).hashes().size());
            for (ModuleHashInfo info : ((ModuleHashesAttribute)this.attribute).hashes()) {
                bytes.putShort(classWriter.newModule(info.moduleName().name().stringValue()));
                bytes.putShort(info.hash().length);
                bytes.putByteArray(info.hash(), 0, info.hash().length);
            }
            return bytes;
        }
    }

    static class AsmCompilationIdAttribute
    extends AsmWrappedAttribute<CompilationIDAttribute> {
        AsmCompilationIdAttribute(CompilationIDAttribute attribute) {
            super(attribute);
        }

        @Override
        protected ByteVector write(ClassWriter classWriter, byte[] code, int codeLength, int maxStack, int maxLocals) {
            int index = classWriter.newUTF8(((CompilationIDAttribute)this.attribute).compilationId().stringValue());
            ByteVector byteVector = new ByteVector(2);
            byteVector.putShort(index);
            return byteVector;
        }
    }
}

