/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.wrapper;

import java.net.URI;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.maven.wrapper.WrapperConfiguration;

public class PathAssembler {
    public static final String MAVEN_USER_HOME_STRING = "MAVEN_USER_HOME";
    public static final String PROJECT_STRING = "PROJECT";
    private Path mavenUserHome;

    public PathAssembler() {
    }

    public PathAssembler(Path mavenUserHome) {
        this.mavenUserHome = mavenUserHome;
    }

    public LocalDistribution getDistribution(WrapperConfiguration configuration) {
        String baseName = this.getBaseName(configuration.getDistribution());
        String distName = this.removeExtension(baseName);
        Path rootDirName = this.rootDirName(distName, configuration);
        Path distDir = this.getBaseDir(configuration.getDistributionBase()).resolve(configuration.getDistributionPath()).resolve(rootDirName);
        Path distZip = this.getBaseDir(configuration.getZipBase()).resolve(configuration.getZipPath()).resolve(rootDirName).resolve(baseName);
        return new LocalDistribution(distDir, distZip);
    }

    private Path rootDirName(String distName, WrapperConfiguration configuration) {
        String urlHash = this.getHash(configuration.getDistribution());
        return Paths.get(distName, urlHash);
    }

    private String getHash(URI path) {
        return Integer.toHexString(path.hashCode());
    }

    private String removeExtension(String name) {
        int dot = name.lastIndexOf(".");
        return dot > 0 ? name.substring(0, dot) : name;
    }

    private String getBaseName(URI distUrl) {
        if (distUrl.getScheme().equals("file")) {
            return Paths.get(distUrl).getFileName().toString();
        }
        return Paths.get(distUrl.getPath(), new String[0]).getFileName().toString();
    }

    private Path getBaseDir(String base) {
        if (MAVEN_USER_HOME_STRING.equals(base)) {
            return this.mavenUserHome;
        }
        if (PROJECT_STRING.equals(base)) {
            return Paths.get(System.getProperty("user.dir"), new String[0]);
        }
        throw new RuntimeException("Base: " + base + " is unknown");
    }

    public static class LocalDistribution {
        private final Path distZip;
        private final Path distDir;

        public LocalDistribution(Path distDir, Path distZip) {
            this.distDir = distDir;
            this.distZip = distZip;
        }

        public Path getDistributionDir() {
            return this.distDir;
        }

        public Path getZipFile() {
            return this.distZip;
        }
    }
}

