/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.beanvalidation.tck.tests.bootstrap;

import jakarta.validation.Configuration;
import jakarta.validation.Validator;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Set;
import org.hibernate.beanvalidation.tck.tests.AbstractTCKTest;
import org.hibernate.beanvalidation.tck.tests.bootstrap.Address;
import org.hibernate.beanvalidation.tck.tests.bootstrap.User;
import org.hibernate.beanvalidation.tck.util.ConstraintViolationAssert;
import org.hibernate.beanvalidation.tck.util.TestUtil;
import org.hibernate.beanvalidation.tck.util.shrinkwrap.WebArchiveBuilder;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@SpecVersion(spec="beanvalidation", version="4.0.0")
public class ConfigurationTest
extends AbstractTCKTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)ConfigurationTest.webArchiveBuilder().withTestClass(ConfigurationTest.class)).withClass(User.class)).withClass(Address.class)).withResource("user-constraints-ConfigurationTest.xml")).withResource("address-constraints-ConfigurationTest.xml")).build();
    }

    @Test
    @SpecAssertion(section="validationapi-bootstrapping-configuration", id="l")
    public void testProviderUnderTestDefinesSubInterfaceOfConfiguration() {
        Type[] types;
        boolean foundSubinterfaceOfConfiguration = false;
        for (Type type : types = TestUtil.getValidationProviderUnderTest().getClass().getGenericInterfaces()) {
            Type[] typeArguments;
            if (!(type instanceof ParameterizedType)) continue;
            ParameterizedType paramType = (ParameterizedType)type;
            for (Type typeArgument : typeArguments = paramType.getActualTypeArguments()) {
                if (!(typeArgument instanceof Class) || !Configuration.class.isAssignableFrom((Class)typeArgument)) continue;
                foundSubinterfaceOfConfiguration = true;
            }
        }
        Assert.assertTrue((boolean)foundSubinterfaceOfConfiguration, (String)"Could not find subinterface of Configuration");
    }

    @Test
    @SpecAssertion(section="validationapi-bootstrapping-configuration", id="i")
    public void testMappingsCanBeAddedViaConfiguration() {
        Configuration<?> configuration = TestUtil.getConfigurationUnderTest();
        configuration.addMapping(ConfigurationTest.class.getResourceAsStream("user-constraints-ConfigurationTest.xml"));
        configuration.addMapping(ConfigurationTest.class.getResourceAsStream("address-constraints-ConfigurationTest.xml"));
        Validator validator = configuration.buildValidatorFactory().getValidator();
        Set constraintViolations = validator.validate((Object)new User(), new Class[0]);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyPaths(ConstraintViolationAssert.pathWith().property("firstName"), ConstraintViolationAssert.pathWith().property("lastName"), ConstraintViolationAssert.pathWith().property("address").property("street"));
    }

    @Test
    @SpecAssertion(section="validationapi-bootstrapping-configuration", id="j")
    public void testNonResettableInputStreamCanBeAddedViaConfigurationAndFactoryCanBeCreatedSeveralTimes() {
        Configuration<?> configuration = TestUtil.getConfigurationUnderTest();
        configuration.addMapping((InputStream)new NonResettableInputStream(ConfigurationTest.class.getResourceAsStream("user-constraints-ConfigurationTest.xml")));
        Validator validator1 = configuration.buildValidatorFactory().getValidator();
        Set constraintViolations = validator1.validate((Object)new User(), new Class[0]);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyPaths(ConstraintViolationAssert.pathWith().property("firstName"), ConstraintViolationAssert.pathWith().property("lastName"));
        configuration.addMapping((InputStream)new NonResettableInputStream(ConfigurationTest.class.getResourceAsStream("address-constraints-ConfigurationTest.xml")));
        Validator validator2 = configuration.buildValidatorFactory().getValidator();
        constraintViolations = validator2.validate((Object)new User(), new Class[0]);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyPaths(ConstraintViolationAssert.pathWith().property("firstName"), ConstraintViolationAssert.pathWith().property("lastName"), ConstraintViolationAssert.pathWith().property("address").property("street"));
        validator2 = configuration.buildValidatorFactory().getValidator();
        constraintViolations = validator2.validate((Object)new User(), new Class[0]);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyPaths(ConstraintViolationAssert.pathWith().property("firstName"), ConstraintViolationAssert.pathWith().property("lastName"), ConstraintViolationAssert.pathWith().property("address").property("street"));
    }

    @Test
    @SpecAssertion(section="validationapi-bootstrapping-configuration", id="k")
    public void testSeveralFactoriesCanBeBuildFromOneConfiguration() {
        Configuration<?> configuration = TestUtil.getConfigurationUnderTest();
        Validator validator1 = configuration.buildValidatorFactory().getValidator();
        Set constraintViolations = validator1.validate((Object)new User(), new Class[0]);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyPaths(ConstraintViolationAssert.pathWith().property("firstName"));
        configuration.addMapping(ConfigurationTest.class.getResourceAsStream("user-constraints-ConfigurationTest.xml"));
        Validator validator2 = configuration.buildValidatorFactory().getValidator();
        constraintViolations = validator2.validate((Object)new User(), new Class[0]);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyPaths(ConstraintViolationAssert.pathWith().property("firstName"), ConstraintViolationAssert.pathWith().property("lastName"));
        constraintViolations = validator1.validate((Object)new User(), new Class[0]);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyPaths(ConstraintViolationAssert.pathWith().property("firstName"));
        configuration.addMapping(ConfigurationTest.class.getResourceAsStream("address-constraints-ConfigurationTest.xml"));
        Validator validator3 = configuration.buildValidatorFactory().getValidator();
        constraintViolations = validator3.validate((Object)new User(), new Class[0]);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyPaths(ConstraintViolationAssert.pathWith().property("firstName"), ConstraintViolationAssert.pathWith().property("lastName"), ConstraintViolationAssert.pathWith().property("address").property("street"));
        constraintViolations = validator1.validate((Object)new User(), new Class[0]);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyPaths(ConstraintViolationAssert.pathWith().property("firstName"));
        constraintViolations = validator2.validate((Object)new User(), new Class[0]);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyPaths(ConstraintViolationAssert.pathWith().property("firstName"), ConstraintViolationAssert.pathWith().property("lastName"));
    }

    private static class NonResettableInputStream
    extends InputStream {
        private final InputStream delegate;

        public NonResettableInputStream(InputStream delegate) {
            this.delegate = delegate;
        }

        @Override
        public int available() throws IOException {
            return this.delegate.available();
        }

        @Override
        public void close() throws IOException {
            this.delegate.close();
        }

        @Override
        public synchronized void mark(int readlimit) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean markSupported() {
            return false;
        }

        @Override
        public int read() throws IOException {
            return 0;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            return this.delegate.read(b, off, len);
        }

        @Override
        public int read(byte[] b) throws IOException {
            return this.delegate.read(b);
        }

        @Override
        public synchronized void reset() throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public long skip(long n) throws IOException {
            return this.delegate.skip(n);
        }
    }
}

