/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.edapt.history.instantiation.ui;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edapt.common.IExtentProvider;
import org.eclipse.emf.edapt.common.ui.SelectionUtils;
import org.eclipse.emf.edapt.history.OperationInstance;
import org.eclipse.emf.edapt.history.instantiation.OperationInstanceHelper;
import org.eclipse.emf.edapt.history.instantiation.ui.ConstraintViewer;
import org.eclipse.emf.edapt.history.instantiation.ui.OperationViewer;
import org.eclipse.emf.edapt.history.instantiation.ui.ParameterViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OperationSash
extends SashForm {
    private OperationViewer operationViewer;
    private ParameterViewer parameterViewer;
    private ConstraintViewer constraintViewer;
    private final OperationInstanceHelper helper;

    public OperationSash(Composite parent, IExtentProvider provider) {
        super(parent, 512);
        this.helper = new OperationInstanceHelper(provider);
        this.init();
    }

    private void init() {
        this.initOperationViewer();
        this.initParameterViewer();
        this.initConstraintViewer();
        this.operationViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                OperationInstance operationInstance = (OperationInstance)SelectionUtils.getSelectedElement((ISelection)event.getSelection());
                if (operationInstance != null) {
                    OperationSash.this.parameterViewer.setInput(operationInstance);
                    OperationSash.this.updateConstraints(operationInstance);
                }
            }
        });
        this.setWeights(new int[]{3, 2, 2});
    }

    private void initOperationViewer() {
        Composite composite = new Composite((Composite)this, 0);
        composite.setLayout((Layout)new GridLayout(1, false));
        Label operationLabel = new Label(composite, 0);
        operationLabel.setText("Applicable Operations:");
        operationLabel.setLayoutData((Object)new GridData(768));
        this.operationViewer = new OperationViewer(composite);
        this.operationViewer.getTable().setLayoutData((Object)new GridData(1808));
    }

    private void initParameterViewer() {
        Composite composite = new Composite((Composite)this, 0);
        composite.setLayout((Layout)new GridLayout(1, false));
        Label parameterLabel = new Label(composite, 0);
        parameterLabel.setText("Parameters:");
        parameterLabel.setLayoutData((Object)new GridData(768));
        this.parameterViewer = new ParameterViewer(composite, this);
        this.parameterViewer.getTable().setLayoutData((Object)new GridData(1808));
    }

    private void initConstraintViewer() {
        Composite composite = new Composite((Composite)this, 0);
        composite.setLayout((Layout)new GridLayout(1, false));
        Label constraintLabel = new Label(composite, 0);
        constraintLabel.setText("Violated constraints:");
        constraintLabel.setLayoutData((Object)new GridData(768));
        this.constraintViewer = new ConstraintViewer(composite);
        this.constraintViewer.getTable().setLayoutData((Object)new GridData(1808));
    }

    public boolean setFocus() {
        if (this.operationViewer != null) {
            return this.operationViewer.getControl().setFocus();
        }
        return false;
    }

    public OperationInstance getSelectedOperation() {
        OperationInstance operationInstance = (OperationInstance)SelectionUtils.getSelectedElement((ISelection)this.operationViewer.getSelection());
        return operationInstance;
    }

    protected boolean updateConstraints(OperationInstance operationInstance) {
        List violatedConstraints = this.helper.getViolatedConstraints(operationInstance);
        this.constraintViewer.setInput(violatedConstraints);
        return violatedConstraints.isEmpty();
    }

    public void updateOperations(IStructuredSelection structuredSelection) {
        ArrayList<EObject> selectedElements = new ArrayList<EObject>();
        for (Object o : structuredSelection) {
            if (!(o instanceof EObject)) continue;
            EObject element = (EObject)o;
            selectedElements.add(element);
        }
        List possibleOperations = this.helper.getPossibleOperations(selectedElements);
        this.updateViewers(possibleOperations);
    }

    protected void updateViewers(List<OperationInstance> possibleOperations) {
        this.operationViewer.setInput(possibleOperations);
        this.parameterViewer.setInput(null);
        this.constraintViewer.setInput(new ArrayList());
    }

    protected OperationInstanceHelper getHelper() {
        return this.helper;
    }

    public OperationViewer getOperationViewer() {
        return this.operationViewer;
    }
}

