/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.edapt.history.reconstruction;

import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edapt.common.MetamodelExtent;
import org.eclipse.emf.edapt.history.reconstruction.Mapping;
import org.eclipse.emf.edapt.history.reconstruction.ReconstructorBase;
import org.eclipse.emf.edapt.spi.history.Change;
import org.eclipse.emf.edapt.spi.history.CompositeChange;
import org.eclipse.emf.edapt.spi.history.Create;
import org.eclipse.emf.edapt.spi.history.Delete;
import org.eclipse.emf.edapt.spi.history.History;
import org.eclipse.emf.edapt.spi.history.MigrationChange;
import org.eclipse.emf.edapt.spi.history.OperationChange;
import org.eclipse.emf.edapt.spi.history.OperationInstance;
import org.eclipse.emf.edapt.spi.history.Release;

public class HistoryReconstructor
extends ReconstructorBase {
    private Mapping mapping;
    private Resource historyResource;
    private History reproducedHistory;

    public void init(Mapping mapping, MetamodelExtent extent) {
        this.mapping = mapping;
    }

    public void startHistory(History originalHistory) {
        this.reproducedHistory = (History)this.mapping.copyResolveTarget(originalHistory, false);
        this.mapping.map(originalHistory, this.reproducedHistory);
    }

    public void startRelease(Release originalRelease) {
        this.copy(originalRelease);
    }

    public void startChange(Change originalChange) {
        if (this.isCompositeChange(originalChange)) {
            this.copy(originalChange);
        } else if (originalChange.eContainer() instanceof Create) {
            if (this.mapping.getTarget(originalChange = (Create)originalChange.eContainer()) != null) {
                return;
            }
            Change reproducedChange = (Change)this.copy(originalChange);
            this.createHistoryResource(reproducedChange);
        }
    }

    public void endChange(Change originalChange) {
        if (!(this.isCompositeChange(originalChange) || originalChange instanceof Create && !((Create)originalChange).getChanges().isEmpty())) {
            Change reproducedChange = (Change)this.copy(originalChange);
            this.createHistoryResource(reproducedChange);
        }
    }

    private boolean isCompositeChange(Change change) {
        return change instanceof CompositeChange || change instanceof MigrationChange;
    }

    private EObject copy(EObject original) {
        EObject reproduced = this.mapping.copyResolveTarget(original, false);
        if (original instanceof Delete) {
            Delete delete = (Delete)original;
            EObject target = this.mapping.getTarget(delete.getElement());
            ((Delete)reproduced).setElement(target);
        } else if (original instanceof OperationChange) {
            OperationChange operationChange = (OperationChange)original;
            OperationInstance target = (OperationInstance)this.mapping.copyResolveTarget(operationChange.getOperation());
            ((OperationChange)reproduced).setOperation(target);
        }
        this.mapping.map(original, reproduced);
        this.attach(original, reproduced);
        return reproduced;
    }

    private void attach(EObject original, EObject reproduced) {
        EReference reference = original.eContainmentFeature();
        EObject reproducedContainer = this.mapping.resolveTarget(original.eContainer());
        if (reference.isMany()) {
            ((List)reproducedContainer.eGet((EStructuralFeature)reference)).add(reproduced);
        } else {
            reproducedContainer.eSet((EStructuralFeature)reference, (Object)reproduced);
        }
    }

    private void createHistoryResource(Change reproducedChange) {
        Create createChild;
        if (reproducedChange instanceof Create && (createChild = (Create)reproducedChange).getElement() instanceof EPackage && createChild.getTarget() == null && this.historyResource == null) {
            EPackage reproducedPackage = (EPackage)createChild.getElement();
            Resource modelResource = reproducedPackage.eResource();
            this.historyResource = this.createHistoryResource(modelResource);
            this.historyResource.getContents().add((Object)this.reproducedHistory);
        }
    }

    private Resource createHistoryResource(Resource modelResource) {
        URI modelURI = modelResource.getURI();
        String name = modelURI.trimFileExtension().lastSegment();
        URI folder = modelURI.trimSegments(1);
        ResourceSet resourceSet = modelResource.getResourceSet();
        Resource historyResource = resourceSet.createResource(folder.appendSegment(name).appendFileExtension("history"));
        resourceSet.getResources().add((Object)historyResource);
        return historyResource;
    }
}

