/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.internal.core.swt.renderer;

import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import org.eclipse.core.databinding.property.value.IValueProperty;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecp.view.internal.core.swt.MatchItemComboViewer;
import org.eclipse.emf.ecp.view.internal.core.swt.renderer.EnumComboViewerSWTRenderer;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContext;
import org.eclipse.emf.ecp.view.spi.model.VControl;
import org.eclipse.emf.ecp.view.template.model.VTViewTemplateProvider;
import org.eclipse.emfforms.common.Optional;
import org.eclipse.emfforms.spi.common.report.ReportService;
import org.eclipse.emfforms.spi.core.services.databinding.DatabindingFailedException;
import org.eclipse.emfforms.spi.core.services.databinding.EMFFormsDatabinding;
import org.eclipse.emfforms.spi.core.services.editsupport.EMFFormsEditSupport;
import org.eclipse.emfforms.spi.core.services.label.EMFFormsLabelProvider;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class EnumLiteralFilteredComboViewerSWTRenderer
extends EnumComboViewerSWTRenderer {
    private final EMFFormsEditSupport emfFormsEditSupport;

    @Inject
    public EnumLiteralFilteredComboViewerSWTRenderer(VControl vElement, ViewModelContext viewContext, ReportService reportService, EMFFormsDatabinding emfFormsDatabinding, EMFFormsLabelProvider emfFormsLabelProvider, VTViewTemplateProvider vtViewTemplateProvider, EMFFormsEditSupport emfFormsEditSupport) {
        super(vElement, viewContext, reportService, emfFormsDatabinding, emfFormsLabelProvider, vtViewTemplateProvider, emfFormsEditSupport);
        this.emfFormsEditSupport = emfFormsEditSupport;
    }

    @Override
    protected Viewer createJFaceViewer(Composite parent) throws DatabindingFailedException {
        IValueProperty valueProperty = this.getEMFFormsDatabinding().getValueProperty(((VControl)this.getVElement()).getDomainModelReference(), this.getViewModelContext().getDomainModel());
        EStructuralFeature structuralFeature = (EStructuralFeature)valueProperty.getValueType();
        final EList eLiterals = ((EEnum)EEnum.class.cast(structuralFeature.getEType())).getELiterals();
        final CCombo combo = new CCombo(parent, 2048);
        MatchItemComboViewer viewer = new MatchItemComboViewer(combo){

            @Override
            public void onEnter(int selectedIndex) {
                if (!this.isEmptyBuffer() && selectedIndex > -1) {
                    String closestMatch = this.getCCombo().getItems()[selectedIndex];
                    Optional findLiteral = EnumLiteralFilteredComboViewerSWTRenderer.findLiteral((List)eLiterals, closestMatch);
                    if (findLiteral.isPresent()) {
                        this.setSelection((ISelection)new StructuredSelection((Object)((EEnumLiteral)findLiteral.get()).getInstance()));
                    }
                } else {
                    this.setClosestMatch(this.getCCombo().getText());
                }
                combo.clearSelection();
            }
        };
        viewer.getCCombo().addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
                combo.clearSelection();
            }

            public void focusGained(FocusEvent e) {
            }
        });
        viewer.getCCombo().setEditable(true);
        viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        viewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return EnumLiteralFilteredComboViewerSWTRenderer.this.emfFormsEditSupport.getText(((VControl)EnumLiteralFilteredComboViewerSWTRenderer.this.getVElement()).getDomainModelReference(), EnumLiteralFilteredComboViewerSWTRenderer.this.getViewModelContext().getDomainModel(), element);
            }
        });
        ArrayList<Enumerator> inputValues = new ArrayList<Enumerator>();
        for (EEnumLiteral literal : eLiterals) {
            inputValues.add(literal.getInstance());
        }
        viewer.setInput(inputValues);
        viewer.setData("org.eclipse.rap.rwt.customVariant", "org_eclipse_emf_ecp_control_enum");
        combo.addListener(11, new Listener(){

            public void handleEvent(Event argEvent) {
                combo.setText(combo.getText());
            }
        });
        return viewer;
    }

    private static Optional<EEnumLiteral> findLiteral(List<EEnumLiteral> enumerators, String literal) {
        for (EEnumLiteral e : enumerators) {
            if (!e.getLiteral().equals(literal)) continue;
            return Optional.of((Object)e);
        }
        return Optional.empty();
    }
}

