/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.debugging;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.ease.AbstractScriptEngine;
import org.eclipse.ease.IDebugEngine;
import org.eclipse.ease.IExecutionListener;
import org.eclipse.ease.IScriptEngine;
import org.eclipse.ease.Script;
import org.eclipse.ease.debugging.DebugTracer;
import org.eclipse.ease.debugging.IScriptDebugFrame;
import org.eclipse.ease.debugging.ScriptStackTrace;
import org.eclipse.ease.debugging.dispatcher.EventDispatchJob;
import org.eclipse.ease.debugging.dispatcher.IEventProcessor;
import org.eclipse.ease.debugging.events.IDebugEvent;
import org.eclipse.ease.debugging.events.debugger.EngineStartedEvent;
import org.eclipse.ease.debugging.events.debugger.EngineTerminatedEvent;
import org.eclipse.ease.debugging.events.debugger.EvaluateExpressionEvent;
import org.eclipse.ease.debugging.events.debugger.IDebuggerEvent;
import org.eclipse.ease.debugging.events.debugger.ResumedEvent;
import org.eclipse.ease.debugging.events.debugger.ScriptReadyEvent;
import org.eclipse.ease.debugging.events.debugger.StackFramesEvent;
import org.eclipse.ease.debugging.events.debugger.SuspendedEvent;
import org.eclipse.ease.debugging.events.debugger.VariablesEvent;
import org.eclipse.ease.debugging.events.model.BreakpointRequest;
import org.eclipse.ease.debugging.events.model.EvaluateExpressionRequest;
import org.eclipse.ease.debugging.events.model.GetStackFramesRequest;
import org.eclipse.ease.debugging.events.model.GetVariablesRequest;
import org.eclipse.ease.debugging.events.model.ResumeRequest;
import org.eclipse.ease.debugging.events.model.SetVariablesRequest;
import org.eclipse.ease.debugging.events.model.TerminateRequest;
import org.eclipse.ease.debugging.model.EaseDebugStackFrame;
import org.eclipse.ease.debugging.model.EaseDebugVariable;

public abstract class AbstractEaseDebugger
implements IEventProcessor,
IExecutionListener {
    private EventDispatchJob fDispatcher;
    private IDebugEngine fEngine;
    private boolean fSuspended = false;
    private final Map<Script, List<IBreakpoint>> fBreakpoints = new HashMap<Script, List<IBreakpoint>>();
    private final boolean fShowDynamicCode;
    private int fResumeType;
    private ScriptStackTrace fStacktrace = new ScriptStackTrace();
    private ScriptStackTrace fExceptionStacktrace = null;
    private int fResumeStackSize = 0;
    private boolean fTerminated = false;
    private int fResumeLineNumber = 0;

    public AbstractEaseDebugger(IDebugEngine engine, boolean showDynamicCode) {
        this.fEngine = engine;
        this.fShowDynamicCode = showDynamicCode;
        this.fEngine.addExecutionListener(this);
    }

    @Override
    public void setDispatcher(EventDispatchJob dispatcher) {
        this.fDispatcher = dispatcher;
    }

    protected void fireDispatchEvent(IDebuggerEvent event) {
        if (this.fDispatcher != null) {
            this.fDispatcher.addEvent(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void suspend(IDebuggerEvent event) {
        if (this.fDispatcher != null) {
            IDebugEngine iDebugEngine = this.fEngine;
            synchronized (iDebugEngine) {
                this.fSuspended = true;
                this.fireDispatchEvent(event);
                DebugTracer.debug("Debugger", "\t engine suspended");
                try {
                    while (this.fSuspended) {
                        this.fEngine.wait();
                    }
                }
                catch (InterruptedException e) {
                    this.fSuspended = false;
                }
                DebugTracer.debug("Debugger", "\t engine resumed");
                this.fireDispatchEvent(new ResumedEvent(Thread.currentThread(), this.getResumeType()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void resume(int resumeType) {
        if (resumeType != 0) {
            this.fResumeType = resumeType;
            this.fResumeStackSize = this.getStacktrace().size();
            this.fResumeLineNumber = this.fResumeStackSize > 0 ? ((IScriptDebugFrame)this.getStacktrace().get(0)).getLineNumber() : 0;
        }
        IDebugEngine iDebugEngine = this.fEngine;
        synchronized (iDebugEngine) {
            this.fSuspended = false;
            this.fEngine.notifyAll();
        }
    }

    protected IDebugEngine getEngine() {
        return this.fEngine;
    }

    @Override
    public void notify(IScriptEngine engine, Script script, int status) {
        switch (status) {
            case 1: {
                this.fireDispatchEvent(new EngineStartedEvent());
                break;
            }
            case 2: {
                this.fireDispatchEvent(new EngineTerminatedEvent());
                this.fTerminated = true;
                this.fEngine.removeExecutionListener(this);
                this.fEngine = null;
                this.fDispatcher = null;
                this.fStacktrace.clear();
                this.fExceptionStacktrace = null;
                this.fBreakpoints.clear();
                break;
            }
            case 3: 
            case 5: {
                if (!this.isTrackedScript(script)) break;
                this.suspend(new ScriptReadyEvent(script, Thread.currentThread(), this.fStacktrace.isEmpty()));
                break;
            }
            case 4: 
            case 6: {
                break;
            }
        }
    }

    @Override
    public void handleEvent(IDebugEvent event) {
        if (!this.fTerminated) {
            DebugTracer.debug("Debugger", "process " + event);
            if (event instanceof ResumeRequest) {
                this.resume(((ResumeRequest)event).getType());
            } else if (event instanceof BreakpointRequest) {
                if (((BreakpointRequest)event).isRemoveAllBreakpointsRequest()) {
                    this.fBreakpoints.clear();
                } else {
                    Script script = ((BreakpointRequest)event).getScript();
                    if (!this.fBreakpoints.containsKey(script)) {
                        this.fBreakpoints.put(script, new ArrayList());
                    }
                    if (((BreakpointRequest)event).getMode() == BreakpointRequest.Mode.ADD) {
                        this.fBreakpoints.get(script).add(((BreakpointRequest)event).getBreakpoint());
                    } else {
                        this.fBreakpoints.get(script).remove(((BreakpointRequest)event).getBreakpoint());
                    }
                }
            } else if (event instanceof GetStackFramesRequest) {
                this.fireDispatchEvent(new StackFramesEvent(this.getStacktrace(), ((AbstractScriptEngine)((Object)this.getEngine())).getThread()));
            } else if (event instanceof GetVariablesRequest) {
                EaseDebugStackFrame requestor = ((GetVariablesRequest)event).getRequestor();
                Collection<EaseDebugVariable> variables = this.getEngine().getVariables(requestor.getDebugFrame());
                this.fireDispatchEvent(new VariablesEvent(requestor, variables));
            } else if (event instanceof EvaluateExpressionRequest) {
                IDebugElement scope = ((EvaluateExpressionRequest)event).getContext();
                if (scope instanceof EaseDebugStackFrame) {
                    try {
                        Object result = ((EaseDebugStackFrame)scope).getDebugFrame().inject(((EvaluateExpressionRequest)event).getExpression());
                        this.fireDispatchEvent(new EvaluateExpressionEvent(((EvaluateExpressionRequest)event).getExpression(), result, null, ((EvaluateExpressionRequest)event).getListener()));
                    }
                    catch (Throwable e) {
                        this.fireDispatchEvent(new EvaluateExpressionEvent(((EvaluateExpressionRequest)event).getExpression(), null, e, ((EvaluateExpressionRequest)event).getListener()));
                    }
                }
            } else if (event instanceof SetVariablesRequest) {
                IDebugElement requestor = ((SetVariablesRequest)event).getRequestor();
                try {
                    if (requestor instanceof EaseDebugStackFrame) {
                        Object result = this.getEngine().inject(((SetVariablesRequest)event).getExpression());
                        ((EaseDebugStackFrame)requestor).getDebugFrame().setVariable(((SetVariablesRequest)event).getVariable().getName(), result);
                        Collection<EaseDebugVariable> variables = this.getEngine().getVariables(((EaseDebugStackFrame)requestor).getDebugFrame());
                        this.fireDispatchEvent(new VariablesEvent((EaseDebugStackFrame)requestor, variables));
                    }
                }
                catch (Throwable e) {
                    e.printStackTrace(System.out);
                }
            } else if (event instanceof TerminateRequest) {
                this.fBreakpoints.clear();
                this.getEngine().terminate();
                this.fireDispatchEvent(new EngineTerminatedEvent());
                this.setDispatcher(null);
            }
        }
    }

    protected IBreakpoint getBreakpoint(Script script, int lineNumber) {
        List<IBreakpoint> breakpoints = this.fBreakpoints.get(script);
        if (breakpoints != null) {
            for (IBreakpoint breakpoint : breakpoints) {
                try {
                    int breakLocation;
                    if (!breakpoint.isEnabled() || lineNumber != (breakLocation = breakpoint.getMarker().getAttribute("lineNumber", -1))) continue;
                    return breakpoint;
                }
                catch (CoreException coreException) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    protected boolean isTrackedScript(Script script) {
        return !script.isDynamic() || this.fShowDynamicCode;
    }

    protected int getResumeType() {
        return this.fResumeType;
    }

    public ScriptStackTrace getStacktrace() {
        return this.fStacktrace;
    }

    protected void setStacktrace(ScriptStackTrace stacktrace) {
        this.fStacktrace = stacktrace;
    }

    public ScriptStackTrace getExceptionStacktrace() {
        return this.fExceptionStacktrace;
    }

    protected void setExceptionStacktrace(ScriptStackTrace exceptionStacktrace) {
        this.fExceptionStacktrace = exceptionStacktrace;
    }

    protected void processLine(Script script, int lineNumber) {
        if (!this.isTrackedScript(script)) {
            return;
        }
        if (lineNumber < 1) {
            return;
        }
        if (this.getStacktrace().isEmpty()) {
            return;
        }
        DebugTracer.debug("Debugger", "\t... processing line " + script.getTitle() + ":" + lineNumber);
        IBreakpoint breakpoint = this.getBreakpoint(script, lineNumber);
        if (breakpoint != null) {
            this.suspend(new SuspendedEvent(16, ((AbstractScriptEngine)((Object)this.fEngine)).getThread(), this.getStacktrace()));
            return;
        }
        switch (this.getResumeType()) {
            case 1: {
                this.suspend(new SuspendedEvent(8, ((AbstractScriptEngine)((Object)this.fEngine)).getThread(), this.getStacktrace()));
                break;
            }
            case 2: {
                if (this.fResumeStackSize > this.getStacktrace().size()) {
                    if (this.getStacktrace().isEmpty()) break;
                    this.suspend(new SuspendedEvent(8, ((AbstractScriptEngine)((Object)this.fEngine)).getThread(), this.getStacktrace()));
                    break;
                }
                if (this.fResumeStackSize != this.getStacktrace().size() || this.fResumeLineNumber == ((IScriptDebugFrame)this.getStacktrace().get(0)).getLineNumber()) break;
                this.suspend(new SuspendedEvent(8, ((AbstractScriptEngine)((Object)this.fEngine)).getThread(), this.getStacktrace()));
                break;
            }
            case 4: {
                if (this.fResumeStackSize <= this.getStacktrace().size()) break;
                this.suspend(new SuspendedEvent(8, ((AbstractScriptEngine)((Object)this.fEngine)).getThread(), this.getStacktrace()));
            }
        }
    }
}

