/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.tools.emf.ui.common;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.core.databinding.observable.value.ValueChangeEvent;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.e4.tools.emf.ui.common.IEditorFeature;
import org.eclipse.e4.ui.model.application.MApplicationElement;
import org.eclipse.e4.ui.model.application.impl.ApplicationPackageImpl;
import org.eclipse.e4.ui.model.application.ui.MElementContainer;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.impl.UiPackageImpl;
import org.eclipse.e4.ui.model.fragment.impl.FragmentPackageImpl;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.command.MoveCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.swt.widgets.Control;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Util {
    public static final boolean isNullOrEmpty(String element) {
        return element == null || element.trim().length() == 0;
    }

    public static final boolean isImport(EObject object) {
        return object.eContainingFeature() == FragmentPackageImpl.Literals.MODEL_FRAGMENTS__IMPORTS;
    }

    public static final void addClasses(EPackage ePackage, List<IEditorFeature.FeatureClass> list) {
        for (EClassifier c : ePackage.getEClassifiers()) {
            EClass eclass;
            if (!(c instanceof EClass) || (eclass = (EClass)c) == ApplicationPackageImpl.Literals.APPLICATION || eclass.isAbstract() || eclass.isInterface() || !eclass.getEAllSuperTypes().contains((Object)ApplicationPackageImpl.Literals.APPLICATION_ELEMENT)) continue;
            list.add(new IEditorFeature.FeatureClass(eclass.getName(), eclass));
        }
        for (EPackage eSubPackage : ePackage.getESubpackages()) {
            Util.addClasses(eSubPackage, list);
        }
    }

    public static final String getDefaultElementId(Resource resource, MApplicationElement element, IProject project) {
        try {
            EObject o = (EObject)element;
            String className = o.eClass().getName();
            String projectName = project.getName();
            String prefix = (String.valueOf(projectName) + "." + className).toLowerCase();
            TreeIterator it = resource.getAllContents();
            TreeSet<Integer> numbers = new TreeSet<Integer>();
            while (it.hasNext()) {
                String suffix;
                String elementId;
                EObject tmp = (EObject)it.next();
                if (!(tmp instanceof MApplicationElement) || (elementId = ((MApplicationElement)tmp).getElementId()) == null || elementId.length() <= prefix.length() || !elementId.startsWith(prefix) || !(suffix = elementId.substring(prefix.length())).startsWith(".") || suffix.length() <= 1) continue;
                try {
                    numbers.add(Integer.parseInt(suffix.substring(1)));
                }
                catch (Exception exception) {}
            }
            int lastNumber = -1;
            for (Integer number : numbers) {
                if (lastNumber + 1 != number) break;
                lastNumber = number;
            }
            return (String.valueOf(prefix) + "." + ++lastNumber).toLowerCase();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static List<InternalPackage> loadPackages() {
        ArrayList<InternalPackage> packs = new ArrayList<InternalPackage>();
        for (Map.Entry regEntry : EPackage.Registry.INSTANCE.entrySet()) {
            if (!(regEntry.getValue() instanceof EPackage)) continue;
            EPackage ePackage = (EPackage)regEntry.getValue();
            InternalPackage iePackage = new InternalPackage(ePackage);
            boolean found = false;
            for (EClassifier cl : ePackage.getEClassifiers()) {
                EClass eClass;
                if (!(cl instanceof EClass) || !(eClass = (EClass)cl).getEAllSuperTypes().contains((Object)ApplicationPackageImpl.Literals.APPLICATION_ELEMENT) || eClass.isInterface() || eClass.isAbstract()) continue;
                found = true;
                InternalClass ieClass = new InternalClass(iePackage, eClass);
                iePackage.classes.add(ieClass);
                for (EReference f : eClass.getEAllReferences()) {
                    ieClass.features.add(new InternalFeature(ieClass, (EStructuralFeature)f));
                }
            }
            if (!found) continue;
            packs.add(iePackage);
        }
        return packs;
    }

    public static boolean moveElementByIndex(EditingDomain editingDomain, MUIElement element, boolean liveModel, int index, EStructuralFeature feature) {
        if (liveModel) {
            EObject container = ((EObject)element).eContainer();
            List l = (List)container.eGet(feature);
            l.remove(element);
            if (index >= 0) {
                l.add(index, element);
            } else {
                l.add(element);
            }
            return true;
        }
        EObject container = ((EObject)element).eContainer();
        Command cmd = MoveCommand.create((EditingDomain)editingDomain, (Object)container, (Object)feature, (Object)element, (int)index);
        if (cmd.canExecute()) {
            editingDomain.getCommandStack().execute(cmd);
            return true;
        }
        return false;
    }

    public static boolean moveElementByIndex(EditingDomain editingDomain, MUIElement element, boolean liveModel, int index) {
        if (liveModel) {
            MElementContainer container = element.getParent();
            container.getChildren().remove(element);
            if (index >= 0) {
                container.getChildren().add(index, element);
            } else {
                container.getChildren().add(element);
            }
            container.setSelectedElement(element);
            return true;
        }
        MElementContainer container = element.getParent();
        Command cmd = MoveCommand.create((EditingDomain)editingDomain, (Object)container, (Object)UiPackageImpl.Literals.ELEMENT_CONTAINER__CHILDREN, (Object)element, (int)index);
        if (cmd.canExecute()) {
            editingDomain.getCommandStack().execute(cmd);
            return true;
        }
        return false;
    }

    public static final void addDecoration(Control control, Binding binding) {
        final ControlDecoration dec = new ControlDecoration(control, 1024);
        binding.getValidationStatus().addValueChangeListener(new IValueChangeListener(){

            public void handleValueChange(ValueChangeEvent event) {
                IStatus s = (IStatus)event.getObservableValue().getValue();
                if (s.isOK()) {
                    dec.setDescriptionText(null);
                    dec.setImage(null);
                } else {
                    dec.setDescriptionText(s.getMessage());
                    String fieldDecorationID = null;
                    switch (s.getSeverity()) {
                        case 1: {
                            fieldDecorationID = "DEC_INFORMATION";
                            break;
                        }
                        case 2: {
                            fieldDecorationID = "DEC_WARNING";
                            break;
                        }
                        case 4: 
                        case 8: {
                            fieldDecorationID = "DEC_ERROR";
                        }
                    }
                    FieldDecoration fieldDecoration = FieldDecorationRegistry.getDefault().getFieldDecoration(fieldDecorationID);
                    dec.setImage(fieldDecoration == null ? null : fieldDecoration.getImage());
                }
            }
        });
    }

    public static class InternalClass {
        public final InternalPackage pack;
        public final EClass eClass;
        public List<InternalFeature> features = new ArrayList<InternalFeature>();

        public InternalClass(InternalPackage pack, EClass eClass) {
            this.eClass = eClass;
            this.pack = pack;
        }
    }

    public static class InternalFeature {
        public final InternalClass clazz;
        public final EStructuralFeature feature;

        public InternalFeature(InternalClass clazz, EStructuralFeature feature) {
            this.clazz = clazz;
            this.feature = feature;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class InternalPackage {
        public final EPackage ePackage;
        public List<InternalClass> classes = new ArrayList<InternalClass>();

        public InternalPackage(EPackage ePackage) {
            this.ePackage = ePackage;
        }

        public String toString() {
            return this.ePackage.toString();
        }

        public List<EClass> getAllClasses() {
            ArrayList<EClass> rv = new ArrayList<EClass>(this.classes.size());
            for (InternalClass c : this.classes) {
                rv.add(c.eClass);
            }
            return rv;
        }
    }
}

