/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.tools.css.spy;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.e4.tools.css.spy.CssSpyDialog;
import org.eclipse.e4.ui.css.core.dom.CSSStylableElement;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolItem;
import org.w3c.dom.NodeList;

public class WidgetTreeProvider
implements ITreeContentProvider {
    private static final Object[] EMPTY_ARRAY = new Object[0];

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public Object[] getElements(Object inputElement) {
        if (inputElement instanceof Object[]) {
            return (Object[])inputElement;
        }
        if (inputElement instanceof Collection) {
            return ((Collection)inputElement).toArray();
        }
        return this.getChildren(inputElement);
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof Display) {
            ArrayList<Shell> shells = new ArrayList<Shell>();
            Shell[] shellArray = ((Display)parentElement).getShells();
            int n = shellArray.length;
            int n2 = 0;
            while (n2 < n) {
                Shell s = shellArray[n2];
                if (!s.isDisposed()) {
                    shells.add(s);
                }
                ++n2;
            }
            return shells.toArray();
        }
        CSSStylableElement element = CssSpyDialog.getCSSElement(parentElement);
        if (element == null) {
            return EMPTY_ARRAY;
        }
        NodeList kids = element.getChildNodes();
        ArrayList<Object> children = new ArrayList<Object>(kids.getLength());
        int i = 0;
        while (i < kids.getLength()) {
            children.add(((CSSStylableElement)kids.item(i)).getNativeWidget());
            ++i;
        }
        return children.toArray();
    }

    public Object getParent(Object element) {
        if (element instanceof Control) {
            Control control = (Control)element;
            return control.isDisposed() ? null : control.getParent();
        }
        if (element instanceof CTabItem) {
            return ((CTabItem)element).getParent();
        }
        if (element instanceof ToolItem) {
            return ((ToolItem)element).getParent();
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        return this.getChildren(element).length > 0;
    }

    public void dispose() {
    }
}

