/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.databinding;

import java.util.Collections;
import java.util.List;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.UpdateListStrategy;
import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.ObservableTracker;
import org.eclipse.core.databinding.observable.list.IListChangeListener;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.ListChangeEvent;
import org.eclipse.core.databinding.observable.list.ListDiff;
import org.eclipse.core.databinding.observable.list.ListDiffVisitor;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.core.internal.databinding.BindingStatus;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListBinding<M, T>
extends Binding<IObservableList<M>, IObservableList<T>> {
    private UpdateListStrategy<T, M> targetToModel;
    private UpdateListStrategy<M, T> modelToTarget;
    private IObservableValue<IStatus> validationStatusObservable;
    private boolean updatingTarget;
    private boolean updatingModel;
    private IListChangeListener<T> targetChangeListener = new IListChangeListener<T>(){

        public void handleListChange(ListChangeEvent<T> event) {
            if (!ListBinding.this.updatingTarget) {
                ListBinding.this.doUpdate((IObservableList)ListBinding.this.getTarget(), (IObservableList)ListBinding.this.getModel(), event.diff, ListBinding.this.targetToModel, false, false);
            }
        }
    };
    private IListChangeListener<M> modelChangeListener = new IListChangeListener<M>(){

        public void handleListChange(ListChangeEvent<M> event) {
            if (!ListBinding.this.updatingModel) {
                ListBinding.this.doUpdate((IObservableList)ListBinding.this.getModel(), (IObservableList)ListBinding.this.getTarget(), event.diff, ListBinding.this.modelToTarget, false, false);
            }
        }
    };

    public ListBinding(IObservableList<T> target, IObservableList<M> model, UpdateListStrategy<T, M> targetToModelStrategy, UpdateListStrategy<M, T> modelToTargetStrategy) {
        super(target, model);
        this.targetToModel = targetToModelStrategy;
        this.modelToTarget = modelToTargetStrategy;
        if ((this.targetToModel.getUpdatePolicy() & UpdateListStrategy.POLICY_UPDATE) != 0) {
            target.addListChangeListener(this.targetChangeListener);
        } else {
            this.targetChangeListener = null;
        }
        if ((this.modelToTarget.getUpdatePolicy() & UpdateListStrategy.POLICY_UPDATE) != 0) {
            model.addListChangeListener(this.modelChangeListener);
        } else {
            this.modelChangeListener = null;
        }
    }

    @Override
    public IObservableValue<IStatus> getValidationStatus() {
        return this.validationStatusObservable;
    }

    @Override
    protected void preInit() {
        ObservableTracker.setIgnore((boolean)true);
        try {
            this.validationStatusObservable = new WritableValue(this.context.getValidationRealm(), (Object)Status.OK_STATUS, IStatus.class);
        }
        finally {
            ObservableTracker.setIgnore((boolean)false);
        }
    }

    @Override
    protected void postInit() {
        if (this.modelToTarget.getUpdatePolicy() == UpdateListStrategy.POLICY_UPDATE) {
            this.updateModelToTarget();
        }
        if (this.targetToModel.getUpdatePolicy() == UpdateListStrategy.POLICY_UPDATE) {
            this.validateTargetToModel();
        }
    }

    @Override
    public void updateModelToTarget() {
        final IObservableList modelList = (IObservableList)this.getModel();
        modelList.getRealm().exec(new Runnable(){

            public void run() {
                ListDiff diff = Diffs.computeListDiff(Collections.emptyList(), (List)modelList);
                ListBinding.this.doUpdate(modelList, (IObservableList)ListBinding.this.getTarget(), diff, ListBinding.this.modelToTarget, true, true);
            }
        });
    }

    @Override
    public void updateTargetToModel() {
        final IObservableList targetList = (IObservableList)this.getTarget();
        targetList.getRealm().exec(new Runnable(){

            public void run() {
                ListDiff diff = Diffs.computeListDiff(Collections.emptyList(), (List)targetList);
                ListBinding.this.doUpdate(targetList, (IObservableList)ListBinding.this.getModel(), diff, ListBinding.this.targetToModel, true, true);
            }
        });
    }

    @Override
    public void validateModelToTarget() {
    }

    @Override
    public void validateTargetToModel() {
    }

    private <S, D> void doUpdate(IObservableList<S> source, final IObservableList<D> destination, final ListDiff<S> diff, final UpdateListStrategy<S, D> updateListStrategy, boolean explicit, final boolean clearDestination) {
        int policy = updateListStrategy.getUpdatePolicy();
        if (policy != UpdateListStrategy.POLICY_NEVER && (policy != UpdateListStrategy.POLICY_ON_REQUEST || explicit)) {
            destination.getRealm().exec(new Runnable(){

                public void run() {
                    if (destination == ListBinding.this.getTarget()) {
                        ListBinding.this.updatingTarget = true;
                    } else {
                        ListBinding.this.updatingModel = true;
                    }
                    final BindingStatus multiStatus = BindingStatus.ok();
                    try {
                        if (clearDestination) {
                            destination.clear();
                        }
                        diff.accept(new ListDiffVisitor<S>(){
                            boolean useMoveAndReplace;
                            {
                                this.useMoveAndReplace = updateListStrategy2.useMoveAndReplace();
                            }

                            public void handleAdd(int index, S element) {
                                IStatus setterStatus = updateListStrategy.doAdd(destination, updateListStrategy.convert(element), index);
                                ListBinding.this.mergeStatus(multiStatus, setterStatus);
                            }

                            public void handleRemove(int index, S element) {
                                IStatus setterStatus = updateListStrategy.doRemove(destination, index);
                                ListBinding.this.mergeStatus(multiStatus, setterStatus);
                            }

                            public void handleMove(int oldIndex, int newIndex, S element) {
                                if (this.useMoveAndReplace) {
                                    IStatus setterStatus = updateListStrategy.doMove(destination, oldIndex, newIndex);
                                    ListBinding.this.mergeStatus(multiStatus, setterStatus);
                                } else {
                                    super.handleMove(oldIndex, newIndex, element);
                                }
                            }

                            public void handleReplace(int index, S oldElement, S newElement) {
                                if (this.useMoveAndReplace) {
                                    IStatus setterStatus = updateListStrategy.doReplace(destination, index, updateListStrategy.convert(newElement));
                                    ListBinding.this.mergeStatus(multiStatus, setterStatus);
                                } else {
                                    super.handleReplace(index, oldElement, newElement);
                                }
                            }
                        });
                    }
                    finally {
                        ListBinding.this.validationStatusObservable.setValue((Object)multiStatus);
                        if (destination == ListBinding.this.getTarget()) {
                            ListBinding.this.updatingTarget = false;
                        } else {
                            ListBinding.this.updatingModel = false;
                        }
                    }
                }
            });
        }
    }

    void mergeStatus(MultiStatus multiStatus, IStatus newStatus) {
        if (!newStatus.isOK()) {
            multiStatus.add(newStatus);
        }
    }

    @Override
    public void dispose() {
        if (this.targetChangeListener != null) {
            ((IObservableList)this.getTarget()).removeListChangeListener(this.targetChangeListener);
            this.targetChangeListener = null;
        }
        if (this.modelChangeListener != null) {
            ((IObservableList)this.getModel()).removeListChangeListener(this.modelChangeListener);
            this.modelChangeListener = null;
        }
        super.dispose();
    }
}

