/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.databinding.observable.list;

import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.core.databinding.observable.DecoratingObservableCollection;
import org.eclipse.core.databinding.observable.list.IListChangeListener;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.ListChangeEvent;
import org.eclipse.core.databinding.observable.list.ListDiff;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DecoratingObservableList<E>
extends DecoratingObservableCollection<E>
implements IObservableList<E> {
    private IObservableList<E> decorated;
    private IListChangeListener<E> listChangeListener;

    public DecoratingObservableList(IObservableList<E> decorated, boolean disposeDecoratedOnDispose) {
        super(decorated, disposeDecoratedOnDispose);
        this.decorated = decorated;
    }

    @Override
    public synchronized void addListChangeListener(IListChangeListener<? super E> listener) {
        this.addListener(ListChangeEvent.TYPE, listener);
    }

    @Override
    public synchronized void removeListChangeListener(IListChangeListener<? super E> listener) {
        this.removeListener(ListChangeEvent.TYPE, listener);
    }

    protected void fireListChange(ListDiff<E> diff) {
        super.fireChange();
        this.fireEvent(new ListChangeEvent<E>(this, diff));
    }

    @Override
    protected void fireChange() {
        throw new RuntimeException("fireChange should not be called, use fireListChange() instead");
    }

    @Override
    protected void firstListenerAdded() {
        if (this.listChangeListener == null) {
            this.listChangeListener = new IListChangeListener<E>(){

                @Override
                public void handleListChange(ListChangeEvent<E> event) {
                    DecoratingObservableList.this.handleListChange(event);
                }
            };
        }
        this.decorated.addListChangeListener(this.listChangeListener);
        super.firstListenerAdded();
    }

    @Override
    protected void lastListenerRemoved() {
        super.lastListenerRemoved();
        if (this.listChangeListener != null) {
            this.decorated.removeListChangeListener(this.listChangeListener);
            this.listChangeListener = null;
        }
    }

    protected void handleListChange(ListChangeEvent<E> event) {
        this.fireListChange(event.diff);
    }

    @Override
    public void add(int index, E o) {
        this.checkRealm();
        this.decorated.add(index, o);
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        this.checkRealm();
        return this.decorated.addAll(index, c);
    }

    @Override
    public E get(int index) {
        this.getterCalled();
        return this.decorated.get(index);
    }

    @Override
    public int indexOf(Object o) {
        this.getterCalled();
        return this.decorated.indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        this.getterCalled();
        return this.decorated.lastIndexOf(o);
    }

    @Override
    public ListIterator<E> listIterator() {
        return this.listIterator(0);
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        this.getterCalled();
        final ListIterator<E> iterator = this.decorated.listIterator(index);
        return new ListIterator<E>(){

            @Override
            public void add(E o) {
                iterator.add(o);
            }

            @Override
            public boolean hasNext() {
                DecoratingObservableList.this.getterCalled();
                return iterator.hasNext();
            }

            @Override
            public boolean hasPrevious() {
                DecoratingObservableList.this.getterCalled();
                return iterator.hasPrevious();
            }

            @Override
            public E next() {
                DecoratingObservableList.this.getterCalled();
                return iterator.next();
            }

            @Override
            public int nextIndex() {
                DecoratingObservableList.this.getterCalled();
                return iterator.nextIndex();
            }

            @Override
            public E previous() {
                DecoratingObservableList.this.getterCalled();
                return iterator.previous();
            }

            @Override
            public int previousIndex() {
                DecoratingObservableList.this.getterCalled();
                return iterator.previousIndex();
            }

            @Override
            public void remove() {
                DecoratingObservableList.this.checkRealm();
                iterator.remove();
            }

            @Override
            public void set(E o) {
                DecoratingObservableList.this.checkRealm();
                iterator.set(o);
            }
        };
    }

    @Override
    public E move(int oldIndex, int newIndex) {
        this.checkRealm();
        return this.decorated.move(oldIndex, newIndex);
    }

    @Override
    public E remove(int index) {
        this.checkRealm();
        return this.decorated.remove(index);
    }

    @Override
    public E set(int index, E element) {
        this.checkRealm();
        return this.decorated.set(index, element);
    }

    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        this.getterCalled();
        return this.decorated.subList(fromIndex, toIndex);
    }

    @Override
    public synchronized void dispose() {
        if (this.decorated != null && this.listChangeListener != null) {
            this.decorated.removeListChangeListener(this.listChangeListener);
        }
        this.decorated = null;
        this.listChangeListener = null;
        super.dispose();
    }
}

