/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.code;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.SourceRange;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.AnnotationTypeDeclaration;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ConstructorInvocation;
import org.eclipse.jdt.core.dom.EnumDeclaration;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.Initializer;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.SuperMethodInvocation;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.refactoring.CollectingSearchRequestor;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringScopeFactory;
import org.eclipse.jdt.internal.corext.refactoring.base.JavaStatusContext;
import org.eclipse.jdt.internal.corext.refactoring.base.ReferencesInBinaryContext;
import org.eclipse.jdt.internal.corext.refactoring.code.Invocations;
import org.eclipse.jdt.internal.corext.refactoring.util.RefactoringASTParser;
import org.eclipse.jdt.internal.corext.util.SearchUtils;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;

abstract class TargetProvider {
    TargetProvider() {
    }

    public abstract void initialize();

    public abstract ICompilationUnit[] getAffectedCompilationUnits(RefactoringStatus var1, ReferencesInBinaryContext var2, IProgressMonitor var3) throws CoreException;

    public abstract BodyDeclaration[] getAffectedBodyDeclarations(ICompilationUnit var1, IProgressMonitor var2);

    public abstract ASTNode[] getInvocations(BodyDeclaration var1, IProgressMonitor var2);

    public abstract RefactoringStatus checkActivation() throws JavaModelException;

    public abstract int getStatusSeverity();

    public boolean isSingle() {
        return false;
    }

    public static TargetProvider create(ICompilationUnit cu, MethodInvocation invocation) {
        return new SingleCallTargetProvider(cu, (ASTNode)invocation);
    }

    public static TargetProvider create(ICompilationUnit cu, SuperMethodInvocation invocation) {
        return new SingleCallTargetProvider(cu, (ASTNode)invocation);
    }

    public static TargetProvider create(ICompilationUnit cu, ConstructorInvocation invocation) {
        return new SingleCallTargetProvider(cu, (ASTNode)invocation);
    }

    public static TargetProvider create(MethodDeclaration declaration) {
        IMethodBinding method = declaration.resolveBinding();
        if (method == null) {
            return new ErrorTargetProvider(RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.TargetProvider_method_declaration_not_unique));
        }
        ITypeBinding type = method.getDeclaringClass();
        if (type.isLocal()) {
            if (((IType)type.getJavaElement()).isBinary()) {
                return new ErrorTargetProvider(RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.TargetProvider_cannot_local_method_in_binary));
            }
            IType declaringClassOfLocal = (IType)type.getDeclaringClass().getJavaElement();
            return new LocalTypeTargetProvider(declaringClassOfLocal.getCompilationUnit(), declaration);
        }
        return new MemberTypeTargetProvider(declaration.resolveBinding());
    }

    public static TargetProvider create(IMethodBinding methodBinding) {
        return new MemberTypeTargetProvider(methodBinding);
    }

    static void fastDone(IProgressMonitor pm) {
        if (pm == null) {
            return;
        }
        pm.beginTask("", 1);
        pm.worked(1);
        pm.done();
    }

    private static class BodyData {
        private List<ASTNode> fInvocations;

        public void addInvocation(ASTNode node) {
            if (this.fInvocations == null) {
                this.fInvocations = new ArrayList<ASTNode>(2);
            }
            this.fInvocations.add(node);
        }

        public ASTNode[] getInvocations() {
            return this.fInvocations.toArray(new ASTNode[this.fInvocations.size()]);
        }

        public boolean hasInvocations() {
            return this.fInvocations != null && !this.fInvocations.isEmpty();
        }
    }

    static class ErrorTargetProvider
    extends TargetProvider {
        private RefactoringStatus fErrorStatus;

        public ErrorTargetProvider(RefactoringStatus status) {
            this.fErrorStatus = status;
        }

        public RefactoringStatus checkActivation() throws JavaModelException {
            return this.fErrorStatus;
        }

        public void initialize() {
        }

        public ICompilationUnit[] getAffectedCompilationUnits(RefactoringStatus status, ReferencesInBinaryContext binaryRefs, IProgressMonitor pm) throws JavaModelException {
            return null;
        }

        public BodyDeclaration[] getAffectedBodyDeclarations(ICompilationUnit unit, IProgressMonitor pm) {
            return null;
        }

        public ASTNode[] getInvocations(BodyDeclaration declaration, IProgressMonitor pm) {
            return null;
        }

        public int getStatusSeverity() {
            return 0;
        }
    }

    private static class InvocationFinder
    extends ASTVisitor {
        Map<BodyDeclaration, BodyData> result = new HashMap<BodyDeclaration, BodyData>(2);
        Stack<BodyData> fBodies = new Stack();
        BodyData fCurrent;
        private IMethodBinding fBinding;

        public InvocationFinder(IMethodBinding binding) {
            Assert.isNotNull((Object)binding);
            this.fBinding = binding.getMethodDeclaration();
            Assert.isNotNull((Object)this.fBinding);
        }

        public boolean visit(MethodInvocation node) {
            if (node.resolveTypeBinding() != null && this.matches((IBinding)node.resolveMethodBinding()) && this.fCurrent != null) {
                this.fCurrent.addInvocation((ASTNode)node);
            }
            return true;
        }

        public boolean visit(SuperMethodInvocation node) {
            if (this.matches(node.getName().resolveBinding()) && this.fCurrent != null) {
                this.fCurrent.addInvocation((ASTNode)node);
            }
            return true;
        }

        public boolean visit(ConstructorInvocation node) {
            if (this.matches((IBinding)node.resolveConstructorBinding()) && this.fCurrent != null) {
                this.fCurrent.addInvocation((ASTNode)node);
            }
            return true;
        }

        public boolean visit(ClassInstanceCreation node) {
            if (this.matches((IBinding)node.resolveConstructorBinding()) && this.fCurrent != null) {
                this.fCurrent.addInvocation((ASTNode)node);
            }
            return true;
        }

        public boolean visit(TypeDeclaration node) {
            return this.visitType();
        }

        public void endVisit(TypeDeclaration node) {
            this.endVisitBodyDeclaration();
        }

        public boolean visit(EnumDeclaration node) {
            return this.visitType();
        }

        public void endVisit(EnumDeclaration node) {
            this.endVisitBodyDeclaration();
        }

        public boolean visit(AnnotationTypeDeclaration node) {
            return this.visitType();
        }

        public void endVisit(AnnotationTypeDeclaration node) {
            this.endVisitBodyDeclaration();
        }

        private boolean visitType() {
            this.fBodies.add(this.fCurrent);
            this.fCurrent = null;
            return true;
        }

        protected boolean visitNonTypeBodyDeclaration() {
            this.fBodies.add(this.fCurrent);
            this.fCurrent = new BodyData();
            return true;
        }

        protected void endVisitBodyDeclaration() {
            this.fCurrent = (BodyData)this.fBodies.remove(this.fBodies.size() - 1);
        }

        public boolean visit(FieldDeclaration node) {
            return this.visitNonTypeBodyDeclaration();
        }

        public void endVisit(FieldDeclaration node) {
            if (this.fCurrent.hasInvocations()) {
                this.result.put((BodyDeclaration)node, this.fCurrent);
            }
            this.endVisitBodyDeclaration();
        }

        public boolean visit(MethodDeclaration node) {
            return this.visitNonTypeBodyDeclaration();
        }

        public void endVisit(MethodDeclaration node) {
            if (this.fCurrent.hasInvocations()) {
                this.result.put((BodyDeclaration)node, this.fCurrent);
            }
            this.endVisitBodyDeclaration();
        }

        public boolean visit(Initializer node) {
            return this.visitNonTypeBodyDeclaration();
        }

        public void endVisit(Initializer node) {
            if (this.fCurrent.hasInvocations()) {
                this.result.put((BodyDeclaration)node, this.fCurrent);
            }
            this.endVisitBodyDeclaration();
        }

        private boolean matches(IBinding binding) {
            if (!(binding instanceof IMethodBinding)) {
                return false;
            }
            return this.fBinding.isEqualTo((IBinding)((IMethodBinding)binding).getMethodDeclaration());
        }
    }

    private static class LocalTypeTargetProvider
    extends TargetProvider {
        private ICompilationUnit fCUnit;
        private MethodDeclaration fDeclaration;
        private Map<BodyDeclaration, BodyData> fBodies;

        public LocalTypeTargetProvider(ICompilationUnit unit, MethodDeclaration declaration) {
            Assert.isNotNull((Object)unit);
            Assert.isNotNull((Object)declaration);
            this.fCUnit = unit;
            this.fDeclaration = declaration;
        }

        public void initialize() {
            InvocationFinder finder;
            IMethodBinding methodBinding = this.fDeclaration.resolveBinding();
            ASTNode type = ASTNodes.getParent((ASTNode)this.fDeclaration, AbstractTypeDeclaration.class);
            if (methodBinding.getDeclaringClass().isAnonymous()) {
                finder = new InvocationFinder(methodBinding);
                type.accept((ASTVisitor)finder);
            } else {
                ASTNode block = type.getParent().getParent();
                finder = new InvocationFinder(methodBinding){

                    public boolean visit(Block node) {
                        return this.visitNonTypeBodyDeclaration();
                    }

                    public void endVisit(Block node) {
                        if (this.fCurrent.hasInvocations()) {
                            this.result.put((BodyDeclaration)ASTNodes.getParent((ASTNode)node, BodyDeclaration.class), this.fCurrent);
                        }
                        this.endVisitBodyDeclaration();
                    }
                };
                block.accept((ASTVisitor)finder);
            }
            this.fBodies = finder.result;
        }

        public ICompilationUnit[] getAffectedCompilationUnits(RefactoringStatus status, ReferencesInBinaryContext binaryRefs, IProgressMonitor pm) {
            LocalTypeTargetProvider.fastDone(pm);
            return new ICompilationUnit[]{this.fCUnit};
        }

        public BodyDeclaration[] getAffectedBodyDeclarations(ICompilationUnit unit, IProgressMonitor pm) {
            Assert.isTrue((unit == this.fCUnit ? 1 : 0) != 0);
            Set<BodyDeclaration> result = this.fBodies.keySet();
            LocalTypeTargetProvider.fastDone(pm);
            return result.toArray(new BodyDeclaration[result.size()]);
        }

        public ASTNode[] getInvocations(BodyDeclaration declaration, IProgressMonitor pm) {
            BodyData data = this.fBodies.get(declaration);
            Assert.isNotNull((Object)data);
            LocalTypeTargetProvider.fastDone(pm);
            return data.getInvocations();
        }

        public RefactoringStatus checkActivation() throws JavaModelException {
            return new RefactoringStatus();
        }

        public int getStatusSeverity() {
            return 3;
        }
    }

    private static class MemberTypeTargetProvider
    extends TargetProvider {
        private final IMethodBinding fMethodBinding;
        private Map<BodyDeclaration, BodyData> fCurrentBodies;

        public MemberTypeTargetProvider(IMethodBinding methodBinding) {
            Assert.isNotNull((Object)methodBinding);
            this.fMethodBinding = methodBinding;
        }

        public void initialize() {
        }

        public ICompilationUnit[] getAffectedCompilationUnits(final RefactoringStatus status, ReferencesInBinaryContext binaryRefs, IProgressMonitor pm) throws CoreException {
            IMethod method = (IMethod)this.fMethodBinding.getJavaElement();
            Assert.isTrue((method != null ? 1 : 0) != 0);
            SearchPattern pattern = SearchPattern.createPattern((IJavaElement)method, (int)2, (int)24);
            IJavaSearchScope scope = RefactoringScopeFactory.create((IJavaElement)method, true, false);
            final HashSet affectedCompilationUnits = new HashSet();
            CollectingSearchRequestor requestor = new CollectingSearchRequestor(binaryRefs){
                private ICompilationUnit fLastCU;

                public void acceptSearchMatch(SearchMatch match) throws CoreException {
                    if (this.filterMatch(match)) {
                        return;
                    }
                    if (match.isInsideDocComment()) {
                        return;
                    }
                    ICompilationUnit unit = SearchUtils.getCompilationUnit(match);
                    if (match.getAccuracy() == 1) {
                        if (unit != null) {
                            status.addError(RefactoringCoreMessages.TargetProvider_inaccurate_match, JavaStatusContext.create((ITypeRoot)unit, (ISourceRange)new SourceRange(match.getOffset(), match.getLength())));
                        } else {
                            status.addError(RefactoringCoreMessages.TargetProvider_inaccurate_match);
                        }
                    } else if (unit != null && !unit.equals(this.fLastCU)) {
                        this.fLastCU = unit;
                        affectedCompilationUnits.add(unit);
                    }
                }
            };
            new SearchEngine().search(pattern, SearchUtils.getDefaultSearchParticipants(), scope, (SearchRequestor)requestor, (IProgressMonitor)new SubProgressMonitor(pm, 1));
            return affectedCompilationUnits.toArray(new ICompilationUnit[affectedCompilationUnits.size()]);
        }

        public BodyDeclaration[] getAffectedBodyDeclarations(ICompilationUnit unit, IProgressMonitor pm) {
            CompilationUnit root = new RefactoringASTParser(3).parse((ITypeRoot)unit, true);
            InvocationFinder finder = new InvocationFinder(this.fMethodBinding);
            root.accept((ASTVisitor)finder);
            this.fCurrentBodies = finder.result;
            Set<BodyDeclaration> result = this.fCurrentBodies.keySet();
            MemberTypeTargetProvider.fastDone(pm);
            return result.toArray(new BodyDeclaration[result.size()]);
        }

        public ASTNode[] getInvocations(BodyDeclaration declaration, IProgressMonitor pm) {
            BodyData data = this.fCurrentBodies.get(declaration);
            Assert.isNotNull((Object)data);
            MemberTypeTargetProvider.fastDone(pm);
            return data.getInvocations();
        }

        public RefactoringStatus checkActivation() throws JavaModelException {
            return new RefactoringStatus();
        }

        public int getStatusSeverity() {
            return 3;
        }
    }

    static class SingleCallTargetProvider
    extends TargetProvider {
        private ICompilationUnit fCUnit;
        private ASTNode fInvocation;
        private boolean fIterated;

        public SingleCallTargetProvider(ICompilationUnit cu, ASTNode invocation) {
            Assert.isNotNull((Object)cu);
            Assert.isNotNull((Object)invocation);
            Assert.isTrue((boolean)Invocations.isInvocation(invocation));
            this.fCUnit = cu;
            this.fInvocation = invocation;
        }

        public void initialize() {
            this.fIterated = false;
        }

        public ICompilationUnit[] getAffectedCompilationUnits(RefactoringStatus status, ReferencesInBinaryContext binaryRefs, IProgressMonitor pm) {
            return new ICompilationUnit[]{this.fCUnit};
        }

        public BodyDeclaration[] getAffectedBodyDeclarations(ICompilationUnit unit, IProgressMonitor pm) {
            Assert.isTrue((unit == this.fCUnit ? 1 : 0) != 0);
            if (this.fIterated) {
                return new BodyDeclaration[0];
            }
            SingleCallTargetProvider.fastDone(pm);
            return new BodyDeclaration[]{(BodyDeclaration)ASTNodes.getParent(this.fInvocation, BodyDeclaration.class)};
        }

        public ASTNode[] getInvocations(BodyDeclaration declaration, IProgressMonitor pm) {
            SingleCallTargetProvider.fastDone(pm);
            if (this.fIterated) {
                return null;
            }
            this.fIterated = true;
            return new ASTNode[]{this.fInvocation};
        }

        public RefactoringStatus checkActivation() throws JavaModelException {
            return new RefactoringStatus();
        }

        public int getStatusSeverity() {
            return 4;
        }

        public boolean isSingle() {
            return true;
        }
    }
}

