/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.fix;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.CastExpression;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.EnhancedForStatement;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.NodeFinder;
import org.eclipse.jdt.core.dom.ParenthesizedExpression;
import org.eclipse.jdt.core.dom.PostfixExpression;
import org.eclipse.jdt.core.dom.PrefixExpression;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.SuperMethodInvocation;
import org.eclipse.jdt.core.dom.SwitchStatement;
import org.eclipse.jdt.core.dom.TagElement;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclarationStatement;
import org.eclipse.jdt.core.dom.VariableDeclarationExpression;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.LinkedNodeFinder;
import org.eclipse.jdt.internal.corext.dom.NecessaryParenthesesChecker;
import org.eclipse.jdt.internal.corext.fix.CompilationUnitRewriteOperationsFix;
import org.eclipse.jdt.internal.corext.fix.FixMessages;
import org.eclipse.jdt.internal.corext.fix.LinkedProposalModel;
import org.eclipse.jdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.fix.UnusedCodeCleanUp;
import org.eclipse.jdt.internal.ui.text.correction.JavadocTagsSubProcessor;
import org.eclipse.jdt.internal.ui.text.correction.ProblemLocation;
import org.eclipse.jdt.internal.ui.viewsupport.BasicElementLabels;
import org.eclipse.jdt.ui.cleanup.ICleanUpFix;
import org.eclipse.jdt.ui.text.java.IProblemLocation;
import org.eclipse.text.edits.TextEditGroup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnusedCodeFix
extends CompilationUnitRewriteOperationsFix {
    private final Map<String, String> fCleanUpOptions;

    public static UnusedCodeFix createRemoveUnusedImportFix(CompilationUnit compilationUnit, IProblemLocation problem) {
        ImportDeclaration node;
        if (UnusedCodeFix.isUnusedImport(problem) && (node = UnusedCodeFix.getImportDeclaration(problem, compilationUnit)) != null) {
            String label = FixMessages.UnusedCodeFix_RemoveImport_description;
            RemoveImportOperation operation = new RemoveImportOperation(node);
            Hashtable<String, String> options = new Hashtable<String, String>();
            options.put("cleanup.remove_unused_imports", "true");
            return new UnusedCodeFix(label, compilationUnit, new CompilationUnitRewriteOperationsFix.CompilationUnitRewriteOperation[]{operation}, options);
        }
        return null;
    }

    public static boolean isUnusedImport(IProblemLocation problem) {
        int id = problem.getProblemId();
        return id == 268435844 || id == 268435842 || id == 0x10000181 || id == 268435843 || id == 268435846;
    }

    public static UnusedCodeFix createUnusedMemberFix(CompilationUnit compilationUnit, IProblemLocation problem, boolean removeAllAssignements) {
        IBinding binding;
        SimpleName name;
        if (UnusedCodeFix.isUnusedMember(problem) && (name = UnusedCodeFix.getUnusedName(compilationUnit, problem)) != null && (binding = name.resolveBinding()) != null) {
            if (UnusedCodeFix.isFormalParameterInEnhancedForStatement(name)) {
                return null;
            }
            String label = UnusedCodeFix.getDisplayString(name, binding, removeAllAssignements);
            RemoveUnusedMemberOperation operation = new RemoveUnusedMemberOperation(new SimpleName[]{name}, removeAllAssignements);
            return new UnusedCodeFix(label, compilationUnit, new CompilationUnitRewriteOperationsFix.CompilationUnitRewriteOperation[]{operation}, UnusedCodeFix.getCleanUpOptions(binding, removeAllAssignements));
        }
        return null;
    }

    public static boolean isUnusedMember(IProblemLocation problem) {
        int id = problem.getProblemId();
        return id == 603979894 || id == 603979910 || id == 570425421 || id == 553648135 || id == 536870973 || id == 536870974;
    }

    public static UnusedCodeFix createRemoveUnusedCastFix(CompilationUnit compilationUnit, IProblemLocation problem) {
        ASTNode selectedNode;
        if (problem.getProblemId() != 553648309) {
            return null;
        }
        ASTNode curr = selectedNode = problem.getCoveringNode(compilationUnit);
        while (curr instanceof ParenthesizedExpression) {
            curr = ((ParenthesizedExpression)curr).getExpression();
        }
        if (!(curr instanceof CastExpression)) {
            return null;
        }
        return new UnusedCodeFix(FixMessages.UnusedCodeFix_RemoveCast_description, compilationUnit, new CompilationUnitRewriteOperationsFix.CompilationUnitRewriteOperation[]{new RemoveCastOperation((CastExpression)curr, selectedNode)});
    }

    public static ICleanUpFix createCleanUp(CompilationUnit compilationUnit, boolean removeUnusedPrivateMethods, boolean removeUnusedPrivateConstructors, boolean removeUnusedPrivateFields, boolean removeUnusedPrivateTypes, boolean removeUnusedLocalVariables, boolean removeUnusedImports, boolean removeUnusedCast) {
        IProblem[] problems = compilationUnit.getProblems();
        IProblemLocation[] locations = new IProblemLocation[problems.length];
        int i = 0;
        while (i < problems.length) {
            locations[i] = new ProblemLocation(problems[i]);
            ++i;
        }
        return UnusedCodeFix.createCleanUp(compilationUnit, locations, removeUnusedPrivateMethods, removeUnusedPrivateConstructors, removeUnusedPrivateFields, removeUnusedPrivateTypes, removeUnusedLocalVariables, removeUnusedImports, removeUnusedCast);
    }

    public static ICleanUpFix createCleanUp(CompilationUnit compilationUnit, IProblemLocation[] problems, boolean removeUnusedPrivateMethods, boolean removeUnusedPrivateConstructors, boolean removeUnusedPrivateFields, boolean removeUnusedPrivateTypes, boolean removeUnusedLocalVariables, boolean removeUnusedImports, boolean removeUnusedCast) {
        ArrayList<CompilationUnitRewriteOperationsFix.CompilationUnitRewriteOperation> result = new ArrayList<CompilationUnitRewriteOperationsFix.CompilationUnitRewriteOperation>();
        Hashtable variableDeclarations = new Hashtable();
        HashSet<CastExpression> unnecessaryCasts = new HashSet<CastExpression>();
        int i = 0;
        while (i < problems.length) {
            IBinding binding;
            SimpleName name;
            ImportDeclaration node;
            IProblemLocation problem = problems[i];
            int id = problem.getProblemId();
            if (removeUnusedImports && (id == 268435844 || id == 268435842 || id == 0x10000181 || id == 268435843 || id == 268435846) && (node = UnusedCodeFix.getImportDeclaration(problem, compilationUnit)) != null) {
                result.add(new RemoveImportOperation(node));
            }
            if ((removeUnusedPrivateMethods && id == 603979894 || removeUnusedPrivateConstructors && id == 603979910 || removeUnusedPrivateTypes && id == 553648135) && (name = UnusedCodeFix.getUnusedName(compilationUnit, problem)) != null && (binding = name.resolveBinding()) != null) {
                result.add(new RemoveUnusedMemberOperation(new SimpleName[]{name}, false));
            }
            if ((removeUnusedLocalVariables && id == 536870973 || removeUnusedPrivateFields && id == 570425421) && (name = UnusedCodeFix.getUnusedName(compilationUnit, problem)) != null && (binding = name.resolveBinding()) instanceof IVariableBinding && !UnusedCodeFix.isFormalParameterInEnhancedForStatement(name) && (!((IVariableBinding)binding).isField() || UnusedCodeFix.isSideEffectFree(name, compilationUnit))) {
                VariableDeclarationFragment parent = (VariableDeclarationFragment)ASTNodes.getParent((ASTNode)name, VariableDeclarationFragment.class);
                if (parent != null) {
                    ASTNode varDecl = parent.getParent();
                    if (!variableDeclarations.containsKey(varDecl)) {
                        variableDeclarations.put(varDecl, new ArrayList());
                    }
                    ((List)variableDeclarations.get(varDecl)).add(name);
                } else {
                    result.add(new RemoveUnusedMemberOperation(new SimpleName[]{name}, false));
                }
            }
            if (removeUnusedCast && id == 553648309) {
                ASTNode selectedNode;
                ASTNode curr = selectedNode = problem.getCoveringNode(compilationUnit);
                while (curr instanceof ParenthesizedExpression) {
                    curr = ((ParenthesizedExpression)curr).getExpression();
                }
                if (curr instanceof CastExpression) {
                    unnecessaryCasts.add((CastExpression)curr);
                }
            }
            ++i;
        }
        for (ASTNode node : variableDeclarations.keySet()) {
            List names = (List)variableDeclarations.get(node);
            result.add(new RemoveUnusedMemberOperation(names.toArray(new SimpleName[names.size()]), false));
        }
        if (unnecessaryCasts.size() > 0) {
            result.add(new RemoveAllCastOperation(unnecessaryCasts));
        }
        if (result.size() == 0) {
            return null;
        }
        return new UnusedCodeFix(FixMessages.UnusedCodeFix_change_name, compilationUnit, result.toArray(new CompilationUnitRewriteOperationsFix.CompilationUnitRewriteOperation[result.size()]));
    }

    private static boolean isFormalParameterInEnhancedForStatement(SimpleName name) {
        return name.getParent() instanceof SingleVariableDeclaration && name.getParent().getLocationInParent() == EnhancedForStatement.PARAMETER_PROPERTY;
    }

    private static boolean isSideEffectFree(SimpleName simpleName, CompilationUnit completeRoot) {
        SimpleName nameNode = (SimpleName)NodeFinder.perform((ASTNode)completeRoot, (int)simpleName.getStartPosition(), (int)simpleName.getLength());
        SimpleName[] references = LinkedNodeFinder.findByBinding((ASTNode)completeRoot, nameNode.resolveBinding());
        int i = 0;
        while (i < references.length) {
            if (UnusedCodeFix.hasSideEffect(references[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static boolean hasSideEffect(SimpleName reference) {
        ASTNode parent = reference.getParent();
        while (parent instanceof QualifiedName) {
            parent = parent.getParent();
        }
        if (parent instanceof FieldAccess) {
            parent = parent.getParent();
        }
        Expression node = null;
        int nameParentType = parent.getNodeType();
        if (nameParentType == 7) {
            Assignment assignment = (Assignment)parent;
            node = assignment.getRightHandSide();
        } else if (nameParentType == 44) {
            SingleVariableDeclaration decl = (SingleVariableDeclaration)parent;
            node = decl.getInitializer();
            if (node == null) {
                return false;
            }
        } else if (nameParentType == 59) {
            node = parent;
        } else {
            return false;
        }
        ArrayList<Expression> sideEffects = new ArrayList<Expression>();
        node.accept((ASTVisitor)new SideEffectFinder(sideEffects));
        return sideEffects.size() > 0;
    }

    private static SimpleName getUnusedName(CompilationUnit compilationUnit, IProblemLocation problem) {
        ASTNode selectedNode = problem.getCoveringNode(compilationUnit);
        if (selectedNode instanceof MethodDeclaration) {
            return ((MethodDeclaration)selectedNode).getName();
        }
        if (selectedNode instanceof SimpleName) {
            return (SimpleName)selectedNode;
        }
        return null;
    }

    private static String getDisplayString(SimpleName simpleName, IBinding binding, boolean removeAllAssignements) {
        String name = BasicElementLabels.getJavaElementName(simpleName.getIdentifier());
        switch (binding.getKind()) {
            case 2: {
                return Messages.format(FixMessages.UnusedCodeFix_RemoveType_description, name);
            }
            case 4: {
                if (((IMethodBinding)binding).isConstructor()) {
                    return Messages.format(FixMessages.UnusedCodeFix_RemoveConstructor_description, name);
                }
                return Messages.format(FixMessages.UnusedCodeFix_RemoveMethod_description, name);
            }
            case 3: {
                if (removeAllAssignements) {
                    return Messages.format(FixMessages.UnusedCodeFix_RemoveFieldOrLocalWithInitializer_description, name);
                }
                return Messages.format(FixMessages.UnusedCodeFix_RemoveFieldOrLocal_description, name);
            }
        }
        return "";
    }

    private static Map<String, String> getCleanUpOptions(IBinding binding, boolean removeAll) {
        Hashtable<String, String> result = new Hashtable<String, String>();
        result.put("cleanup.remove_unused_private_members", "true");
        switch (binding.getKind()) {
            case 2: {
                result.put("cleanup.remove_unused_private_types", "true");
                break;
            }
            case 4: {
                if (((IMethodBinding)binding).isConstructor()) {
                    result.put("cleanup.remove_private_constructors", "true");
                    break;
                }
                result.put("cleanup.remove_unused_private_methods", "true");
                break;
            }
            case 3: {
                if (removeAll) {
                    return null;
                }
                result.put("cleanup.remove_unused_private_fields", "true");
                result.put("cleanup.remove_unused_local_variables", "true");
            }
        }
        return result;
    }

    private static ImportDeclaration getImportDeclaration(IProblemLocation problem, CompilationUnit compilationUnit) {
        ASTNode node;
        ASTNode selectedNode = problem.getCoveringNode(compilationUnit);
        if (selectedNode != null && (node = ASTNodes.getParent(selectedNode, 26)) instanceof ImportDeclaration) {
            return (ImportDeclaration)node;
        }
        return null;
    }

    private UnusedCodeFix(String name, CompilationUnit compilationUnit, CompilationUnitRewriteOperationsFix.CompilationUnitRewriteOperation[] fixRewriteOperations) {
        this(name, compilationUnit, fixRewriteOperations, null);
    }

    private UnusedCodeFix(String name, CompilationUnit compilationUnit, CompilationUnitRewriteOperationsFix.CompilationUnitRewriteOperation[] fixRewriteOperations, Map<String, String> options) {
        super(name, compilationUnit, fixRewriteOperations);
        this.fCleanUpOptions = options;
    }

    public UnusedCodeCleanUp getCleanUp() {
        if (this.fCleanUpOptions == null) {
            return null;
        }
        return new UnusedCodeCleanUp(this.fCleanUpOptions);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RemoveAllCastOperation
    extends CompilationUnitRewriteOperationsFix.CompilationUnitRewriteOperation {
        private final HashSet<CastExpression> fUnnecessaryCasts;

        public RemoveAllCastOperation(HashSet<CastExpression> unnecessaryCasts) {
            this.fUnnecessaryCasts = unnecessaryCasts;
        }

        @Override
        public void rewriteAST(CompilationUnitRewrite cuRewrite, LinkedProposalModel model) throws CoreException {
            ASTRewrite rewrite = cuRewrite.getASTRewrite();
            TextEditGroup group = this.createTextEditGroup(FixMessages.UnusedCodeFix_RemoveCast_description, cuRewrite);
            while (this.fUnnecessaryCasts.size() > 0) {
                CastExpression castExpression = this.fUnnecessaryCasts.iterator().next();
                this.fUnnecessaryCasts.remove(castExpression);
                CastExpression down = castExpression;
                while (this.fUnnecessaryCasts.contains(down.getExpression())) {
                    down = (CastExpression)down.getExpression();
                    this.fUnnecessaryCasts.remove(down);
                }
                Expression expression = down.getExpression();
                ASTNode move = rewrite.createMoveTarget((ASTNode)expression);
                CastExpression top = castExpression;
                while (this.fUnnecessaryCasts.contains(top.getParent())) {
                    top = (CastExpression)top.getParent();
                    this.fUnnecessaryCasts.remove(top);
                }
                CastExpression toReplace = top;
                if (top.getParent() instanceof ParenthesizedExpression && !NecessaryParenthesesChecker.needsParentheses(expression, top.getParent(), top.getLocationInParent())) {
                    toReplace = top.getParent();
                }
                rewrite.replace((ASTNode)toReplace, move, group);
            }
        }
    }

    private static class RemoveCastOperation
    extends CompilationUnitRewriteOperationsFix.CompilationUnitRewriteOperation {
        private final CastExpression fCast;
        private final ASTNode fSelectedNode;

        public RemoveCastOperation(CastExpression cast, ASTNode selectedNode) {
            this.fCast = cast;
            this.fSelectedNode = selectedNode;
        }

        public void rewriteAST(CompilationUnitRewrite cuRewrite, LinkedProposalModel model) throws CoreException {
            TextEditGroup group = this.createTextEditGroup(FixMessages.UnusedCodeFix_RemoveCast_description, cuRewrite);
            ASTRewrite rewrite = cuRewrite.getASTRewrite();
            CastExpression cast = this.fCast;
            Expression expression = cast.getExpression();
            ASTNode placeholder = rewrite.createCopyTarget((ASTNode)expression);
            if (NecessaryParenthesesChecker.needsParentheses(expression, cast.getParent(), cast.getLocationInParent())) {
                rewrite.replace((ASTNode)this.fCast, placeholder, group);
            } else {
                rewrite.replace(this.fCast.getParent() instanceof ParenthesizedExpression ? this.fCast.getParent() : this.fSelectedNode, placeholder, group);
            }
        }
    }

    private static class RemoveImportOperation
    extends CompilationUnitRewriteOperationsFix.CompilationUnitRewriteOperation {
        private final ImportDeclaration fImportDeclaration;

        public RemoveImportOperation(ImportDeclaration importDeclaration) {
            this.fImportDeclaration = importDeclaration;
        }

        public void rewriteAST(CompilationUnitRewrite cuRewrite, LinkedProposalModel model) throws CoreException {
            ImportDeclaration node = this.fImportDeclaration;
            TextEditGroup group = this.createTextEditGroup(FixMessages.UnusedCodeFix_RemoveImport_description, cuRewrite);
            cuRewrite.getASTRewrite().remove((ASTNode)node, group);
        }
    }

    private static class RemoveUnusedMemberOperation
    extends CompilationUnitRewriteOperationsFix.CompilationUnitRewriteOperation {
        private final SimpleName[] fUnusedNames;
        private boolean fForceRemove;
        private int fRemovedAssignmentsCount;
        private int fAlteredAssignmentsCount;

        public RemoveUnusedMemberOperation(SimpleName[] unusedNames, boolean removeAllAsignements) {
            this.fUnusedNames = unusedNames;
            this.fForceRemove = removeAllAsignements;
        }

        public void rewriteAST(CompilationUnitRewrite cuRewrite, LinkedProposalModel model) throws CoreException {
            int i = 0;
            while (i < this.fUnusedNames.length) {
                this.removeUnusedName(cuRewrite, this.fUnusedNames[i]);
                ++i;
            }
        }

        private void removeUnusedName(CompilationUnitRewrite cuRewrite, SimpleName simpleName) {
            ASTRewrite rewrite = cuRewrite.getASTRewrite();
            CompilationUnit completeRoot = cuRewrite.getRoot();
            IBinding binding = simpleName.resolveBinding();
            CompilationUnit root = (CompilationUnit)simpleName.getRoot();
            String displayString = this.getDisplayString(binding);
            TextEditGroup group = this.createTextEditGroup(displayString, cuRewrite);
            if (binding.getKind() == 4) {
                IMethodBinding decl = ((IMethodBinding)binding).getMethodDeclaration();
                ASTNode declaration = root.findDeclaringNode((IBinding)decl);
                rewrite.remove(declaration, group);
            } else if (binding.getKind() == 2) {
                ITypeBinding decl = ((ITypeBinding)binding).getTypeDeclaration();
                ASTNode declaration = root.findDeclaringNode((IBinding)decl);
                if (declaration.getParent() instanceof TypeDeclarationStatement) {
                    declaration = declaration.getParent();
                }
                rewrite.remove(declaration, group);
            } else if (binding.getKind() == 3) {
                SimpleName nameNode = (SimpleName)NodeFinder.perform((ASTNode)completeRoot, (int)simpleName.getStartPosition(), (int)simpleName.getLength());
                SimpleName[] references = LinkedNodeFinder.findByBinding((ASTNode)completeRoot, nameNode.resolveBinding());
                int i = 0;
                while (i < references.length) {
                    this.removeVariableReferences(rewrite, references[i], group);
                    ++i;
                }
                IVariableBinding bindingDecl = ((IVariableBinding)nameNode.resolveBinding()).getVariableDeclaration();
                ASTNode declaringNode = completeRoot.findDeclaringNode((IBinding)bindingDecl);
                if (declaringNode instanceof SingleVariableDeclaration) {
                    this.removeParamTag(rewrite, (SingleVariableDeclaration)declaringNode, group);
                }
            }
        }

        private String getDisplayString(IBinding binding) {
            switch (binding.getKind()) {
                case 2: {
                    return FixMessages.UnusedCodeFix_RemoveUnusedType_description;
                }
                case 4: {
                    if (((IMethodBinding)binding).isConstructor()) {
                        return FixMessages.UnusedCodeFix_RemoveUnusedConstructor_description;
                    }
                    return FixMessages.UnusedCodeFix_RemoveUnusedPrivateMethod_description;
                }
                case 3: {
                    if (((IVariableBinding)binding).isField()) {
                        return FixMessages.UnusedCodeFix_RemoveUnusedField_description;
                    }
                    return FixMessages.UnusedCodeFix_RemoveUnusedVariabl_description;
                }
            }
            return "";
        }

        private void removeParamTag(ASTRewrite rewrite, SingleVariableDeclaration varDecl, TextEditGroup group) {
            TagElement tagElement;
            Javadoc javadoc;
            if (varDecl.getParent() instanceof MethodDeclaration && (javadoc = ((MethodDeclaration)varDecl.getParent()).getJavadoc()) != null && (tagElement = JavadocTagsSubProcessor.findParamTag(javadoc, varDecl.getName().getIdentifier())) != null) {
                rewrite.remove((ASTNode)tagElement, group);
            }
        }

        private void removeVariableReferences(ASTRewrite rewrite, SimpleName reference, TextEditGroup group) {
            int nameParentType;
            ASTNode parent = reference.getParent();
            while (parent instanceof QualifiedName) {
                parent = parent.getParent();
            }
            if (parent instanceof FieldAccess) {
                parent = parent.getParent();
            }
            if ((nameParentType = parent.getNodeType()) == 7) {
                Assignment assignment = (Assignment)parent;
                Expression rightHand = assignment.getRightHandSide();
                ASTNode assignParent = assignment.getParent();
                if (assignParent.getNodeType() == 21 && rightHand.getNodeType() != 7) {
                    this.removeVariableWithInitializer(rewrite, (ASTNode)rightHand, assignParent, group);
                } else {
                    rewrite.replace((ASTNode)assignment, rewrite.createCopyTarget((ASTNode)rightHand), group);
                }
            } else if (nameParentType == 44) {
                rewrite.remove(parent, group);
            } else if (nameParentType == 59) {
                boolean sideEffectInitializer;
                VariableDeclarationFragment frag = (VariableDeclarationFragment)parent;
                ASTNode varDecl = frag.getParent();
                List fragments = varDecl instanceof VariableDeclarationExpression ? ((VariableDeclarationExpression)varDecl).fragments() : (varDecl instanceof FieldDeclaration ? ((FieldDeclaration)varDecl).fragments() : ((VariableDeclarationStatement)varDecl).fragments());
                Expression initializer = frag.getInitializer();
                if (initializer instanceof CastExpression) {
                    initializer = ((CastExpression)initializer).getExpression();
                }
                boolean bl = sideEffectInitializer = initializer instanceof MethodInvocation || initializer instanceof ClassInstanceCreation;
                if (fragments.size() == this.fUnusedNames.length) {
                    if (this.fForceRemove) {
                        rewrite.remove(varDecl, group);
                        return;
                    }
                    if (parent.getParent() instanceof FieldDeclaration) {
                        rewrite.remove(varDecl, group);
                        return;
                    }
                    if (sideEffectInitializer) {
                        Expression movedInit = (Expression)rewrite.createMoveTarget((ASTNode)initializer);
                        ExpressionStatement wrapped = rewrite.getAST().newExpressionStatement(movedInit);
                        rewrite.replace(varDecl, (ASTNode)wrapped, group);
                    } else {
                        rewrite.remove(varDecl, group);
                    }
                } else {
                    if (this.fForceRemove) {
                        rewrite.remove((ASTNode)frag, group);
                        return;
                    }
                    ASTNode declaration = parent.getParent();
                    if (declaration instanceof FieldDeclaration) {
                        rewrite.remove((ASTNode)frag, group);
                        return;
                    }
                    if (declaration instanceof VariableDeclarationStatement) {
                        ASTNode lst = declaration.getParent();
                        ListRewrite listRewrite = null;
                        if (lst instanceof Block) {
                            listRewrite = rewrite.getListRewrite(lst, Block.STATEMENTS_PROPERTY);
                        } else if (lst instanceof SwitchStatement) {
                            listRewrite = rewrite.getListRewrite(lst, SwitchStatement.STATEMENTS_PROPERTY);
                        } else {
                            Assert.isTrue((boolean)false);
                        }
                        this.splitUpDeclarations(rewrite, group, frag, listRewrite, (VariableDeclarationStatement)declaration);
                        rewrite.remove((ASTNode)frag, group);
                        return;
                    }
                    if (declaration instanceof VariableDeclarationExpression && !sideEffectInitializer) {
                        rewrite.remove((ASTNode)frag, group);
                    }
                }
            } else if (nameParentType == 37 || nameParentType == 38) {
                Expression expression = (Expression)parent;
                ASTNode expressionParent = expression.getParent();
                if (expressionParent.getNodeType() == 21) {
                    this.removeStatement(rewrite, expressionParent, group);
                } else {
                    rewrite.remove((ASTNode)expression, group);
                }
            }
        }

        private void splitUpDeclarations(ASTRewrite rewrite, TextEditGroup group, VariableDeclarationFragment frag, ListRewrite statementRewrite, VariableDeclarationStatement originalStatement) {
            Expression initializer = frag.getInitializer();
            if (initializer instanceof MethodInvocation || initializer instanceof ClassInstanceCreation) {
                Expression movedInitializer = (Expression)rewrite.createMoveTarget((ASTNode)initializer);
                ExpressionStatement newInitializer = rewrite.getAST().newExpressionStatement(movedInitializer);
                statementRewrite.insertAfter((ASTNode)newInitializer, (ASTNode)originalStatement, group);
                VariableDeclarationStatement newDeclaration = null;
                List fragments = originalStatement.fragments();
                int fragIndex = fragments.indexOf(frag);
                ListIterator fragmentIterator = fragments.listIterator(fragIndex + 1);
                while (fragmentIterator.hasNext()) {
                    VariableDeclarationFragment currentFragment = (VariableDeclarationFragment)fragmentIterator.next();
                    VariableDeclarationFragment movedFragment = (VariableDeclarationFragment)rewrite.createMoveTarget((ASTNode)currentFragment);
                    if (newDeclaration == null) {
                        newDeclaration = rewrite.getAST().newVariableDeclarationStatement(movedFragment);
                        Type copiedType = (Type)rewrite.createCopyTarget((ASTNode)originalStatement.getType());
                        newDeclaration.setType(copiedType);
                        continue;
                    }
                    newDeclaration.fragments().add(movedFragment);
                }
                if (newDeclaration != null) {
                    statementRewrite.insertAfter(newDeclaration, (ASTNode)newInitializer, group);
                }
                if (originalStatement.fragments().size() == newDeclaration.fragments().size() + 1) {
                    rewrite.remove((ASTNode)originalStatement, group);
                }
            }
        }

        private void removeVariableWithInitializer(ASTRewrite rewrite, ASTNode initializerNode, ASTNode statementNode, TextEditGroup group) {
            boolean performRemove = this.fForceRemove;
            if (!performRemove) {
                ArrayList<Expression> sideEffectNodes = new ArrayList<Expression>();
                initializerNode.accept((ASTVisitor)new SideEffectFinder(sideEffectNodes));
                performRemove = sideEffectNodes.isEmpty();
            }
            if (performRemove) {
                this.removeStatement(rewrite, statementNode, group);
                ++this.fRemovedAssignmentsCount;
            } else {
                ASTNode initNode = rewrite.createMoveTarget(initializerNode);
                ExpressionStatement statement = rewrite.getAST().newExpressionStatement((Expression)initNode);
                rewrite.replace(statementNode, (ASTNode)statement, null);
                ++this.fAlteredAssignmentsCount;
            }
        }

        private void removeStatement(ASTRewrite rewrite, ASTNode statementNode, TextEditGroup group) {
            if (ASTNodes.isControlStatementBody(statementNode.getLocationInParent())) {
                rewrite.replace(statementNode, (ASTNode)rewrite.getAST().newBlock(), group);
            } else {
                rewrite.remove(statementNode, group);
            }
        }

        public String getAdditionalInfo() {
            StringBuffer sb = new StringBuffer();
            if (this.fRemovedAssignmentsCount == 1) {
                sb.append(FixMessages.UnusedCodeFix_RemoveFieldOrLocal_RemovedAssignments_preview_singular);
            } else if (this.fRemovedAssignmentsCount > 1) {
                sb.append(Messages.format(FixMessages.UnusedCodeFix_RemoveFieldOrLocal_RemovedAssignments_preview_plural, String.valueOf(this.fRemovedAssignmentsCount)));
            }
            if (this.fAlteredAssignmentsCount == 1) {
                sb.append(FixMessages.UnusedCodeFix_RemoveFieldOrLocal_AlteredAssignments_preview_singular);
            } else if (this.fAlteredAssignmentsCount > 1) {
                sb.append(Messages.format(FixMessages.UnusedCodeFix_RemoveFieldOrLocal_AlteredAssignments_preview_plural, String.valueOf(this.fAlteredAssignmentsCount)));
            }
            if (sb.length() > 0) {
                return sb.toString();
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SideEffectFinder
    extends ASTVisitor {
        private final ArrayList<Expression> fSideEffectNodes;

        public SideEffectFinder(ArrayList<Expression> res) {
            this.fSideEffectNodes = res;
        }

        public boolean visit(Assignment node) {
            this.fSideEffectNodes.add((Expression)node);
            return false;
        }

        public boolean visit(PostfixExpression node) {
            this.fSideEffectNodes.add((Expression)node);
            return false;
        }

        public boolean visit(PrefixExpression node) {
            PrefixExpression.Operator operator = node.getOperator();
            if (operator == PrefixExpression.Operator.INCREMENT || operator == PrefixExpression.Operator.DECREMENT) {
                this.fSideEffectNodes.add((Expression)node);
            }
            return false;
        }

        public boolean visit(MethodInvocation node) {
            this.fSideEffectNodes.add((Expression)node);
            return false;
        }

        public boolean visit(ClassInstanceCreation node) {
            this.fSideEffectNodes.add((Expression)node);
            return false;
        }

        public boolean visit(SuperMethodInvocation node) {
            this.fSideEffectNodes.add((Expression)node);
            return false;
        }
    }
}

