/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.services;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.ExpressionInfo;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.contexts.RunAndTrack;
import org.eclipse.e4.ui.workbench.modeling.ExpressionContext;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ui.ISourceProvider;
import org.eclipse.ui.ISourceProviderListener;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.services.EvaluationReference;
import org.eclipse.ui.services.IEvaluationReference;
import org.eclipse.ui.services.IEvaluationService;

public final class EvaluationService
implements IEvaluationService {
    private ExpressionContext legacyContext;
    private int notifying = 0;
    private ListenerList serviceListeners = new ListenerList(1);
    ArrayList<ISourceProvider> sourceProviders = new ArrayList();
    private IEclipseContext context;
    LinkedList<EvaluationReference> refs = new LinkedList();
    private ISourceProviderListener contextUpdater;
    private HashSet<String> variableFilter = new HashSet();

    public EvaluationService(IEclipseContext c) {
        this.context = c;
        this.legacyContext = new ExpressionContext(c);
        this.contextUpdater = new ISourceProviderListener(){

            public void sourceChanged(int sourcePriority, String sourceName, Object sourceValue) {
                EvaluationService.this.changeVariable(sourceName, sourceValue);
            }

            public void sourceChanged(int sourcePriority, Map sourceValuesByName) {
                for (Map.Entry entry : sourceValuesByName.entrySet()) {
                    EvaluationService.this.changeVariable((String)entry.getKey(), entry.getValue());
                }
            }
        };
        this.variableFilter.addAll(Arrays.asList("activeWorkbenchWindow", "activeWorkbenchWindowShell", "activeEditorId", "activeEditorInput", "showInInput", "showInSelection", "activePart", "activePartId", "activeSite", "activeContexts", "selection"));
    }

    protected final void changeVariable(String name, Object value) {
        if (name == null || this.variableFilter.contains(name)) {
            return;
        }
        if (value == null) {
            this.legacyContext.removeVariable(name);
        } else {
            this.legacyContext.addVariable(name, value);
        }
    }

    public void addSourceProvider(ISourceProvider provider) {
        this.sourceProviders.add(provider);
        provider.addSourceProviderListener(this.contextUpdater);
        Map currentState = provider.getCurrentState();
        for (Map.Entry entry : currentState.entrySet()) {
            String variableName = (String)entry.getKey();
            Object variableValue = entry.getValue();
            if (variableName == null || "activeWorkbenchWindowShell".equals(variableName)) continue;
            this.changeVariable(variableName, variableValue);
        }
    }

    public void removeSourceProvider(ISourceProvider provider) {
        provider.removeSourceProviderListener(this.contextUpdater);
        this.sourceProviders.remove(provider);
        Map currentState = provider.getCurrentState();
        for (Map.Entry entry : currentState.entrySet()) {
            String variableName = (String)entry.getKey();
            this.changeVariable(variableName, null);
        }
    }

    public void dispose() {
        for (EvaluationReference ref : this.refs) {
            this.invalidate(ref, false);
        }
        this.refs.clear();
        this.serviceListeners.clear();
    }

    public void addServiceListener(IPropertyChangeListener listener) {
        this.serviceListeners.add((Object)listener);
    }

    public void removeServiceListener(IPropertyChangeListener listener) {
        this.serviceListeners.remove((Object)listener);
    }

    public IEvaluationReference addEvaluationListener(Expression expression, IPropertyChangeListener listener, String property) {
        EvaluationReference ref = new EvaluationReference(this.context, expression, listener, property);
        this.addEvaluationReference(ref);
        return ref;
    }

    public void addEvaluationReference(IEvaluationReference ref) {
        EvaluationReference eref = (EvaluationReference)ref;
        this.refs.add(eref);
        eref.participating = true;
        this.context.runAndTrack((RunAndTrack)eref);
    }

    private void invalidate(IEvaluationReference ref, boolean remove) {
        if (remove) {
            this.refs.remove(ref);
        }
        EvaluationReference eref = (EvaluationReference)ref;
        eref.participating = false;
        eref.evaluate();
        eref.hasRun = false;
    }

    public void removeEvaluationListener(IEvaluationReference ref) {
        this.invalidate(ref, true);
    }

    public IEvaluationContext getCurrentState() {
        return this.legacyContext;
    }

    public void requestEvaluation(String propertyName) {
        String[] sourceNames = new String[]{propertyName};
        this.startSourceChange(sourceNames);
        block0: for (EvaluationReference ref : this.refs) {
            String[] names;
            Expression expr = ref.getExpression();
            if (expr == null) continue;
            ExpressionInfo info = expr.computeExpressionInfo();
            String[] stringArray = names = info.getAccessedPropertyNames();
            int n = names.length;
            int n2 = 0;
            while (n2 < n) {
                String name = stringArray[n2];
                if (propertyName.equals(name)) {
                    ref.evaluate();
                    continue block0;
                }
                ++n2;
            }
        }
        this.endSourceChange(sourceNames);
    }

    private void startSourceChange(String[] sourceNames) {
        ++this.notifying;
        if (this.notifying == 1) {
            this.fireServiceChange("org.eclipse.ui.services.notifying", Boolean.FALSE, Boolean.TRUE);
        }
    }

    private void endSourceChange(String[] sourceNames) {
        if (this.notifying == 1) {
            this.fireServiceChange("org.eclipse.ui.services.notifying", Boolean.TRUE, Boolean.FALSE);
        }
        --this.notifying;
    }

    private void fireServiceChange(final String property, final Object oldValue, final Object newValue) {
        Object[] listeners = this.serviceListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            final IPropertyChangeListener listener = (IPropertyChangeListener)listeners[i];
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void handleException(Throwable exception) {
                    WorkbenchPlugin.log(exception);
                }

                public void run() throws Exception {
                    listener.propertyChange(new PropertyChangeEvent((Object)EvaluationService.this, property, oldValue, newValue));
                }
            });
            ++i;
        }
    }
}

