/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.UIEvents;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.ISaveablePart;
import org.eclipse.ui.ISaveablesLifecycleListener;
import org.eclipse.ui.ISizeProvider;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPart2;
import org.eclipse.ui.IWorkbenchPart3;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.PartPane;
import org.eclipse.ui.internal.PartSite;
import org.eclipse.ui.internal.SaveablesList;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.e4.compatibility.CompatibilityPart;
import org.eclipse.ui.internal.misc.UIListenerLogging;
import org.eclipse.ui.internal.util.Util;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public abstract class WorkbenchPartReference
implements IWorkbenchPartReference,
ISizeProvider {
    public static final int INTERNAL_PROPERTY_OPENED = 529;
    public static final int INTERNAL_PROPERTY_CLOSED = 530;
    public static final int INTERNAL_PROPERTY_PINNED = 531;
    public static final int INTERNAL_PROPERTY_VISIBLE = 532;
    public static final int INTERNAL_PROPERTY_ZOOMED = 533;
    public static final int INTERNAL_PROPERTY_ACTIVE_CHILD_CHANGED = 534;
    public static final int INTERNAL_PROPERTY_MAXIMIZED = 535;
    public static int STATE_LAZY = 0;
    public static int STATE_CREATION_IN_PROGRESS = 1;
    public static int STATE_CREATED = 2;
    public static int STATE_DISPOSED = 3;
    static String MEMENTO_KEY = "memento";
    private int state = STATE_LAZY;
    protected IWorkbenchPart legacyPart;
    private boolean pinned = false;
    private Image image = null;
    private ImageDescriptor defaultImageDescriptor;
    private ImageDescriptor imageDescriptor;
    private ListenerList propChangeListeners = new ListenerList();
    private ListenerList internalPropChangeListeners = new ListenerList();
    private ListenerList partChangeListeners = new ListenerList();
    protected Map propertyCache = new HashMap();
    private IPropertyListener propertyChangeListener = new IPropertyListener(){

        public void propertyChanged(Object source, int propId) {
            WorkbenchPartReference.this.partPropertyChanged(source, propId);
        }
    };
    private IPropertyChangeListener partPropertyChangeListener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            WorkbenchPartReference.this.partPropertyChanged(event);
        }
    };
    private IWorkbenchPage page;
    private MPart part;
    private IEclipseContext windowContext;
    private EventHandler contextEventHandler;

    public WorkbenchPartReference(IEclipseContext windowContext, IWorkbenchPage page, MPart part) {
        this.windowContext = windowContext;
        this.page = page;
        this.part = part;
    }

    private EventHandler createContextEventHandler() {
        if (this.contextEventHandler == null) {
            this.contextEventHandler = new EventHandler(){

                public void handleEvent(Event event) {
                    MPart part;
                    Object element = event.getProperty("ChangedElement");
                    if (element == (part = WorkbenchPartReference.this.getModel()) && part.getContext() != null) {
                        part.getContext().set(this.getClass().getName(), (Object)this);
                        WorkbenchPartReference.this.unsubscribe();
                    }
                }
            };
        }
        return this.contextEventHandler;
    }

    public void subscribe() {
        IEventBroker broker = (IEventBroker)this.windowContext.get(IEventBroker.class);
        broker.subscribe(UIEvents.buildTopic((String)"org/eclipse/e4/ui/model/ui/Context", (String)"context"), this.createContextEventHandler());
    }

    public void unsubscribe() {
        if (this.contextEventHandler != null) {
            IEventBroker broker = (IEventBroker)this.windowContext.get(IEventBroker.class);
            broker.unsubscribe(this.contextEventHandler);
            this.contextEventHandler = null;
        }
    }

    public boolean isDisposed() {
        return this.state == STATE_DISPOSED;
    }

    protected void checkReference() {
        if (this.state == STATE_DISPOSED) {
            throw new RuntimeException("Error: IWorkbenchPartReference disposed");
        }
    }

    public MPart getModel() {
        return this.part;
    }

    protected void setImageDescriptor(ImageDescriptor descriptor) {
        if (Util.equals(this.imageDescriptor, descriptor)) {
            return;
        }
        Image oldImage = this.image;
        ImageDescriptor oldDescriptor = this.imageDescriptor;
        this.image = null;
        this.imageDescriptor = descriptor;
        this.immediateFirePropertyChange(1);
        if (oldImage != null) {
            JFaceResources.getResources().destroy((DeviceResourceDescriptor)oldDescriptor);
        }
    }

    protected void partPropertyChanged(Object source, int propId) {
        IWorkbenchPart actualPart;
        this.firePropertyChange(propId);
        if (propId == 257 && (actualPart = this.getPart(false)) != null) {
            SaveablesList modelManager = (SaveablesList)actualPart.getSite().getService(ISaveablesLifecycleListener.class);
            modelManager.dirtyChanged(actualPart);
        }
    }

    protected void partPropertyChanged(PropertyChangeEvent event) {
        this.firePartPropertyChange(event);
    }

    protected ImageDescriptor computeImageDescriptor() {
        if (this.legacyPart != null) {
            return ImageDescriptor.createFromImage((Image)this.legacyPart.getTitleImage(), (Device)Display.getCurrent());
        }
        return this.defaultImageDescriptor;
    }

    public void init(ImageDescriptor desc) {
        Assert.isNotNull((Object)desc);
        this.defaultImageDescriptor = desc;
        this.imageDescriptor = this.computeImageDescriptor();
    }

    protected void releaseReferences() {
    }

    void addInternalPropertyListener(IPropertyListener listener) {
        this.internalPropChangeListeners.add((Object)listener);
    }

    void removeInternalPropertyListener(IPropertyListener listener) {
        this.internalPropChangeListeners.remove((Object)listener);
    }

    protected void fireInternalPropertyChange(int id) {
        Object[] listeners = this.internalPropChangeListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            ((IPropertyListener)listeners[i]).propertyChanged(this, id);
            ++i;
        }
    }

    public void addPropertyListener(IPropertyListener listener) {
        if (this.isDisposed()) {
            return;
        }
        this.propChangeListeners.add((Object)listener);
    }

    public void removePropertyListener(IPropertyListener listener) {
        if (this.isDisposed()) {
            return;
        }
        this.propChangeListeners.remove((Object)listener);
    }

    public String getTitle() {
        String title = this.legacyPart == null ? this.part.getLocalizedLabel() : this.legacyPart.getTitle();
        return Util.safeString(title);
    }

    public String getTitleToolTip() {
        String toolTip = this.part.getLocalizedTooltip();
        return Util.safeString(toolTip);
    }

    public String getId() {
        return this.part.getElementId();
    }

    protected String computeTitle() {
        return this.getRawTitle();
    }

    protected final String getRawTitle() {
        return Util.safeString(this.legacyPart.getTitle());
    }

    public final Image getTitleImage() {
        if (this.isDisposed()) {
            return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_DEF_VIEW");
        }
        if (this.image == null) {
            this.image = JFaceResources.getResources().createImageWithDefault(this.imageDescriptor);
        }
        return this.image;
    }

    public ImageDescriptor getTitleImageDescriptor() {
        if (this.isDisposed()) {
            return PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_DEF_VIEW");
        }
        return this.imageDescriptor;
    }

    void fireVisibilityChange() {
        this.fireInternalPropertyChange(532);
    }

    void fireZoomChange() {
        this.fireInternalPropertyChange(533);
    }

    protected void firePropertyChange(int id) {
        this.immediateFirePropertyChange(id);
    }

    private void immediateFirePropertyChange(int id) {
        UIListenerLogging.logPartReferencePropertyChange(this, id);
        Object[] listeners = this.propChangeListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            ((IPropertyListener)listeners[i]).propertyChanged(this.legacyPart, id);
            ++i;
        }
        this.fireInternalPropertyChange(id);
    }

    public abstract PartSite getSite();

    public abstract void initialize(IWorkbenchPart var1) throws PartInitException;

    private void addPropertyListeners() {
        IWorkbenchPart workbenchPart = this.getPart(false);
        if (workbenchPart != null) {
            workbenchPart.addPropertyListener(new IPropertyListener(){

                public void propertyChanged(Object source, int propId) {
                    WorkbenchPartReference.this.firePropertyListeners(source, propId);
                }
            });
            if (workbenchPart instanceof IWorkbenchPart3) {
                ((IWorkbenchPart3)workbenchPart).addPartPropertyListener(new IPropertyChangeListener(){

                    public void propertyChange(PropertyChangeEvent event) {
                        WorkbenchPartReference.this.firePartPropertyChange(event);
                    }
                });
            }
        }
    }

    private void firePropertyListeners(Object source, int propId) {
        Object[] objectArray = this.propChangeListeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((IPropertyListener)listener).propertyChanged(source, propId);
            ++n2;
        }
    }

    public final IWorkbenchPart getPart(boolean restore) {
        if (this.isDisposed()) {
            return null;
        }
        if (this.legacyPart == null) {
            CompatibilityPart compatibilityPart;
            if (restore && this.part.getWidget() == null) {
                EPartService partService = (EPartService)this.windowContext.get(EPartService.class);
                partService.showPart(this.part, EPartService.PartState.CREATE);
            }
            if (this.part.getWidget() != null && (compatibilityPart = (CompatibilityPart)this.part.getObject()) != null) {
                this.legacyPart = compatibilityPart.getPart();
                this.addPropertyListeners();
            }
        }
        return this.legacyPart;
    }

    public abstract IWorkbenchPart createPart() throws PartInitException;

    abstract IWorkbenchPart createErrorPart();

    public abstract IWorkbenchPart createErrorPart(IStatus var1);

    protected void doDisposeNestedParts() {
    }

    public void doDisposePart() {
        if (this.legacyPart != null) {
            this.fireInternalPropertyChange(530);
            try {
                this.legacyPart.removePropertyListener(this.propertyChangeListener);
                if (this.legacyPart instanceof IWorkbenchPart3) {
                    ((IWorkbenchPart3)this.legacyPart).removePartPropertyListener(this.partPropertyChangeListener);
                }
                this.legacyPart.dispose();
            }
            catch (Exception e) {
                WorkbenchPlugin.log(e);
            }
            this.legacyPart = null;
        }
    }

    public void setPinned(boolean newPinned) {
        if (this.isDisposed()) {
            return;
        }
        if (newPinned == this.pinned) {
            return;
        }
        this.pinned = newPinned;
        this.setImageDescriptor(this.computeImageDescriptor());
        this.fireInternalPropertyChange(531);
    }

    public boolean isPinned() {
        return this.pinned;
    }

    public String getPartProperty(String key) {
        if (this.legacyPart != null) {
            if (this.legacyPart instanceof IWorkbenchPart3) {
                return ((IWorkbenchPart3)this.legacyPart).getPartProperty(key);
            }
        } else {
            return (String)this.propertyCache.get(key);
        }
        return null;
    }

    public void addPartPropertyListener(IPropertyChangeListener listener) {
        if (this.isDisposed()) {
            return;
        }
        this.partChangeListeners.add((Object)listener);
    }

    public void removePartPropertyListener(IPropertyChangeListener listener) {
        if (this.isDisposed()) {
            return;
        }
        this.partChangeListeners.remove((Object)listener);
    }

    protected void firePartPropertyChange(PropertyChangeEvent event) {
        Object[] l = this.partChangeListeners.getListeners();
        int i = 0;
        while (i < l.length) {
            ((IPropertyChangeListener)l[i]).propertyChange(event);
            ++i;
        }
    }

    protected void createPartProperties(IWorkbenchPart3 workbenchPart) {
        for (Map.Entry e : this.propertyCache.entrySet()) {
            workbenchPart.setPartProperty((String)e.getKey(), (String)e.getValue());
        }
    }

    public int computePreferredSize(boolean width, int availableParallel, int availablePerpendicular, int preferredResult) {
        ISizeProvider sizeProvider = (ISizeProvider)Util.getAdapter(this.legacyPart, ISizeProvider.class);
        if (sizeProvider != null) {
            return sizeProvider.computePreferredSize(width, availableParallel, availablePerpendicular, preferredResult);
        }
        return preferredResult;
    }

    public int getSizeFlags(boolean width) {
        ISizeProvider sizeProvider = (ISizeProvider)Util.getAdapter(this.legacyPart, ISizeProvider.class);
        if (sizeProvider != null) {
            return sizeProvider.getSizeFlags(width);
        }
        return 0;
    }

    public IWorkbenchPage getPage() {
        return this.page;
    }

    public String getPartName() {
        return this.part.getLocalizedLabel();
    }

    public String getContentDescription() {
        IWorkbenchPart workbenchPart = this.getPart(false);
        if (workbenchPart instanceof IWorkbenchPart2) {
            return ((IWorkbenchPart2)workbenchPart).getContentDescription();
        }
        return workbenchPart.getTitle();
    }

    public boolean isDirty() {
        IWorkbenchPart part = this.getPart(false);
        if (part instanceof ISaveablePart) {
            return ((ISaveablePart)((Object)part)).isDirty();
        }
        return false;
    }

    public void invalidate() {
        this.legacyPart = null;
    }

    public final PartPane getPane() {
        return new PartPane(){

            public Control getControl() {
                return WorkbenchPartReference.this.part == null ? null : (Control)WorkbenchPartReference.this.part.getWidget();
            }
        };
    }
}

