/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.core.di.internal.extensions;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.e4.core.di.IInjector;
import org.eclipse.e4.core.di.extensions.Preference;
import org.eclipse.e4.core.di.internal.extensions.DIEActivator;
import org.eclipse.e4.core.di.suppliers.ExtendedObjectSupplier;
import org.eclipse.e4.core.di.suppliers.IObjectDescriptor;
import org.eclipse.e4.core.di.suppliers.IRequestor;
import org.osgi.framework.FrameworkUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PreferencesObjectSupplier
extends ExtendedObjectSupplier {
    private Map<String, List<PrefInjectionListener>> listenerCache = new HashMap<String, List<PrefInjectionListener>>();

    public PreferencesObjectSupplier() {
        DIEActivator.getDefault().registerPreferencesSupplier(this);
    }

    public Object get(IObjectDescriptor descriptor, IRequestor requestor, boolean track, boolean group) {
        if (descriptor == null) {
            return null;
        }
        Class<?> descriptorsClass = this.getDesiredClass(descriptor.getDesiredType());
        String nodePath = this.getNodePath(descriptor, requestor.getRequestingObject());
        if (IEclipsePreferences.class.equals(descriptorsClass)) {
            return new InstanceScope().getNode(nodePath);
        }
        String key = this.getKey(descriptor);
        if (key == null || nodePath == null || key.length() == 0 || nodePath.length() == 0) {
            return IInjector.NOT_A_VALUE;
        }
        if (track) {
            this.addListener(nodePath, requestor);
        }
        if (descriptorsClass.isPrimitive()) {
            if (descriptorsClass.equals(Boolean.TYPE)) {
                return this.getPreferencesService().getBoolean(nodePath, key, false, null);
            }
            if (descriptorsClass.equals(Integer.TYPE)) {
                return this.getPreferencesService().getInt(nodePath, key, 0, null);
            }
            if (descriptorsClass.equals(Double.TYPE)) {
                return this.getPreferencesService().getDouble(nodePath, key, 0.0, null);
            }
            if (descriptorsClass.equals(Float.TYPE)) {
                return Float.valueOf(this.getPreferencesService().getFloat(nodePath, key, 0.0f, null));
            }
            if (descriptorsClass.equals(Long.TYPE)) {
                return this.getPreferencesService().getLong(nodePath, key, 0L, null);
            }
        }
        if (String.class.equals(descriptorsClass)) {
            return this.getPreferencesService().getString(nodePath, key, null, null);
        }
        if (Boolean.class.equals(descriptorsClass)) {
            return this.getPreferencesService().getBoolean(nodePath, key, false, null);
        }
        if (Boolean.class.equals(descriptorsClass)) {
            return this.getPreferencesService().getBoolean(nodePath, key, false, null);
        }
        if (Integer.class.equals(descriptorsClass)) {
            return this.getPreferencesService().getInt(nodePath, key, 0, null);
        }
        if (Double.class.equals(descriptorsClass)) {
            return this.getPreferencesService().getDouble(nodePath, key, 0.0, null);
        }
        if (Float.class.equals(descriptorsClass)) {
            return Float.valueOf(this.getPreferencesService().getFloat(nodePath, key, 0.0f, null));
        }
        if (Long.class.equals(descriptorsClass)) {
            return this.getPreferencesService().getLong(nodePath, key, 0L, null);
        }
        return this.getPreferencesService().getString(nodePath, key, null, null);
    }

    private Class<?> getDesiredClass(Type desiredType) {
        Type rawType;
        if (desiredType instanceof Class) {
            return (Class)desiredType;
        }
        if (desiredType instanceof ParameterizedType && (rawType = ((ParameterizedType)desiredType).getRawType()) instanceof Class) {
            return (Class)rawType;
        }
        return null;
    }

    private String getKey(IObjectDescriptor descriptor) {
        if (descriptor == null) {
            return null;
        }
        Preference qualifier = (Preference)descriptor.getQualifier(Preference.class);
        return qualifier.value();
    }

    private String getNodePath(IObjectDescriptor descriptor, Object requestingObject) {
        if (descriptor == null) {
            return null;
        }
        Preference qualifier = (Preference)descriptor.getQualifier(Preference.class);
        String nodePath = qualifier.nodePath();
        if (nodePath == null || nodePath.length() == 0) {
            if (requestingObject == null) {
                return null;
            }
            nodePath = FrameworkUtil.getBundle(requestingObject.getClass()).getSymbolicName();
        }
        return nodePath;
    }

    private IPreferencesService getPreferencesService() {
        return DIEActivator.getDefault().getPreferencesService();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addListener(String nodePath, IRequestor requestor) {
        PrefInjectionListener listener2;
        if (requestor == null) {
            return;
        }
        Map<String, List<PrefInjectionListener>> map = this.listenerCache;
        synchronized (map) {
            if (this.listenerCache.containsKey(nodePath)) {
                for (PrefInjectionListener listener2 : this.listenerCache.get(nodePath)) {
                    IRequestor previousRequestor = listener2.getRequestor();
                    if (!previousRequestor.equals(requestor)) continue;
                    return;
                }
            }
        }
        IEclipsePreferences node = new InstanceScope().getNode(nodePath);
        listener2 = new PrefInjectionListener(node, requestor);
        node.addPreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)listener2);
        Map<String, List<PrefInjectionListener>> map2 = this.listenerCache;
        synchronized (map2) {
            if (this.listenerCache.containsKey(nodePath)) {
                this.listenerCache.get(nodePath).add(listener2);
            } else {
                ArrayList<PrefInjectionListener> listeningRequestors = new ArrayList<PrefInjectionListener>();
                listeningRequestors.add(listener2);
                this.listenerCache.put(nodePath, listeningRequestors);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllListeners() {
        Map<String, List<PrefInjectionListener>> map = this.listenerCache;
        synchronized (map) {
            for (List<PrefInjectionListener> listeners : this.listenerCache.values()) {
                if (listeners == null) continue;
                for (PrefInjectionListener listener : listeners) {
                    listener.stopListening();
                }
            }
            this.listenerCache.clear();
        }
    }

    private static class PrefInjectionListener
    implements IEclipsePreferences.IPreferenceChangeListener {
        private final IRequestor requestor;
        private final IEclipsePreferences node;

        public PrefInjectionListener(IEclipsePreferences node, IRequestor requestor) {
            this.node = node;
            this.requestor = requestor;
        }

        public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
            if (!this.requestor.isValid()) {
                this.node.removePreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this);
                return;
            }
            this.requestor.resolveArguments(false);
            this.requestor.execute();
        }

        public IRequestor getRequestor() {
            return this.requestor;
        }

        public void stopListening() {
            this.node.removePreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this);
        }
    }
}

