/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.core.internal.contexts.debug.ui;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.e4.core.internal.contexts.Computation;
import org.eclipse.e4.core.internal.contexts.EclipseContext;
import org.eclipse.e4.core.internal.contexts.debug.ui.AllocationRecorder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContextSnapshot {
    private Map<EclipseContext, Set<Computation>> snapshotOriginal = this.record();

    private Map<EclipseContext, Set<Computation>> record() {
        HashMap<EclipseContext, Set<Computation>> snapshot = new HashMap<EclipseContext, Set<Computation>>();
        Set<EclipseContext> contexts = AllocationRecorder.getDefault().getContexts();
        for (EclipseContext context : contexts) {
            this.record(snapshot, context);
        }
        return snapshot;
    }

    private void record(Map<EclipseContext, Set<Computation>> snapshot, EclipseContext context) {
        Set listeners = context.getListeners();
        HashSet localListeners = new HashSet(listeners.size());
        localListeners.addAll(listeners);
        snapshot.put(context, localListeners);
        Set children = context.getChildren();
        if (children == null) {
            return;
        }
        for (EclipseContext child : context.getChildren()) {
            this.record(snapshot, child);
        }
    }

    public Map<EclipseContext, Set<Computation>> diff() {
        EclipseContext context;
        Map<EclipseContext, Set<Computation>> snapshotNew = this.record();
        Iterator<EclipseContext> i = snapshotNew.keySet().iterator();
        while (i.hasNext()) {
            context = i.next();
            if (this.snapshotOriginal.containsKey(context)) continue;
            i.remove();
        }
        i = snapshotNew.keySet().iterator();
        while (i.hasNext()) {
            context = i.next();
            Set<Computation> oldComputation = this.snapshotOriginal.get(context);
            Set<Computation> newComputation = snapshotNew.get(context);
            newComputation.removeAll(oldComputation);
            if (!newComputation.isEmpty()) continue;
            i.remove();
        }
        if (snapshotNew.isEmpty()) {
            return null;
        }
        return snapshotNew;
    }
}

