/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.internal.workbench;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.internal.workbench.SelectionServiceImpl;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.e4.ui.workbench.modeling.ESelectionService;
import org.eclipse.e4.ui.workbench.modeling.ISelectionListener;

public class PartSelectionServiceImpl
implements ESelectionService {
    private ListenerList genericListeners = new ListenerList();
    private Map<String, ListenerList> targetedListeners = new HashMap<String, ListenerList>();
    private MPart part;
    private IEclipseContext context;
    private EPartService partService;

    @Inject
    PartSelectionServiceImpl(MPart part, IEclipseContext context, EPartService partService) {
        this.part = part;
        this.context = context;
        this.partService = partService;
    }

    @PreDestroy
    void dispose() {
        this.genericListeners.clear();
        this.targetedListeners.clear();
    }

    private SelectionServiceImpl getWorkbenchWindowService() {
        MWindow tmp = (MWindow)this.context.get(MWindow.class);
        if (tmp == null) {
            throw new IllegalStateException("No workbench window found for this part");
        }
        MWindow window = null;
        while (tmp != null) {
            window = tmp;
            tmp = (MWindow)tmp.getContext().getParent().get(MWindow.class);
        }
        return (SelectionServiceImpl)window.getContext().get(ESelectionService.class);
    }

    public void setSelection(Object selection) {
        if (selection != null) {
            this.context.set("output.selection", selection);
            if (this.partService.getActivePart() == this.part) {
                this.getWorkbenchWindowService().internalSetSelection(selection);
            }
        } else {
            this.context.remove("output.selection");
            if (this.partService.getActivePart() == this.part) {
                this.getWorkbenchWindowService().internalSetSelection(selection);
            }
        }
    }

    public Object getSelection() {
        return this.getWorkbenchWindowService().getSelection();
    }

    public Object getSelection(String partId) {
        return this.getWorkbenchWindowService().getSelection(partId);
    }

    public void addSelectionListener(ISelectionListener listener) {
        this.genericListeners.add((Object)listener);
        this.getWorkbenchWindowService().addSelectionListener(listener);
    }

    public void removeSelectionListener(ISelectionListener listener) {
        this.genericListeners.remove((Object)listener);
        this.getWorkbenchWindowService().removeSelectionListener(listener);
    }

    public void addSelectionListener(String partId, ISelectionListener listener) {
        ListenerList listeners = this.targetedListeners.get(partId);
        if (listeners == null) {
            listeners = new ListenerList();
            this.targetedListeners.put(partId, listeners);
        }
        listeners.add((Object)listener);
        this.getWorkbenchWindowService().addSelectionListener(partId, listener);
    }

    public void removeSelectionListener(String partId, ISelectionListener listener) {
        ListenerList listeners = this.targetedListeners.get(partId);
        if (listeners != null) {
            listeners.remove((Object)listener);
        }
        this.getWorkbenchWindowService().removeSelectionListener(partId, listener);
    }
}

