/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.core.internal.contexts;

import java.util.List;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.contexts.RunAndTrack;
import org.eclipse.e4.core.internal.contexts.Computation;
import org.eclipse.e4.core.internal.contexts.ContextChangeEvent;
import org.eclipse.e4.core.internal.contexts.EclipseContext;
import org.eclipse.e4.core.internal.contexts.RunAndTrackExt;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TrackableComputationExt
extends Computation {
    private final IEclipseContext originatingContext;
    private RunAndTrack runnable;
    private ContextChangeEvent cachedEvent;

    public TrackableComputationExt(RunAndTrack runnable, IEclipseContext originatingContext) {
        this.runnable = runnable;
        this.originatingContext = originatingContext;
    }

    @Override
    public int hashCode() {
        return 31 + (this.runnable == null ? 0 : this.runnable.hashCode());
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TrackableComputationExt other = (TrackableComputationExt)obj;
        return !(this.runnable == null ? other.runnable != null : !this.runnable.equals(other.runnable));
    }

    @Override
    protected void doHandleInvalid(ContextChangeEvent event, List<EclipseContext.Scheduled> scheduledList) {
        int eventType = event.getEventType();
        if (eventType == 0 || eventType == 3) {
            this.update(event);
        } else {
            scheduledList.add(new EclipseContext.Scheduled(this, event));
        }
    }

    public boolean update(ContextChangeEvent event) {
        int eventType = event.getEventType();
        if (this.runnable instanceof RunAndTrackExt && ((RunAndTrackExt)this.runnable).batchProcess() && (eventType == 1 || eventType == 2)) {
            this.cachedEvent = event;
            EclipseContext eventsContext = (EclipseContext)event.getContext();
            eventsContext.addWaiting(this);
            return true;
        }
        Computation oldComputation = EclipseContext.localComputation().get();
        EclipseContext.localComputation().set(this);
        boolean result = true;
        try {
            if (this.cachedEvent != null) {
                if (this.runnable instanceof RunAndTrackExt) {
                    result = ((RunAndTrackExt)this.runnable).update(event.getContext(), event.getEventType(), event.getArguments());
                } else if (eventType == 3 && eventType != 4) {
                    result = this.runnable.changed(this.cachedEvent.getContext());
                }
                this.cachedEvent = null;
            }
            if (eventType != 5) {
                if (this.runnable instanceof RunAndTrackExt) {
                    result = ((RunAndTrackExt)this.runnable).update(event.getContext(), event.getEventType(), event.getArguments());
                } else if (eventType != 3 && eventType != 4) {
                    result = this.runnable.changed(event.getContext());
                }
            }
        }
        finally {
            EclipseContext.localComputation().set(oldComputation);
        }
        EclipseContext eventsContext = (EclipseContext)event.getContext();
        if (eventType == 3 && this.originatingContext.equals(eventsContext)) {
            this.removeAll();
            return false;
        }
        if (result) {
            this.startListening();
        } else {
            this.removeAll();
        }
        return result;
    }

    public String toString() {
        return this.runnable.toString();
    }

    public void startAccessRecording() {
        EclipseContext.localComputation().set(this);
    }

    public void stopAccessRecording() {
        EclipseContext.localComputation().set(null);
    }
}

