/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.preferences;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.css.swt.internal.theme.ThemeEngine;
import org.eclipse.e4.ui.css.swt.theme.ITheme;
import org.eclipse.e4.ui.css.swt.theme.IThemeEngine;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.EditorReference;
import org.eclipse.ui.internal.WorkbenchPage;
import org.eclipse.ui.internal.tweaklets.PreferencePageEnhancer;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.xtext.ui.editor.XtextEditor;

public class CSSEditorPreferences
extends PreferencePageEnhancer {
    ITheme selection;
    XtextEditor cssEditor;
    IThemeEngine engine;
    boolean resetCurrentTheme;

    public void createContents(Composite parent) {
        this.resetCurrentTheme = false;
        IWorkbenchWindow wbw = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        MWindow hostWin = (MWindow)wbw.getService(MWindow.class);
        EPartService partService = (EPartService)hostWin.getContext().get(EPartService.class);
        EModelService modelService = (EModelService)hostWin.getContext().get(EModelService.class);
        MPart editor = partService.createPart("org.eclipse.e4.ui.compatibility.editor");
        this.engine = (IThemeEngine)hostWin.getContext().get(IThemeEngine.class);
        IFile file = this.updateInput();
        FileEditorInput input = new FileEditorInput(file);
        IWorkbenchPage wbPage = wbw.getActivePage();
        EditorReference reference = ((WorkbenchPage)wbPage).createEditorReferenceForPart(editor, (IEditorInput)input, "org.eclipse.e4.CSS", null);
        IEclipseContext localContext = hostWin.getContext().createChild();
        localContext.set(IEditorInput.class, (Object)input);
        localContext.set(EditorReference.class, (Object)reference);
        Composite composite3 = new Composite(parent, 2048);
        composite3.setLayout((Layout)new FillLayout());
        GridData data = new GridData(4, 4, true, true, 2, 2);
        data.widthHint = 500;
        data.heightHint = 500;
        composite3.setLayoutData((Object)data);
        modelService.hostElement((MUIElement)editor, hostWin, (Object)composite3, localContext);
        partService.activate(editor);
        IEditorPart tmpEditor = (IEditorPart)editor.getContext().get(IEditorPart.class);
        if (tmpEditor instanceof XtextEditor) {
            this.cssEditor = (XtextEditor)tmpEditor;
        }
    }

    public void setSelection(Object sel) {
        if (sel instanceof ITheme) {
            ITheme newTheme = (ITheme)sel;
            ITheme oldSelection = this.selection;
            this.selection = newTheme;
            if (oldSelection != null && !newTheme.getId().equals(oldSelection.getId())) {
                IFile file = this.updateInput();
                FileEditorInput input = new FileEditorInput(file);
                this.cssEditor.setInput((IEditorInput)input);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public void performOK() {
        if (this.cssEditor.isDirty()) {
            block26: {
                docProvider = this.cssEditor.getDocumentProvider();
                editorInput = this.cssEditor.getEditorInput();
                doc = docProvider.getDocument((Object)editorInput);
                more = doc.get();
                configLocation = Platform.getConfigurationLocation();
                e4CSSPath = null;
                try {
                    locationURL = new URL(configLocation.getDataArea("org.eclipse.e4.ui.css.swt.theme").toString());
                    locationFile = new File(locationURL.getFile());
                    e4CSSPath = locationFile.getPath();
                    if (!locationFile.exists()) {
                        locationFile.mkdirs();
                    }
                }
                catch (IOException v0) {}
                path = new Path(String.valueOf(e4CSSPath) + System.getProperty("file.separator") + editorInput.getName());
                bytes = more.getBytes();
                outputStream = null;
                try {
                    outputStream = new FileOutputStream(path.toOSString());
                    outputStream.write(bytes, 0, bytes.length);
                }
                catch (FileNotFoundException v1) {
                    if (outputStream != null) {
                        try {
                            outputStream.close();
                        }
                        catch (IOException v2) {}
                    }
                    break block26;
                }
                catch (IOException v3) {
                    try {
                        ** if (outputStream == null) goto lbl-1000
                    }
                    catch (Throwable var10_10) {
                        if (outputStream != null) {
                            try {
                                outputStream.close();
                            }
                            catch (IOException v5) {}
                        }
                        throw var10_10;
                    }
lbl-1000:
                    // 1 sources

                    {
                        try {
                            outputStream.close();
                        }
                        catch (IOException v4) {}
                    }
lbl-1000:
                    // 2 sources

                    {
                        break block26;
                    }
                }
                if (outputStream == null) break block26;
                try {
                    outputStream.close();
                }
                catch (IOException v6) {}
            }
            if (this.engine instanceof ThemeEngine) {
                styleSheets = new ArrayList<String>();
                try {
                    styleSheetURL = path.toFile().toURI().toURL();
                    styleSheets.add(styleSheetURL.toString());
                    ((ThemeEngine)this.engine).themeModified(this.selection, styleSheets);
                }
                catch (MalformedURLException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            this.cssEditor.doRevertToSaved();
        }
        if (this.resetCurrentTheme) {
            ((ThemeEngine)this.engine).resetCurrentTheme();
            this.resetCurrentTheme = false;
        }
    }

    IFile updateInput() {
        IProject newProject = ResourcesPlugin.getWorkspace().getRoot().getProject(".e4css");
        URL styleSheetURL = null;
        File modFile = null;
        if (this.engine instanceof ThemeEngine) {
            List ss = ((ThemeEngine)this.engine).getStylesheets(this.selection);
            List mod = ((ThemeEngine)this.engine).getModifiedStylesheets(this.selection);
            if (mod.size() > 0) {
                ss = mod;
            }
            if (ss.size() > 0) {
                String path = (String)ss.get(0);
                try {
                    styleSheetURL = FileLocator.toFileURL((URL)new URL(path));
                    modFile = new File(styleSheetURL.toURI());
                }
                catch (MalformedURLException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                catch (URISyntaxException e) {
                    e.printStackTrace();
                }
            }
        }
        IProjectDescription desc = newProject.getWorkspace().newProjectDescription(newProject.getName());
        IFile file = null;
        try {
            if (!newProject.exists()) {
                newProject.create(desc, null);
            }
            if (!newProject.isOpen()) {
                newProject.open(null);
            }
            newProject.setHidden(true);
            Path location = new Path(modFile.getPath());
            file = newProject.getFile(location.lastSegment());
            file.delete(true, null);
            if (!file.exists()) {
                file.createLink((IPath)location, 0, null);
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return file;
    }

    public void performCancel() {
        if (this.cssEditor.isDirty()) {
            this.cssEditor.doRevertToSaved();
        }
    }

    public void performDefaults() {
        List mod = ((ThemeEngine)this.engine).getModifiedStylesheets(this.selection);
        if (mod.size() > 0) {
            String path = (String)mod.get(0);
            try {
                URL styleSheetURL = FileLocator.toFileURL((URL)new URL(path));
                File file = new File(styleSheetURL.getFile());
                if (file.exists()) {
                    file.delete();
                }
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (this.engine instanceof ThemeEngine) {
            ((ThemeEngine)this.engine).resetModifiedStylesheets(this.selection);
        }
        IFile file = this.updateInput();
        FileEditorInput input = new FileEditorInput(file);
        this.cssEditor.setInput((IEditorInput)input);
        this.resetCurrentTheme = true;
    }
}

