/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources.semantic.ui;

import org.eclipse.core.internal.resources.semantic.ui.KeyValuePair;
import org.eclipse.core.internal.resources.semantic.ui.Messages;
import org.eclipse.core.internal.resources.semantic.ui.PropertiesContentProvider;
import org.eclipse.core.internal.resources.semantic.ui.PropertiesLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.MenuDetectEvent;
import org.eclipse.swt.events.MenuDetectListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.tabbed.AbstractPropertySection;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class PropertySection
extends AbstractPropertySection {
    TreeViewer tv;

    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createControls(parent, aTabbedPropertySheetPage);
        this.tv = new TreeViewer(parent, 65538);
        PropertiesContentProvider.initTree(this.tv, 400);
        this.tv.setLabelProvider((IBaseLabelProvider)new PropertiesLabelProvider());
        this.tv.setContentProvider((IContentProvider)new PropertiesContentProvider());
        this.tv.getTree().addMenuDetectListener(new MenuDetectListener(){

            public void menuDetected(MenuDetectEvent e) {
                PropertySection.this.buildMenu(PropertySection.this.tv.getTree(), e);
            }
        });
    }

    public void setInput(IWorkbenchPart part, ISelection selection) {
        IStructuredSelection ssel = (IStructuredSelection)selection;
        if (ssel.size() == 1) {
            this.tv.setInput(ssel.getFirstElement());
            this.tv.expandAll();
        } else {
            this.tv.setInput(null);
        }
    }

    public boolean shouldUseExtraSpace() {
        return true;
    }

    void buildMenu(Tree tree, MenuDetectEvent e) {
        Menu menu = tree.getMenu();
        if (menu != null) {
            menu.dispose();
        }
        menu = new Menu((Control)tree);
        tree.setMenu(menu);
        MenuItem menuItem = new MenuItem(menu, 8);
        menuItem.setText(Messages.PropertySection_Refresh_XMIT);
        menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                PropertySection.this.refresh();
            }
        });
        final TreeItem[] selected = tree.getSelection();
        if (selected.length == 1 && selected[0].getData() instanceof KeyValuePair) {
            new MenuItem(menu, 2);
            final KeyValuePair kvp = (KeyValuePair)selected[0].getData();
            menuItem = new MenuItem(menu, 8);
            menuItem.setText(Messages.PropertySection_CopyValue_XMIT);
            menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    Clipboard clip = null;
                    try {
                        clip = new Clipboard(Display.getCurrent());
                        clip.setContents((Object[])new String[]{kvp.getValue()}, new Transfer[]{TextTransfer.getInstance()});
                    }
                    finally {
                        if (clip != null) {
                            clip.dispose();
                        }
                    }
                }
            });
            menuItem = new MenuItem(menu, 8);
            menuItem.setText(Messages.PropertySection_CopyKeyAndValue_XMIT);
            menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    Clipboard clip = null;
                    try {
                        clip = new Clipboard(Display.getCurrent());
                        clip.setContents((Object[])new String[]{String.valueOf(kvp.getKey()) + "\t" + kvp.getValue()}, new Transfer[]{TextTransfer.getInstance()});
                    }
                    finally {
                        if (clip != null) {
                            clip.dispose();
                        }
                    }
                }
            });
        } else if (selected.length > 1) {
            final String linebreak = System.getProperty("line.separator");
            menu = new Menu((Control)tree);
            tree.setMenu(menu);
            MenuItem item = new MenuItem(menu, 8);
            item.setText(Messages.SemanticResourcePropertyPage_CopySelection_XMIT);
            item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    StringBuilder sb = new StringBuilder();
                    TreeItem[] treeItemArray = selected;
                    int n = selected.length;
                    int n2 = 0;
                    while (n2 < n) {
                        TreeItem actItem = treeItemArray[n2];
                        if (actItem.getData() instanceof KeyValuePair) {
                            KeyValuePair pair = (KeyValuePair)actItem.getData();
                            sb.append(String.valueOf(pair.getKey()) + "\t" + pair.getValue());
                            sb.append(linebreak);
                        } else if (actItem.getData() instanceof String) {
                            sb.append((String)actItem.getData());
                            sb.append(linebreak);
                        }
                        ++n2;
                    }
                    if (sb.length() > linebreak.length()) {
                        sb.setLength(sb.length() - linebreak.length());
                    }
                    Clipboard clip = null;
                    try {
                        clip = new Clipboard(Display.getCurrent());
                        clip.setContents((Object[])new String[]{sb.toString()}, new Transfer[]{TextTransfer.getInstance()});
                    }
                    finally {
                        if (clip != null) {
                            clip.dispose();
                        }
                    }
                }
            });
        }
    }
}

