/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.resources.semantic.test.provider;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.core.resources.semantic.SyncDirection;
import org.eclipse.core.resources.semantic.spi.ContentProvider;
import org.eclipse.core.resources.semantic.spi.ISemanticFileStore;
import org.eclipse.core.resources.semantic.spi.ISemanticSpiResourceInfo;
import org.eclipse.core.resources.semantic.spi.SemanticSpiResourceInfo;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;

public class FederatedContentProvider
extends ContentProvider {
    private static final QualifiedName READONLY = new QualifiedName("org.eclipse.core.resources.semantic.test", "ReadOnly");
    private static final QualifiedName TIMESTAMP = new QualifiedName("org.eclipse.core.resources.semantic.test", "Timestamp");

    public void addResource(ISemanticFileStore parentStore, String name, ISemanticFileStore.ResourceType resourceType, IProgressMonitor monitor) throws CoreException {
        switch (resourceType) {
            case FILE_TYPE: {
                parentStore.addChildFile(name);
                ISemanticFileStore newChild = (ISemanticFileStore)parentStore.getChild(name);
                this.setTimestamp(newChild, System.currentTimeMillis());
                this.setReadOnly(newChild, true, monitor);
                break;
            }
            case FOLDER_TYPE: {
                parentStore.addChildFolder(name);
                ISemanticFileStore newChild = (ISemanticFileStore)parentStore.getChild(name);
                this.setTimestamp(newChild, System.currentTimeMillis());
                this.setReadOnly(newChild, true, monitor);
                break;
            }
            default: {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.core.resources.semantic", "Can not add resource of type " + resourceType.name()));
            }
        }
    }

    public ISemanticSpiResourceInfo fetchResourceInfo(ISemanticFileStore semanticFileStore, int options, IProgressMonitor monitor) throws CoreException {
        return new SemanticSpiResourceInfo(options, false, false, semanticFileStore.getPersistentProperty(READONLY) != null, true, null, null);
    }

    public long getResourceTimestamp(ISemanticFileStore semanticFileStore, IProgressMonitor monitor) throws CoreException {
        return this.getTimestampe(semanticFileStore);
    }

    public InputStream openInputStream(ISemanticFileStore semanticFileStore, IProgressMonitor monitor) {
        return new ByteArrayInputStream(new byte[0]);
    }

    public OutputStream openOutputStream(ISemanticFileStore childStore, int options, IProgressMonitor monitor) {
        return new OutputStream(){

            public void write(int b) {
            }

            public void close() throws IOException {
                super.close();
            }
        };
    }

    public void removeResource(ISemanticFileStore semanticFileStore, IProgressMonitor monitor) throws CoreException {
        semanticFileStore.remove(monitor);
    }

    public void revertChanges(ISemanticFileStore semanticFileStore, IProgressMonitor monitor) {
        throw new RuntimeException("Not supported");
    }

    public void setReadOnly(ISemanticFileStore semanticFileStore, boolean readonly, IProgressMonitor monitor) throws CoreException {
        if (readonly) {
            semanticFileStore.setPersistentProperty(READONLY, "");
        } else {
            semanticFileStore.setPersistentProperty(READONLY, null);
        }
    }

    public void setResourceTimestamp(ISemanticFileStore semanticFileStore, long timestamp, IProgressMonitor monitor) throws CoreException {
        this.setTimestamp(semanticFileStore, timestamp);
    }

    public void synchronizeContentWithRemote(ISemanticFileStore semanticFileStore, SyncDirection direction, IProgressMonitor monitor, MultiStatus status) {
        throw new RuntimeException("Not supported");
    }

    public IStatus validateEdit(ISemanticFileStore[] stores, Object shell) {
        MultiStatus multi = new MultiStatus("org.eclipse.core.resources.semantic.test", 0, "Validate Edit Result", null);
        ISemanticFileStore[] iSemanticFileStoreArray = stores;
        int n = stores.length;
        int n2 = 0;
        while (n2 < n) {
            ISemanticFileStore store = iSemanticFileStoreArray[n2];
            try {
                store.setPersistentProperty(READONLY, null);
            }
            catch (CoreException e) {
                multi.add(e.getStatus());
            }
            ++n2;
        }
        return multi;
    }

    public IStatus validateSave(ISemanticFileStore semanticFileStore) {
        return new Status(0, "org.eclipse.core.resources.semantic.test", "");
    }

    private void setTimestamp(ISemanticFileStore store, long currentTimeMillis) throws CoreException {
        store.setPersistentProperty(TIMESTAMP, Long.toString(currentTimeMillis));
    }

    private long getTimestampe(ISemanticFileStore store) throws CoreException {
        String test = store.getPersistentProperty(TIMESTAMP);
        if (test == null) {
            return 0L;
        }
        try {
            return Long.parseLong(test);
        }
        catch (NumberFormatException numberFormatException) {
            return 0L;
        }
    }
}

