/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.resources.semantic.examples.providers;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;

public class RESTUtil {
    private static final Object FILE_SCHEME = "file";

    public static InputStream openInputStream(String remoteURI, IRESTCallback setter) throws IOException {
        URI uri = URI.create(remoteURI);
        URL url = uri.toURL();
        URLConnection conn = url.openConnection();
        if (setter != null) {
            if (conn.getLastModified() != 0L) {
                setter.setTimestamp(conn.getLastModified());
            } else {
                setter.setTimestamp(conn.getDate());
            }
            setter.setContentType(conn.getContentType());
        }
        return conn.getInputStream();
    }

    public static OutputStream openOutputStream(String remoteURI) throws IOException {
        URI uri = URI.create(remoteURI);
        if (uri.getScheme().equals(FILE_SCHEME)) {
            File file = new File(uri);
            if (file.exists()) {
                file.delete();
            }
            return new FileOutputStream(file);
        }
        URL url = uri.toURL();
        URLConnection conn = url.openConnection();
        conn.setDoOutput(true);
        return conn.getOutputStream();
    }

    public static void setTimestamp(String remoteURI, long timestamp) throws IOException {
        File file;
        URI uri = URI.create(remoteURI);
        if (uri.getScheme().equals(FILE_SCHEME) && (file = new File(uri)).exists()) {
            file.setLastModified(timestamp);
        }
    }

    public static StringBuffer readStreamIntoStringBuffer(InputStream is, String encoding) throws IOException {
        int len;
        StringBuffer buf = new StringBuffer();
        char[] buffer = new char[4096];
        InputStreamReader r = new InputStreamReader(is, encoding);
        do {
            if ((len = r.read(buffer)) <= 0) continue;
            buf.append(buffer, 0, len);
        } while (len != -1);
        return buf;
    }

    public static interface IRESTCallback {
        public void setTimestamp(long var1);

        public void setContentType(String var1);
    }
}

