/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.xwt.tools.ui.designer.core.problems;

import org.eclipse.e4.xwt.tools.ui.designer.core.editor.Designer;
import org.eclipse.e4.xwt.tools.ui.designer.core.problems.IProblemChecker;
import org.eclipse.e4.xwt.tools.ui.designer.core.problems.Problem;
import org.eclipse.jface.text.IDocument;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.Node;

public abstract class DesignerProblemChecker
implements IProblemChecker {
    private Designer designer;

    protected Problem createError(Node node, String msg) {
        return this.createProblem(node, msg, 3);
    }

    protected Problem createProblem(Node node, String msg, int type) {
        int startOffset = 0;
        if (node instanceof IDOMNode) {
            startOffset = ((IDOMNode)node).getStartOffset();
        }
        int endOffset = 0;
        if (node instanceof IDOMNode) {
            endOffset = ((IDOMNode)node).getEndOffset();
        }
        int line = 0;
        return this.createProblem(msg, type, node, startOffset, endOffset, line);
    }

    protected Problem createProblem(String message, int type, Object source, int start, int end, int line) {
        Problem problem = new Problem(message, type);
        problem.setSource(source);
        problem.start = start;
        problem.end = end;
        problem.line = line;
        return problem;
    }

    protected IDOMDocument getTextDocument(IDocument doc) {
        IStructuredModel model = StructuredModelManager.getModelManager().getExistingModelForRead(doc);
        if (model != null && model instanceof IDOMModel) {
            return ((IDOMModel)model).getDocument();
        }
        return null;
    }

    public Designer getDesigner() {
        return this.designer;
    }

    public boolean isAdapterFor(Object type) {
        boolean isAdapter;
        boolean bl = isAdapter = type != null && type instanceof Designer;
        if (isAdapter) {
            this.designer = (Designer)((Object)type);
        }
        return isAdapter;
    }
}

