/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.xwt.ui.editor.render;

import org.eclipse.e4.xwt.ui.editor.render.ManagerContext;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.ScrollBar;

public class CanvasManager {
    private Image originalImage;
    private Canvas canvas;
    private Image displayImage;
    public int imageWidth = -1;
    public int imageHeight = -1;
    private int visibleWidth;
    private int visibleHeight;
    private ManagerContext displayMC = new ManagerContext();
    private ManagerContext imageMC = new ManagerContext();

    public CanvasManager(Canvas canvas) {
        this.canvas = canvas;
        this.initialize();
    }

    private void initialize() {
        ScrollBar vertical;
        this.displayMC.gc = new GC((Drawable)this.canvas);
        this.canvas.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent event) {
                CanvasManager.this.handlePaint(event);
            }
        });
        this.canvas.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent event) {
                CanvasManager.this.handleResize();
            }
        });
        ScrollBar horizontal = this.getHorizontalBar();
        if (horizontal != null) {
            horizontal.setVisible(true);
            horizontal.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    CanvasManager.this.scrollHorizontally((ScrollBar)event.widget);
                }
            });
        }
        if ((vertical = this.getVerticalBar()) != null) {
            vertical.setVisible(true);
            vertical.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    CanvasManager.this.scrollVertically((ScrollBar)event.widget);
                }
            });
        }
        this.canvas.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (((CanvasManager)CanvasManager.this).displayMC.gc != null) {
                    ((CanvasManager)CanvasManager.this).displayMC.gc.dispose();
                }
            }
        });
        this.handleResize();
    }

    public synchronized void setImage(Image image) {
        if (image != null) {
            this.originalImage = image;
            this.clearImage();
            this.createDisplayImage();
            this.canvas.redraw();
            this.canvas.getDisplay().update();
        }
    }

    private void createDisplayImage() {
        if (this.originalImage == null || this.originalImage.isDisposed()) {
            return;
        }
        Rectangle bounds = this.originalImage.getBounds();
        int width = bounds.width;
        int height = bounds.height;
        Rectangle rect = this.canvas.getBounds();
        this.imageWidth = Math.max(width + 17, rect.width);
        this.imageHeight = Math.max(height + 17, rect.height);
        this.displayImage = new Image((Device)this.canvas.getDisplay(), this.imageWidth, this.imageHeight);
        this.imageMC.gc = new GC((Drawable)this.displayImage);
        this.imageMC.gc.fillRectangle(0, 0, this.imageWidth, this.imageHeight);
        this.imageMC.gc.drawImage(this.originalImage, 0, 0, width, height, (this.imageWidth - width - 17) / 2, (this.imageHeight - height - 17) / 2, width, height);
        this.handleResize();
    }

    private void clearImage() {
        if (this.displayImage != null) {
            this.displayImage.dispose();
            this.displayImage = null;
        }
        if (this.imageMC.gc != null) {
            this.imageMC.gc.dispose();
            this.imageMC.gc = null;
        }
    }

    public void dispose() {
        this.canvas = null;
        this.clearImage();
        if (this.displayMC.gc != null) {
            this.displayMC.gc.dispose();
            this.displayMC = null;
        }
        if (this.displayImage != null) {
            this.displayImage.dispose();
        }
    }

    protected void scrollVertically(ScrollBar scrollBar) {
        int newOffset;
        int oldOffset;
        if (this.displayImage == null) {
            return;
        }
        if (this.imageHeight > this.visibleHeight && (oldOffset = this.displayMC.yOffset) != (newOffset = Math.min(scrollBar.getSelection(), this.imageHeight - this.visibleHeight))) {
            this.canvas.update();
            this.displayMC.yOffset = newOffset;
            this.canvas.scroll(0, Math.max(oldOffset - newOffset, 0), 0, Math.max(newOffset - oldOffset, 0), this.visibleWidth, this.visibleHeight, false);
        }
    }

    protected void scrollHorizontally(ScrollBar scrollBar) {
        int newOffset;
        int oldOffset;
        if (this.displayImage == null) {
            return;
        }
        if (this.imageWidth > this.visibleWidth && (oldOffset = this.displayMC.xOffset) != (newOffset = Math.min(scrollBar.getSelection(), this.imageWidth - this.visibleWidth))) {
            this.canvas.update();
            this.displayMC.xOffset = newOffset;
            this.canvas.scroll(Math.max(oldOffset - newOffset, 0), 0, Math.max(newOffset - oldOffset, 0), 0, this.visibleWidth, this.visibleHeight, false);
        }
    }

    protected void handleResize() {
        ScrollBar vertical;
        this.canvas.update();
        Rectangle visibleRect = this.canvas.getBounds();
        this.visibleWidth = visibleRect.width;
        this.visibleHeight = visibleRect.height;
        ScrollBar horizontal = this.getHorizontalBar();
        if (horizontal != null) {
            this.displayMC.xOffset = Math.min(horizontal.getSelection(), this.imageWidth - this.visibleWidth);
            if (this.imageWidth <= this.visibleWidth) {
                horizontal.setVisible(false);
                horizontal.setEnabled(false);
                horizontal.setSelection(0);
            } else {
                horizontal.setVisible(true);
                horizontal.setEnabled(true);
                horizontal.setValues(this.displayMC.xOffset, 0, this.imageWidth, this.visibleWidth, 8, this.visibleWidth);
            }
        }
        if ((vertical = this.getVerticalBar()) != null) {
            this.displayMC.yOffset = Math.min(vertical.getSelection(), this.imageHeight - this.visibleHeight);
            if (this.imageHeight <= this.visibleHeight) {
                vertical.setEnabled(false);
                vertical.setVisible(false);
                vertical.setSelection(0);
            } else {
                vertical.setEnabled(true);
                vertical.setVisible(true);
                vertical.setValues(this.displayMC.yOffset, 0, this.imageHeight, this.visibleHeight, 8, this.visibleHeight);
            }
        }
    }

    private ScrollBar getVerticalBar() {
        ScrollBar vertical = this.canvas.getVerticalBar();
        if (vertical == null) {
            vertical = this.canvas.getParent().getVerticalBar();
        }
        return vertical;
    }

    private ScrollBar getHorizontalBar() {
        ScrollBar horizontal = this.canvas.getHorizontalBar();
        if (horizontal == null) {
            horizontal = this.canvas.getParent().getHorizontalBar();
        }
        return horizontal;
    }

    private void handlePaint(PaintEvent event) {
        if (this.displayImage == null) {
            return;
        }
        int srcX = this.displayMC.xOffset + event.x;
        int srcY = this.displayMC.yOffset + event.y;
        srcX = srcX < 0 ? 0 : srcX;
        srcY = srcY < 0 ? 0 : srcY;
        Rectangle bounds = this.displayImage.getBounds();
        if (bounds.width - srcX < event.width || bounds.height - srcY < event.height) {
            this.createDisplayImage();
            this.handlePaint(event);
        } else {
            event.gc.drawImage(this.displayImage, srcX, srcY, event.width, event.height, event.x, event.y, event.width, event.height);
        }
    }
}

